/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature;

import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.feature.DataProfile;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dynobject.Tags;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataProfile
implements DataProfile {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractDataProfile.class);
    private final String id;
    private final String name;
    private final Class dataClass;
    private final DataProfile delegated;

    public AbstractDataProfile(String id, String name, Class dataClass) {
        this.id = id;
        this.name = name;
        this.dataClass = dataClass;
        DataManager dataManager = DALLocator.getDataManager();
        this.delegated = dataManager.getDataProfile(id);
    }

    public AbstractDataProfile(String name, Class dataClass) {
        this(name, name, dataClass);
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class getDataClass() {
        return this.dataClass;
    }

    @Override
    public Object createData(Object data, Tags tags) {
        Object x = this.doCreateData(data, tags);
        if (x == null && this.delegated != null) {
            x = this.delegated.createData(data, tags);
        }
        return x;
    }

    protected Object doCreateData(Object data, Tags tags) {
        return null;
    }

    @Override
    public Object coerce(DataType dataType, Object value, Tags tags) throws CoercionException {
        Object x = this.doCoerce(dataType, value, tags);
        if (x == null && this.delegated != null) {
            x = this.delegated.coerce(dataType, value, tags);
        }
        return x;
    }

    protected Object doCoerce(DataType dataType, Object value, Tags tags) throws CoercionException {
        return null;
    }
}

