/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.exception;

import org.gvsig.fmap.dal.exception.DataRuntimeException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.type.GeometryType;

public class UnsupportedGeometryException
extends DataRuntimeException {
    private static final long serialVersionUID = 2381749762973472962L;
    private static final String MESSAGE_FORMAT = "Unsupported geometry: '%(geomTypeName)'(%(geomType),%(geomSubtype)).";
    private static final String MESSAGE_KEY = "_UnsupportedGeometryException";

    public UnsupportedGeometryException(int geomType, int geomSubtype) {
        super(MESSAGE_FORMAT, MESSAGE_KEY, 2381749762973472962L);
        this.setValue("geomType", Integer.toString(geomType));
        this.setValue("geomSubtype", Integer.toString(geomSubtype));
        this.setValue("geomTypeName", "{unknow}");
        try {
            GeometryType type = GeometryLocator.getGeometryManager().getGeometryType(geomType, geomSubtype);
            this.setValue("geomTypeName", type.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public UnsupportedGeometryException(GeometryType geomType) {
        super(MESSAGE_FORMAT, MESSAGE_KEY, 2381749762973472962L);
        this.setValue("geomType", Integer.toString(geomType.getType()));
        this.setValue("geomSubtype", Integer.toString(geomType.getSubType()));
        this.setValue("geomTypeName", geomType.getName());
    }
}

