/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldconverter.legend.driver;

import java.io.File;
import java.io.IOException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.exceptions.IncompatibleLegendReadException;
import org.gvsig.fmap.mapcontext.exceptions.ReadLegendException;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.fmap.mapcontext.rendering.legend.IVectorLegend;
import org.gvsig.fmap.mapcontext.rendering.legend.driver.ILegendReader;
import org.gvsig.sldconverter.SLDConverterLocator;
import org.gvsig.sldconverter.SLDConverterManager;
import org.gvsig.sldsupport.SLDSupportLocator;
import org.gvsig.sldsupport.SLDSupportManager;
import org.gvsig.sldsupport.sld.SLDObject;
import org.gvsig.sldsupport.sld.SLDRoot;
import org.gvsig.sldsupport.sld.layer.SLDLayer;

public class LegendFromSLDReader
implements ILegendReader {
    public ILegend read(File inFile, int geometryType) throws ReadLegendException, IncompatibleLegendReadException, IOException {
        SLDSupportManager sldSupMan = null;
        sldSupMan = SLDSupportLocator.getInstance().getSLDSupportManager();
        if (sldSupMan == null) {
            throw new ReadLegendException(inFile, (Throwable)new Exception("No SLD support manager registered."));
        }
        SLDConverterManager sldConMan = null;
        sldConMan = SLDConverterLocator.getInstance().getSLDConverterManager();
        if (sldConMan == null) {
            throw new ReadLegendException(inFile, (Throwable)new Exception("No SLD conversion manager registered."));
        }
        SLDObject sldObj = null;
        try {
            sldObj = sldSupMan.read(inFile);
        }
        catch (Exception exc) {
            throw new ReadLegendException(inFile, (Throwable)exc);
        }
        if (!(sldObj instanceof SLDRoot)) {
            throw new ReadLegendException(inFile, (Throwable)new Exception("Unable to create SLD root element."));
        }
        SLDRoot root = (SLDRoot)sldObj;
        ILegend leg = null;
        if (root.getLayers() == null || root.getLayers().size() == 0) {
            throw new ReadLegendException(inFile, (Throwable)new Exception("Unable to create SLD layers."));
        }
        try {
            leg = sldConMan.toLegend((SLDLayer)root.getLayers().get(0));
        }
        catch (Exception exc) {
            throw new ReadLegendException(inFile, (Throwable)exc);
        }
        IVectorLegend vleg = null;
        if (leg instanceof IVectorLegend) {
            vleg = (IVectorLegend)leg;
            GeometryType foundgt = null;
            try {
                foundgt = GeometryLocator.getGeometryManager().getGeometryType(vleg.getShapeType(), 0);
            }
            catch (Exception exc) {
                throw new ReadLegendException(inFile, (Throwable)exc);
            }
            if (geometryType != 0 && !foundgt.isTypeOf(geometryType)) {
                throw new IncompatibleLegendReadException(inFile, geometryType, (Throwable)new Exception("Geometry type found: " + vleg.getShapeType()));
            }
        }
        return leg;
    }
}

