/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.selectiontools.app.extension.tools;

import java.awt.Cursor;
import java.awt.Image;
import java.awt.Toolkit;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Circle;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.MeasureEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.AbstractCircleListener;

public class CircleSelectionListener
extends AbstractCircleListener {
    private Cursor cur = null;
    private MapControl mapCtrl;

    public CircleSelectionListener(MapControl mc) {
        this.mapCtrl = mc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void circle(MeasureEvent event) throws BehaviorException {
        if (event.getEvent().getID() == 502) {
            double flatness;
            GeneralPathX gP;
            FLayer[] activeLayers = this.mapCtrl.getMapContext().getLayers().getActives();
            Surface geom = null;
            GeometryManager manager = GeometryLocator.getGeometryManager();
            try {
                Point center = (Point)manager.create(1, 0);
                center.setX(event.getXs()[0].doubleValue());
                center.setY(event.getYs()[0].doubleValue());
                Point point2 = (Point)manager.create(1, 0);
                point2.setX(event.getXs()[1].doubleValue());
                point2.setY(event.getYs()[1].doubleValue());
                double radious = center.distance((Geometry)point2);
                Circle circle = null;
                circle = (Circle)manager.create(11, 0);
                circle.setPoints(center, radious);
                geom = circle;
            }
            catch (CreateGeometryException e) {
                NotificationManager.showMessageError((String)PluginServices.getText(null, (String)"Failed_creating_geometry"), (Exception)((Object)e));
            }
            catch (GeometryOperationNotSupportedException e) {
                NotificationManager.showMessageError((String)PluginServices.getText(null, (String)"Operation_not_supported"), (Exception)((Object)e));
            }
            catch (GeometryOperationException e) {
                NotificationManager.showMessageError((String)PluginServices.getText(null, (String)"Failed_performing_the_operation"), (Exception)((Object)e));
            }
            if (geom == null) {
                return;
            }
            if (this.mapCtrl.getMapContext().getScaleView() < 500.0) {
                gP = new GeneralPathX();
                flatness = manager.getFlatness();
                flatness = this.mapCtrl.getMapContext().getScaleView() * flatness / 1000.0;
                gP.append(geom.getPathIterator(null, flatness), true);
                try {
                    geom = manager.createSurface(gP, 0);
                }
                catch (CreateGeometryException e) {
                    NotificationManager.showMessageError((String)PluginServices.getText(null, (String)"Failed_creating_geometry"), (Exception)((Object)e));
                }
            } else {
                gP = new GeneralPathX();
                flatness = manager.getFlatness();
                gP.append(geom.getPathIterator(null, flatness /= this.mapCtrl.getMapContext().getScaleView() * 2.0), true);
                try {
                    geom = manager.createSurface(gP, 0);
                }
                catch (CreateGeometryException e) {
                    NotificationManager.showMessageError((String)PluginServices.getText(null, (String)"Failed_creating_geometry"), (Exception)((Object)e));
                }
            }
            for (int i = 0; i < activeLayers.length; ++i) {
                FLayer layer = activeLayers[i];
                if (!layer.isAvailable() || !(layer instanceof FLyrVect)) continue;
                FLyrVect lyrVect = (FLyrVect)layer;
                FeatureSet newSelection = null;
                try {
                    newSelection = lyrVect.queryByGeometry((Geometry)geom, lyrVect.getFeatureStore().getDefaultFeatureType());
                    if (event.getEvent().isControlDown()) {
                        ((FeatureSelection)lyrVect.getDataStore().getSelection()).select(newSelection);
                        continue;
                    }
                    lyrVect.getFeatureStore().setSelection(newSelection);
                    continue;
                }
                catch (DataException e) {
                    NotificationManager.showMessageError((String)PluginServices.getText(null, (String)"Failed_selecting_geometries"), (Exception)((Object)e));
                    continue;
                }
                finally {
                    newSelection.dispose();
                }
            }
        }
    }

    public Cursor getCursor() {
        if (this.cur == null) {
            this.cur = Toolkit.getDefaultToolkit().createCustomCursor(this.getImageCursor(), new java.awt.Point(16, 16), "");
        }
        return this.cur;
    }

    public boolean cancelDrawing() {
        return false;
    }

    public Image getImageCursor() {
        return IconThemeHelper.getImage((String)"cursor-select-by-circle");
    }
}

