/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.selectiontools.app.extension.tools.buffer.process;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.gui.beans.incrementabletask.IncrementableProcess;
import org.gvsig.gui.beans.incrementabletask.IncrementableTask;
import org.gvsig.tools.dispose.DisposableIterator;

public class BufferSelectionProcess
extends IncrementableProcess {
    private MapControl mapControl = null;
    private byte pol_side = (byte)-1;
    private byte line_side = (byte)-1;
    private byte point_side = (byte)-1;
    private byte multi_point_side = (byte)-1;
    private short selectedDistanceUnit = (short)-1;
    private FLyrVect[] layers = null;
    private final double f_width;
    private boolean multiLayerSelection = false;
    public static final byte BUFFER_INSIDE_POLY = 0;
    public static final byte BUFFER_OUTSIDE_POLY = 1;
    public static final byte BUFFER_INSIDE_OUTSIDE_POLY = 2;
    public static final byte CAP_SQUARE = 0;
    public static final byte CAP_ROUND = 1;
    public static final byte CONSTANT_DISTANCE_STRATEGY = 0;
    public static final byte ATTRIBUTE_DISTANCE_STRATEGY = 1;

    public BufferSelectionProcess(String title, String label, MapControl mapControl, byte pol_side, byte line_side, byte point_side, byte multi_point_side, double width, short selectedDistanceUnit, FLyrVect[] activeLayers, boolean multiLayerSelection) {
        super(title);
        this.label = label;
        this.mapControl = mapControl;
        this.pol_side = pol_side;
        this.line_side = line_side;
        this.point_side = point_side;
        this.multi_point_side = multi_point_side;
        this.f_width = width;
        this.selectedDistanceUnit = selectedDistanceUnit;
        this.layers = activeLayers;
        this.multiLayerSelection = multiLayerSelection;
        this.isPausable = true;
    }

    public void setIncrementableTask(IncrementableTask iTask) {
        this.iTask = iTask;
        iTask.setAskCancel(true);
        iTask.getButtonsPanel().addAccept();
        iTask.getButtonsPanel().setEnabled(1, false);
        JButton jButton = iTask.getButtonsPanel().getButton(1);
        jButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BufferSelectionProcess.this.processFinalize();
                BufferSelectionProcess.this.mapControl.getMapContext().invalidate();
            }
        });
    }

    public void process() throws InterruptedException {
        this.percentage = 5;
        double inc = 0.0;
        FeatureSelection[] selections = new FeatureSelection[this.layers.length];
        ArrayList[] buffer = new ArrayList[this.layers.length];
        try {
            ArrayList<Geometry> bufferLayer;
            int i;
            this.percentage = 6;
            FLyrVect layer = null;
            this.percentage = 9;
            double width = 1.0;
            this.percentage = 11;
            boolean isProjected = false;
            IWindow f = PluginServices.getMDIManager().getActiveWindow();
            if (f instanceof IView) {
                IView vista = (IView)f;
                IProjection proj = vista.getMapControl().getViewPort().getProjection();
                isProjected = proj.isProjected();
            }
            int mapUnits = -1;
            mapUnits = isProjected ? ((IView)PluginServices.getMDIManager().getActiveWindow()).getMapControl().getViewPort().getMapUnits() : 1;
            this.percentage = 14;
            FeatureStore store = null;
            inc = (100 - this.percentage) / this.layers.length;
            for (i = 0; i < this.layers.length; ++i) {
                try {
                    byte side;
                    FeatureSelection selection;
                    if (cancelProcess.isCanceled()) {
                        throw new InterruptedException();
                    }
                    layer = this.layers[i];
                    store = layer.getFeatureStore();
                    selections[i] = selection = (FeatureSelection)store.getFeatureSelection().clone();
                    this.log.addLine(PluginServices.getText(null, (String)"Starting_selection_of_layer") + " \"" + layer.getName() + "\"");
                    GeometryManager geomManager = GeometryLocator.getGeometryManager();
                    if (geomManager.isSubtype(1, layer.getShapeType())) {
                        side = this.point_side;
                    } else if (geomManager.isSubtype(2, layer.getShapeType())) {
                        side = this.line_side;
                    } else if (geomManager.isSubtype(3, layer.getShapeType())) {
                        side = this.pol_side;
                    } else if (geomManager.isSubtype(7, layer.getShapeType())) {
                        side = this.multi_point_side;
                    } else if (geomManager.isSubtype(8, layer.getShapeType())) {
                        side = this.line_side;
                    } else if (geomManager.isSubtype(9, layer.getShapeType())) {
                        side = this.pol_side;
                    } else {
                        this.log.addLine(PluginServices.getText(null, (String)"Layer_with_unsupported_geometries_type"));
                        this.percentage = (int)((double)this.percentage + inc);
                        continue;
                    }
                    width = this.f_width * MapContext.getDistanceTrans2Meter()[this.selectedDistanceUnit] / MapContext.getDistanceTrans2Meter()[mapUnits];
                    DisposableIterator selIt = selection.fastIterator();
                    bufferLayer = new ArrayList<Geometry>();
                    while (selIt.hasNext()) {
                        Feature feat = (Feature)selIt.next();
                        Geometry geomBuffer = null;
                        switch (side) {
                            case 1: {
                                geomBuffer = this.buffer(feat.getDefaultGeometry(), layer.getProjection(), layer.getCoordTrans(), width);
                                break;
                            }
                            case 0: {
                                geomBuffer = this.buffer(feat.getDefaultGeometry(), layer.getProjection(), layer.getCoordTrans(), -width);
                                break;
                            }
                            case 2: {
                                geomBuffer = this.buffer(feat.getDefaultGeometry(), layer.getProjection(), layer.getCoordTrans(), width);
                            }
                        }
                        bufferLayer.add(geomBuffer);
                    }
                    buffer[i] = bufferLayer;
                    selIt.dispose();
                    continue;
                }
                catch (Exception e3) {
                    if (!cancelProcess.isCanceled()) {
                        NotificationManager.showMessageError((String)PluginServices.getText(null, (String)"Error_fallo_geoproceso"), (Exception)e3);
                        this.log.addLine(PluginServices.getText(null, (String)"Error_fallo_geoproceso"));
                    }
                    throw new InterruptedException();
                }
            }
            for (i = 0; i < this.layers.length; ++i) {
                layer = this.layers[i];
                layer.getFeatureStore().disableNotifications();
                FeatureSelection layerSelection = layer.getFeatureStore().getFeatureSelection();
                if (this.multiLayerSelection) {
                    for (int j = 0; j < buffer.length; ++j) {
                        bufferLayer = buffer[j];
                        if (bufferLayer == null) continue;
                        for (Geometry aux_geometry : bufferLayer) {
                            FeatureSet aux_featSet = layer.queryByGeometry(aux_geometry, layer.getFeatureStore().getDefaultFeatureType());
                            layerSelection.select(aux_featSet);
                        }
                    }
                } else {
                    ArrayList bufferLayer2 = buffer[i];
                    for (Geometry aux_geometry : bufferLayer2) {
                        FeatureSet aux_featSet = layer.queryByGeometry(aux_geometry, layer.getFeatureStore().getDefaultFeatureType());
                        layerSelection.select(aux_featSet);
                    }
                }
                layer.getFeatureStore().enableNotifications();
            }
        }
        catch (Exception de) {
            if (!cancelProcess.isCanceled()) {
                this.log.addLine(PluginServices.getText(null, (String)"Selection_restored"));
                throw new InterruptedException();
            }
            this.percentage = (int)((double)this.percentage + inc);
        }
        this.percentage = 100;
    }

    private Geometry buffer(Geometry geom, IProjection storeProj, ICoordTrans layerCT, double dist) throws Exception {
        if (layerCT == null) {
            if (storeProj.isProjected()) {
                return geom.buffer(dist);
            }
            dist = dist * 180.0 / 2.0037508342789244E7;
            return geom.buffer(dist);
        }
        Geometry aux = geom.cloneGeometry();
        aux.reProject(layerCT);
        return this.buffer(aux, layerCT.getPDest(), null, dist);
    }
}

