/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.bookmarksandhistory.impl;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.bookmarksandhistory.Bookmark;
import org.gvsig.tools.bookmarksandhistory.Bookmarks;
import org.gvsig.tools.bookmarksandhistory.BookmarksAndHistoryManager;
import org.gvsig.tools.identitymanagement.SimpleIdentityManager;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceTypeNotSupportedException;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.gvsig.tools.util.CompareUtils;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseBookmarks<T>
implements Bookmarks<T> {
    private final Logger LOGGER = LoggerFactory.getLogger(BaseBookmarks.class);
    private int order = 0;
    private final List<Bookmark<T>> bookmarks;
    private String groupName;
    private final Supplier<ResourcesStorage> storage;
    private ListItems items;
    private String lastUserName;

    public BaseBookmarks(String groupName, Supplier<ResourcesStorage> storage) {
        this.storage = storage;
        this.groupName = groupName;
        this.bookmarks = new AbstractList<Bookmark<T>>(){

            @Override
            public Bookmark<T> get(int index) {
                List its = BaseBookmarks.this.getItems();
                if (its == null) {
                    throw new IndexOutOfBoundsException();
                }
                return ((Item)its.get(index)).getBookmark();
            }

            @Override
            public int size() {
                List its = BaseBookmarks.this.getItems();
                if (its == null) {
                    return 0;
                }
                return its.size();
            }
        };
    }

    private List<Item> getItems() {
        SimpleIdentityManager userManager = ToolsLocator.getIdentityManager();
        String userName = userManager.getCurrentIdentity().getID();
        if (this.items == null || !StringUtils.equalsAnyIgnoreCase((CharSequence)this.lastUserName, (CharSequence[])new CharSequence[]{userName})) {
            ResourcesStorage theStorage = this.storage.get();
            if (theStorage != null) {
                ListItems theItems = new ListItems();
                List<String> names = theStorage.getResourceNames();
                for (String name : names) {
                    try {
                        String[] userAndBookmark = StringUtils.split((String)name, (String)"@");
                        String currentUserName = userAndBookmark[0];
                        String[] groupAndId = StringUtils.split((String)userAndBookmark[1], (String)"!");
                        if (groupAndId.length != 3) {
                            this.LOGGER.info("skip resource [" + name + "] BAD FORMAT");
                            continue;
                        }
                        String typeName = groupAndId[0];
                        if (!StringUtils.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"BOOKMARKS")) {
                            if (StringUtils.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"HISTORY")) continue;
                            this.LOGGER.info("skip resource [" + name + "] UNKNOWN TYPE");
                            continue;
                        }
                        String bookmarksGroupName = groupAndId[1];
                        String bookmarkName = groupAndId[2];
                        if (StringUtils.equalsIgnoreCase((CharSequence)currentUserName, (CharSequence)userName)) {
                            if (!StringUtils.equalsIgnoreCase((CharSequence)bookmarksGroupName, (CharSequence)this.groupName)) continue;
                            theItems.add(new Item(name, bookmarkName, false, bookmarksGroupName));
                            continue;
                        }
                        if (!StringUtils.equalsIgnoreCase((CharSequence)currentUserName, (CharSequence)"ALL") || !StringUtils.equalsIgnoreCase((CharSequence)bookmarksGroupName, (CharSequence)this.groupName)) continue;
                        theItems.add(new Item(name, bookmarkName, true, bookmarksGroupName));
                    }
                    catch (Exception ex) {
                        this.LOGGER.warn("Can't load bookmark(2) [" + name + "]", (Throwable)ex);
                    }
                }
                this.items = theItems;
                this.lastUserName = userName;
            } else {
                this.items = null;
                return Collections.EMPTY_LIST;
            }
        }
        return this.items;
    }

    @Override
    public boolean remove(String bookmarkName) {
        for (int i = 0; i < this.getItems().size(); ++i) {
            Item item = this.getItems().get(i);
            if (!StringUtils.equalsIgnoreCase((CharSequence)bookmarkName, (CharSequence)item.getName())) continue;
            this.getItems().remove(i);
            item.delete();
            this.refresh_caches();
            return true;
        }
        return false;
    }

    @Override
    public List<Bookmark<T>> toList() {
        return this.bookmarks;
    }

    @Override
    public boolean remove(Bookmark bookmark) {
        return this.remove(bookmark.getName());
    }

    private String generateName(String name, Object value) {
        if (StringUtils.isBlank((CharSequence)name)) {
            name = value instanceof LabeledValue ? StringUtils.left((String)((LabeledValue)value).getLabel(), (int)45) : StringUtils.left((String)Objects.toString(value), (int)45);
            Date now = new Date();
            name = String.format("%tF %tR %s", now, now, name);
        }
        name = StringUtils.replaceChars((String)name, (char)'\n', (char)' ');
        name = StringUtils.replaceChars((String)name, (String)"\r", (String)"");
        name = StringUtils.replaceChars((String)name, (String)".!@\"\\':/*?", (String)StringUtils.repeat((String)"-", (int)".!@\"\\':/*?".length()));
        return name;
    }

    @Override
    public Bookmark add(T value) {
        return this.add(null, value);
    }

    @Override
    public Bookmark add(String name, T value) {
        BaseBookmark bookmark = new BaseBookmark(name = this.generateName(name, value), value, this.groupName);
        Item item = new Item(bookmark);
        if (!item.save()) {
            return null;
        }
        this.refresh_caches();
        return bookmark;
    }

    @Override
    public boolean isEmpty() {
        return this.bookmarks.isEmpty();
    }

    @Override
    public int size() {
        return this.bookmarks.size();
    }

    @Override
    public Iterator<Bookmark<T>> iterator() {
        return this.bookmarks.iterator();
    }

    @Override
    public Bookmark get(int position) {
        return this.bookmarks.get(position);
    }

    @Override
    public List<Bookmark<T>> filter(Predicate<Bookmark<T>> filter) {
        if (filter == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Bookmark<T>> l = new ArrayList<Bookmark<T>>();
        for (Bookmark<T> bookmark : this.bookmarks) {
            if (!filter.test(bookmark)) continue;
            l.add(bookmark);
        }
        return l;
    }

    @Override
    public Bookmark get(String name) {
        for (Item item : this.getItems()) {
            if (!item.getName().equalsIgnoreCase(name)) continue;
            return item.getBookmark();
        }
        return null;
    }

    @Override
    public boolean hasBookmark(String name) {
        for (Item item : this.getItems()) {
            if (!item.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<Bookmark<T>> getOrdered() {
        switch (this.order) {
            default: {
                return this.getOrderedByAlphabeticallyOrder();
            }
            case 1: 
        }
        return this.getOrderedByLastUse();
    }

    private Collection<Bookmark<T>> getOrderedByAlphabeticallyOrder() {
        final ArrayList<Item> sortedItems = new ArrayList<Item>();
        for (Item item : this.getItems()) {
            sortedItems.add(item);
        }
        Collections.sort(sortedItems, (o1, o2) -> CompareUtils.compare(o1.getName(), o2.getName()));
        return new AbstractList<Bookmark<T>>(){

            @Override
            public Bookmark<T> get(int index) {
                return ((Item)sortedItems.get(index)).getBookmark();
            }

            @Override
            public int size() {
                return sortedItems.size();
            }
        };
    }

    private Collection<Bookmark<T>> getOrderedByLastUse() {
        ArrayList<Bookmark<T>> sortedBookmarks = new ArrayList<Bookmark<T>>();
        for (Bookmark<T> bookmark : this.bookmarks) {
            sortedBookmarks.add(bookmark);
        }
        Collections.sort(sortedBookmarks, (o1, o2) -> CompareUtils.compare(Long.valueOf(o2.getLastUse()), Long.valueOf(o1.getLastUse())));
        return sortedBookmarks;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public boolean update(Bookmark bookmark) {
        for (Item item : this.getItems()) {
            if (!item.isBookmark(bookmark)) continue;
            boolean n = item.update(bookmark);
            this.refresh_caches();
            return n;
        }
        return false;
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public void refresh() {
        this.items = null;
    }

    private void refresh_caches() {
        BookmarksAndHistoryManager manager = ToolsLocator.getBookmarksAndHistoryManager();
        manager.refresh();
    }

    private class ListItems
    extends ArrayList<Item> {
        @Override
        public boolean add(Item e) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Item item = (Item)iterator.next();
                if (!StringUtils.equalsIgnoreCase((CharSequence)e.getName(), (CharSequence)item.getName())) continue;
                item.delete();
                iterator.remove();
            }
            return super.add(e);
        }
    }

    public class BaseBookmark
    extends LabeledValueImpl<T>
    implements Bookmark<T> {
        private long lastUse;
        private boolean global;
        private String groupName;

        public BaseBookmark(String name, T value, String groupName) {
            super(name, value);
            this.used();
            this.groupName = groupName;
        }

        @Override
        public boolean isGlobal() {
            return this.global;
        }

        @Override
        public void setGlobal(boolean global) {
            this.global = global;
        }

        @Override
        public String getGroupName() {
            return this.groupName;
        }

        @Override
        public final void used() {
            this.lastUse = new Date().getTime();
        }

        @Override
        public long getLastUse() {
            return this.lastUse;
        }

        @Override
        public void setName(String name) {
            this.label = name;
        }

        @Override
        public String getName() {
            return this.label;
        }

        @Override
        public String toString() {
            return this.label;
        }

        @Override
        public Bookmarks<T> getGroup() {
            return BaseBookmarks.this;
        }
    }

    private class Item {
        private String resourceName;
        private String bookmarkName;
        private String groupName;
        private boolean global;
        private Bookmark<T> bookmark;

        public Item(String resourceName, String bookmarkName, boolean global, String groupName) {
            this.resourceName = resourceName;
            this.bookmarkName = bookmarkName;
            this.groupName = groupName;
            this.global = global;
            this.bookmark = null;
        }

        public Item(Bookmark<T> bookmark) {
            this.bookmark = bookmark;
            this.global = this.bookmark.isGlobal();
            this.bookmarkName = this.bookmark.getName();
            this.groupName = this.bookmark.getGroupName();
            this.resourceName = null;
        }

        public String getName() {
            return this.bookmarkName;
        }

        public Bookmark<T> getBookmark() {
            if (this.bookmark == null) {
                this.load();
            }
            return this.bookmark;
        }

        private String getResourceName() {
            if (StringUtils.isBlank((CharSequence)this.resourceName)) {
                if (this.global) {
                    this.resourceName = "ALL@BOOKMARKS!" + this.groupName + "!" + this.bookmark.getName();
                } else {
                    SimpleIdentityManager userManager = ToolsLocator.getIdentityManager();
                    String userName = userManager.getCurrentIdentity().getID();
                    this.resourceName = userName + "@BOOKMARKS!" + this.groupName + "!" + this.bookmark.getName();
                }
            }
            return this.resourceName;
        }

        public boolean isBookmark(Bookmark bookmark) {
            return this.bookmark == bookmark;
        }

        public Bookmark<T> load() {
            ResourcesStorage theStorage = (ResourcesStorage)BaseBookmarks.this.storage.get();
            if (theStorage == null) {
                return null;
            }
            String resname = this.getResourceName();
            try (ResourcesStorage.Resource resource = theStorage.getResource(resname);){
                PersistenceManager persistenceManager = ToolsLocator.getPersistenceManager();
                Object data = persistenceManager.getObject(resource.asInputStream());
                BaseBookmark theBookmark = new BaseBookmark(this.bookmarkName, data, this.groupName);
                theBookmark.setGlobal(this.global);
                BaseBookmarks.this.LOGGER.info("load [" + resname + "]");
                this.bookmark = theBookmark;
            }
            catch (Exception ex) {
                BaseBookmarks.this.LOGGER.warn("Can't load bookmark [" + resname + "]", (Throwable)ex);
            }
            return this.bookmark;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean save() {
            ResourcesStorage theStorage = (ResourcesStorage)BaseBookmarks.this.storage.get();
            if (theStorage == null) {
                return false;
            }
            String resname = this.getResourceName();
            try (ResourcesStorage.Resource resource = theStorage.getResource(resname);){
                PersistenceManager persistenceManager = ToolsLocator.getPersistenceManager();
                Object data = this.bookmark.getValue();
                PersistentState state = persistenceManager.getState(data);
                persistenceManager.saveState(state, resource.asOutputStream());
                BaseBookmarks.this.LOGGER.info("save [" + resname + "]");
                boolean bl = true;
                return bl;
            }
            catch (PersistenceTypeNotSupportedException ex) {
                BaseBookmarks.this.LOGGER.info("Can't save bookmark, persistence not supported (" + resname + ")");
                return false;
            }
            catch (Exception ex) {
                BaseBookmarks.this.LOGGER.warn("Can't persist bookmark " + resname, (Throwable)ex);
                return false;
            }
        }

        public boolean delete() {
            ResourcesStorage theStorage = (ResourcesStorage)BaseBookmarks.this.storage.get();
            if (theStorage == null) {
                return false;
            }
            String resname = this.getResourceName();
            if (!theStorage.exists(resname)) {
                return true;
            }
            boolean res = theStorage.remove(resname);
            BaseBookmarks.this.LOGGER.info("delete [" + resname + "]");
            return res;
        }

        public boolean update(Bookmark bookmark) {
            this.delete();
            this.groupName = bookmark.getGroupName();
            this.bookmarkName = bookmark.getName();
            this.global = bookmark.isGlobal();
            this.resourceName = null;
            this.bookmark = bookmark;
            return this.save();
        }
    }
}

