/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dataTypes.impl.coercion;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.dataTypes.AbstractCoercion;
import org.gvsig.tools.dataTypes.CoercionContext;
import org.gvsig.tools.dataTypes.CoercionContextDecimal;
import org.gvsig.tools.dataTypes.CoercionContextDecimalImpl;
import org.gvsig.tools.dataTypes.CoercionContextLocale;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.tools.math.BigDecimalUtils;

public class CoerceToDecimal
extends AbstractCoercion {
    @Override
    public Object coerce(Object value) throws CoercionException {
        if (value == null || value instanceof BigDecimal) {
            return value;
        }
        return this.coerce(value, DataTypeUtils.coerceContextDefaultDecimal());
    }

    @Override
    public Object coerce(Object value, CoercionContext context) throws CoercionException {
        if (value == null) {
            return value;
        }
        CoercionContextDecimal theContext = context instanceof CoercionContextDecimal ? (CoercionContextDecimal)context : (context instanceof CoercionContextLocale ? DataTypeUtils.coerceContextDecimal(((CoercionContextLocale)context).locale()) : DataTypeUtils.coerceContextDefaultDecimal());
        try {
            BigDecimal num;
            if (value instanceof BigDecimal) {
                num = (BigDecimal)value;
            } else if (value instanceof Number) {
                num = new BigDecimal(String.format(Locale.ENGLISH, "%f", ((Number)value).doubleValue()), theContext.getMathContext());
            } else if (value instanceof Boolean) {
                num = new BigDecimal((Boolean)value != false ? 1 : 0, theContext.getMathContext());
            } else if (value instanceof Date) {
                num = new BigDecimal(((Date)value).getTime(), theContext.getMathContext());
            } else {
                String s = value.toString().trim().toLowerCase();
                if (StringUtils.isBlank((CharSequence)s)) {
                    return null;
                }
                if (s.startsWith("0x")) {
                    num = new BigDecimal(Long.parseLong(s.substring(2), 16), theContext.getMathContext());
                } else {
                    Boolean bool = BooleanUtils.toBooleanObject((String)s);
                    if (bool != null) {
                        num = bool != false ? BigDecimal.ONE : BigDecimal.ZERO;
                    } else {
                        if (s.startsWith("+")) {
                            s = s.substring(1);
                        }
                        ParsePosition p = new ParsePosition(0);
                        DecimalFormat nf = (DecimalFormat)NumberFormat.getInstance(theContext.locale());
                        nf.setParseBigDecimal(true);
                        num = (BigDecimal)nf.parse(s, p);
                        if (p.getErrorIndex() > 0 || p.getIndex() < s.length()) {
                            throw new CoercionException("Can't coerce '" + s + "' to BigDecimal " + theContext.toString() + "(error index " + p.getErrorIndex() + ", index " + p.getIndex() + ").");
                        }
                    }
                }
            }
            if (theContext.hasPrecision()) {
                num = BigDecimalUtils.forceScaleAndEnsurePrecision(num, theContext.scale(), theContext.precision());
            }
            return num;
        }
        catch (CoercionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoercionException("Can't coerce '" + value.toString() + "' to BigDecimal " + theContext.toString() + ".", e);
        }
    }

    private static BigDecimal toBigDecimal(Object value, int precision, int scale) throws CoercionException {
        CoercionContextDecimalImpl context = new CoercionContextDecimalImpl(Locale.ENGLISH, precision, scale);
        CoerceToDecimal c = new CoerceToDecimal();
        BigDecimal x = (BigDecimal)c.coerce(value, context);
        return x;
    }

    public static void main(String[] args) throws CoercionException {
        BigDecimal n = CoerceToDecimal.toBigDecimal(418.95168, 18, 5);
        System.out.println("toBigDecimal(418.95168d, 18, 5): " + BigDecimalUtils.repr(n));
    }
}

