/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynobject.impl;

import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynObjectPagingHelper;
import org.gvsig.tools.dynobject.DynObjectSet;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.paging.DefaultPagingCalculator;
import org.gvsig.tools.paging.PagingCalculator;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.gvsig.tools.visitor.Visitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDynObjectPagingHelper
extends AbstractDisposable
implements DynObjectPagingHelper {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDynObjectPagingHelper.class);
    private DynObjectSet set;
    private DynObject[] values;
    private PagingCalculator calculator;

    public DefaultDynObjectPagingHelper() {
    }

    public DefaultDynObjectPagingHelper(DynObjectSet set) throws BaseException {
        this(set, 100);
    }

    public DefaultDynObjectPagingHelper(DynObjectSet set, int pageSize) throws BaseException {
        this.setDynObjectSet(set, pageSize);
    }

    protected void setDynObjectSet(final DynObjectSet set, int pageSize) throws BaseException {
        this.set = set;
        this.setDefaultCalculator(new PagingCalculator.Sizeable(){

            @Override
            public long getSize() {
                try {
                    return set.getSize();
                }
                catch (BaseException e) {
                    LOG.error("Error getting the size of the DynObjectSet: " + set, (Throwable)e);
                    return 0L;
                }
            }
        }, pageSize);
    }

    @Override
    public DynObject getDynObjectAt(long index) throws BaseException {
        long pageForIndex = (long)Math.floor(index / (long)this.getMaxPageSize());
        if (pageForIndex != this.getCurrentPage()) {
            this.setCurrentPage(pageForIndex);
        }
        long positionForIndex = index - this.getCurrentPage() * (long)this.getMaxPageSize();
        return this.values[(int)positionForIndex];
    }

    @Override
    public DynObject[] getCurrentPageDynObjects() {
        return this.values;
    }

    @Override
    public DynObjectSet getDynObjectSet() {
        return this.set;
    }

    @Override
    public void reloadCurrentPage() throws BaseException {
        if (this.getCurrentPage() > -1L) {
            this.loadCurrentPageData();
        }
    }

    protected void loadCurrentPageData() throws BaseException {
        int currentPageSize = this.getCurrentPageSize();
        final DynObject[] values = new DynObject[currentPageSize];
        long t1 = 0L;
        if (LOG.isTraceEnabled()) {
            t1 = System.currentTimeMillis();
        }
        long initialIndex = this.getInitialIndex();
        final int pageSize = this.getCurrentPageSize();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading {} DynObjects starting at position {}", (Object)pageSize, (Object)initialIndex);
        }
        this.set.accept(new Visitor(){
            private int i = 0;

            @Override
            public void visit(Object obj) throws VisitCanceledException, BaseException {
                if (this.i >= pageSize) {
                    throw new VisitCanceledException();
                }
                values[this.i] = (DynObject)obj;
                ++this.i;
            }
        }, initialIndex);
        if (LOG.isTraceEnabled()) {
            long t2 = System.currentTimeMillis();
            LOG.trace("Time to load {} DynObjects: {} ms", (Object)currentPageSize, (Object)(t2 - t1));
        }
        this.values = values;
    }

    @Override
    public void reload() throws BaseException {
        this.reloadCurrentPage();
    }

    @Override
    protected void doDispose() throws BaseException {
        this.set.dispose();
    }

    protected PagingCalculator getCalculator() {
        return this.calculator;
    }

    protected void setCalculator(PagingCalculator calculator) throws BaseException {
        this.calculator = calculator;
        this.loadCurrentPageData();
    }

    protected void setDefaultCalculator(PagingCalculator.Sizeable sizeable, int pageSize) throws BaseException {
        this.setCalculator(new DefaultPagingCalculator(sizeable, pageSize));
    }

    @Override
    public int getMaxPageSize() {
        return this.calculator == null ? 100 : this.calculator.getMaxPageSize();
    }

    @Override
    public void setMaxPageSize(int pageSize) throws BaseException {
        this.calculator.setMaxPageSize(pageSize);
        this.reloadCurrentPage();
    }

    @Override
    public long getCurrentPage() {
        return this.calculator.getCurrentPage();
    }

    @Override
    public void setCurrentPage(long page) throws BaseException {
        this.calculator.setCurrentPage(page);
        this.loadCurrentPageData();
    }

    @Override
    public long getInitialIndex() {
        return this.calculator.getInitialIndex();
    }

    @Override
    public long getNumPages() {
        return this.calculator.getNumPages();
    }

    @Override
    public long getTotalSize() {
        return this.calculator.getTotalSize();
    }

    @Override
    public int getCurrentPageSize() {
        return this.calculator.getCurrentPageSize();
    }
}

