/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynobject.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynClassName;
import org.gvsig.tools.dynobject.DynClass_v2;
import org.gvsig.tools.dynobject.DynField_v2;
import org.gvsig.tools.dynobject.DynMethod;
import org.gvsig.tools.dynobject.DynObjectManager;
import org.gvsig.tools.dynobject.DynObjectRuntimeException;
import org.gvsig.tools.dynobject.DynObjectValueItem;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.dynobject.exception.DynFieldIsNotAContainerException;
import org.gvsig.tools.dynobject.exception.DynMethodException;
import org.gvsig.tools.dynobject.impl.DefaultDynClass;
import org.gvsig.tools.dynobject.impl.DefaultTags;
import org.gvsig.tools.dynobject.impl.DynClassImportExportTags;
import org.gvsig.tools.exception.BaseRuntimeException;
import org.gvsig.tools.exception.ListBaseException;
import org.gvsig.tools.script.Script;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class DynClassImportHelper
implements DynClassImportExportTags {
    private static final Logger LOG = LoggerFactory.getLogger(DynClassImportHelper.class);
    private DynObjectManager manager = ToolsLocator.getDynObjectManager();
    private Map dynClasses = null;
    private Tags globalTags = null;
    private List<Runnable> postLoadActions = new ArrayList<Runnable>();

    private String getNullWhenEmptyString(String value) {
        if (value != null && value.trim().length() == 0) {
            return null;
        }
        return value;
    }

    private String nextText(XmlPullParser parser) throws XmlPullParserException, IOException {
        return this.getNullWhenEmptyString(parser.nextText());
    }

    private String getAttributeValue(XmlPullParser parser, int i) throws XmlPullParserException, IOException {
        return this.getNullWhenEmptyString(parser.getAttributeValue(i));
    }

    public Map importDefinitions(InputStream resource, ClassLoader loader, String defaultNamespace) throws XmlPullParserException, IOException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)ToolsLocator.getInstance().getXmlPullParserFactoryClassNames(), null);
        XmlPullParser parser = factory.newPullParser();
        parser.setInput(resource, null);
        return this.importDefinitions(parser, loader, defaultNamespace);
    }

    public Map importDefinitions(XmlPullParser parser, ClassLoader loader, String defaultNamespace) throws XmlPullParserException, IOException {
        this.dynClasses = new Definitions();
        this.globalTags = new DefaultTags();
        String version = null;
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        parser.nextTag();
        parser.require(2, null, "definitions");
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            String name = parser.getAttributeName(i);
            if (!name.equalsIgnoreCase("version")) {
                throw new WrongVersionException(parser);
            }
            version = this.getAttributeValue(parser, i);
        }
        parser.nextTag();
        if (parser.getName().equalsIgnoreCase("version")) {
            parser.require(2, null, "version");
            version = parser.nextText();
            if (!version.trim().equals("1.0.0")) {
                throw new UnsupportedClassVersionError();
            }
            parser.require(3, "", "version");
            parser.nextTag();
        }
        if (parser.getName().equalsIgnoreCase("tags")) {
            parser.nextTag();
            while (parser.getEventType() != 3 || !parser.getName().equals("tags")) {
                this.checkEndDocument(parser);
                PairValueLabel pair = this.importValueItem(parser, "name");
                this.globalTags.set(pair.label, pair.value);
                parser.nextTag();
            }
        }
        parser.require(2, "", "classes");
        parser.nextTag();
        while (parser.getEventType() != 3 || !parser.getName().equals("classes")) {
            this.checkEndDocument(parser);
            DynClass dynClass = this.importDynClass(parser, loader, defaultNamespace, this.dynClasses);
            try {
                ((DefaultDynClass)dynClass).check();
            }
            catch (ListBaseException e) {
                throw new DynObjectRuntimeException((Throwable)e);
            }
            if (this.dynClasses.get(dynClass.getFullName()) != null) {
                throw new DuplicateDynClassException(parser, dynClass.getFullName());
            }
            this.dynClasses.put(dynClass.getFullName(), dynClass);
        }
        parser.require(3, "", "classes");
        parser.nextTag();
        parser.require(3, "", "definitions");
        parser.next();
        parser.require(1, null, null);
        for (Runnable postaction : this.postLoadActions) {
            postaction.run();
        }
        LOG.debug("Imported classes {}", new Object[]{this.getKeys(this.dynClasses)});
        return this.dynClasses;
    }

    private String getKeys(Map theMap) {
        ArrayList l = new ArrayList(theMap.keySet());
        return ((Object)l).toString();
    }

    private DynClass importDynClass(XmlPullParser parser, ClassLoader loader, String defaultNamespace, Map classes) throws XmlPullParserException, IOException {
        int i;
        DynObjectManager manager = ToolsLocator.getDynObjectManager();
        ArrayList<DynClassName> superClasses = new ArrayList<DynClassName>();
        HashMap<String, String> values = new HashMap<String, String>();
        ArrayList<PairValueLabel> tagsValues = null;
        parser.require(2, null, "class");
        for (i = 0; i < parser.getAttributeCount(); ++i) {
            values.put(parser.getAttributeName(i), this.getAttributeValue(parser, i));
        }
        parser.nextTag();
        while (parser.getEventType() != 3 || !parser.getName().equals("classes")) {
            this.checkEndDocument(parser);
            parser.require(2, null, null);
            String tagName = parser.getName();
            if (tagName.equalsIgnoreCase("description")) {
                values.put("description", this.nextText(parser));
            } else if (tagName.equalsIgnoreCase("name")) {
                values.put("name", this.nextText(parser));
            } else if (tagName.equalsIgnoreCase("label")) {
                values.put("label", this.nextText(parser));
            } else if (tagName.equalsIgnoreCase("namespace")) {
                values.put("namespace", this.nextText(parser));
            } else if (tagName.equalsIgnoreCase("superClassNames")) {
                parser.nextTag();
                while (parser.getEventType() != 3 || !parser.getName().equals("superClassNames")) {
                    this.checkEndDocument(parser);
                    parser.require(2, "", "superClassName");
                    superClasses.add(manager.createDynClassName(defaultNamespace, this.nextText(parser)));
                    parser.require(3, null, "superClassName");
                    parser.nextTag();
                }
            } else if (tagName.equalsIgnoreCase("extends")) {
                parser.nextTag();
                while (parser.getEventType() != 3 || !parser.getName().equals("extends")) {
                    this.checkEndDocument(parser);
                    superClasses.add(this.importSuperClass(parser, defaultNamespace));
                    parser.nextTag();
                }
            } else if (tagName.equalsIgnoreCase("tags")) {
                parser.nextTag();
                tagsValues = new ArrayList<PairValueLabel>();
                while (parser.getEventType() != 3 || !parser.getName().equals("tags")) {
                    this.checkEndDocument(parser);
                    tagsValues.add(this.importValueItem(parser, "name"));
                    parser.nextTag();
                }
            } else {
                if (!tagName.equalsIgnoreCase("code")) break;
                String langcode = parser.getAttributeValue(null, "langcode");
                if (StringUtils.isEmpty((CharSequence)langcode)) {
                    langcode = "python";
                }
                values.put("code", this.nextText(parser));
                values.put("langcode", langcode);
            }
            parser.require(3, null, tagName);
            parser.nextTag();
        }
        parser.require(2, null, "fields");
        parser.nextTag();
        if (values.get("name") == null) {
            throw new NeedTagOrAttributeException(parser, "name");
        }
        if (values.get("namespace") == null) {
            values.put("namespace", defaultNamespace);
        }
        DynClass_v2 dynClass = (DynClass_v2)manager.createDynClass((String)values.get("namespace"), (String)values.get("name"), (String)values.get("description"));
        dynClass.getTags().add(this.globalTags);
        if (values.get("code") != null) {
            Script script = ToolsLocator.getScriptManager().createScript(dynClass.getName(), (String)values.get("code"), (String)values.get("langcode"));
            dynClass.setScript(script);
        }
        if (values.get("label") != null) {
            dynClass.setLabel((String)values.get("label"));
        }
        for (i = 0; i < superClasses.size(); ++i) {
            DynClassName superClass = (DynClassName)superClasses.get(i);
            if (superClass.getName() == null) {
                throw new NeedTagOrAttributeException(parser, "name");
            }
            DynClass superDynClass = (DynClass)classes.get(superClass.getFullName());
            if (superDynClass == null && (superDynClass = ToolsLocator.getDynObjectManager().get(superClass.getNamespace(), superClass.getName())) == null) {
                throw new CantLocateDynClassException(parser, superClass.getFullName());
            }
            dynClass.extend(superDynClass);
        }
        if (tagsValues != null && !tagsValues.isEmpty() && dynClass instanceof DynClass_v2) {
            for (i = 0; i < tagsValues.size(); ++i) {
                PairValueLabel pair = (PairValueLabel)tagsValues.get(i);
                if (pair.label == null) continue;
                dynClass.getTags().set(pair.label, pair.value);
            }
        }
        while (parser.getEventType() != 3 || !parser.getName().equals("fields")) {
            this.checkEndDocument(parser);
            this.importDynField(parser, dynClass, loader);
            parser.nextTag();
        }
        parser.require(3, null, "fields");
        parser.nextTag();
        parser.require(3, null, "class");
        parser.nextTag();
        return dynClass;
    }

    private DynClassName importSuperClass(XmlPullParser parser, String defaultNamespace) throws XmlPullParserException, IOException {
        String name = null;
        String namespace = defaultNamespace;
        parser.require(2, null, "class");
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            String attrname = parser.getAttributeName(i);
            if (attrname.equalsIgnoreCase("name")) {
                name = this.getAttributeValue(parser, i);
                continue;
            }
            if (attrname.equalsIgnoreCase("namespace")) {
                namespace = this.getAttributeValue(parser, i);
                continue;
            }
            throw new UnexpectedTagOrAttributeException(parser, attrname);
        }
        if (name == null) {
            name = this.nextText(parser);
        } else {
            parser.nextTag();
        }
        parser.require(3, null, "class");
        DynClassName dynClassName = this.manager.createDynClassName(namespace, name);
        return dynClassName;
    }

    private void importDynField(XmlPullParser parser, DynClass_v2 dynClass, ClassLoader loader) throws XmlPullParserException, IOException {
        ArrayList<DynObjectValueItem> availableValues = null;
        ArrayList<PairValueLabel> tagsValues = null;
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        parser.require(2, null, "field");
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            values.put(parser.getAttributeName(i), this.getAttributeValue(parser, i));
        }
        parser.nextTag();
        while (parser.getEventType() != 3 || !parser.getName().equals("field")) {
            this.checkEndDocument(parser);
            parser.require(2, null, null);
            String name = parser.getName();
            if (name.equalsIgnoreCase("name")) {
                values.put("name", this.nextText(parser));
            } else if (name.equalsIgnoreCase("description")) {
                values.put("description", this.nextText(parser));
            } else if (name.equalsIgnoreCase("type")) {
                values.put("type", this.nextText(parser));
            } else if (name.equalsIgnoreCase("subtype")) {
                values.put("subtype", this.nextText(parser));
            } else if (name.equalsIgnoreCase("group")) {
                values.put("group", this.nextText(parser));
            } else if (name.equalsIgnoreCase("label")) {
                values.put("label", this.nextText(parser));
            } else if (name.equalsIgnoreCase("order")) {
                values.put("order", this.nextText(parser));
            } else if (name.equalsIgnoreCase("mandatory")) {
                values.put("mandatory", this.nextText(parser));
            } else if (name.equalsIgnoreCase("persistent")) {
                values.put("persistent", this.nextText(parser));
            } else if (name.equalsIgnoreCase("minValue")) {
                values.put("minValue", this.nextText(parser));
            } else if (name.equalsIgnoreCase("maxValue")) {
                values.put("maxValue", this.nextText(parser));
            } else if (name.equalsIgnoreCase("classOfValue")) {
                values.put("classOfValue", this.nextText(parser));
            } else if (name.equalsIgnoreCase("classOfItems")) {
                values.put("classOfItems", this.nextText(parser));
            } else if (name.equalsIgnoreCase("defaultValue")) {
                values.put("defaultValue", this.nextText(parser));
            } else if (name.equalsIgnoreCase("hidden")) {
                values.put("hidden", this.nextText(parser));
            } else if (name.equalsIgnoreCase("readonly")) {
                values.put("readonly", this.nextText(parser));
            } else if (name.equalsIgnoreCase("calculate")) {
                values.put("calculate", this.nextText(parser));
            } else if (name.equalsIgnoreCase("availableValues")) {
                parser.nextTag();
                availableValues = new ArrayList<DynObjectValueItem>();
                while (parser.getEventType() != 3 || !parser.getName().equals("availableValues")) {
                    this.checkEndDocument(parser);
                    availableValues.add((DynObjectValueItem)((Object)this.importValueItem(parser, "label")));
                    parser.nextTag();
                }
            } else {
                if (!name.equalsIgnoreCase("tags")) break;
                parser.nextTag();
                tagsValues = new ArrayList<PairValueLabel>();
                while (parser.getEventType() != 3 || !parser.getName().equals("tags")) {
                    this.checkEndDocument(parser);
                    tagsValues.add(this.importValueItem(parser, "name"));
                    parser.nextTag();
                }
            }
            parser.require(3, null, name);
            parser.nextTag();
        }
        parser.require(3, null, "field");
        if (values.get("name") == null) {
            throw new NeedTagOrAttributeException(parser, "name");
        }
        String name2 = "type";
        String value = (String)values.get(name2);
        if (value == null) {
            throw new InvalidFieldTypeException(parser, value);
        }
        int type = ToolsLocator.getDataTypesManager().getType(value);
        if (type == 0) {
            throw new InvalidFieldTypeException(parser, value);
        }
        DynField_v2 field = (DynField_v2)dynClass.addDynField((String)values.get("name"), type);
        field.getTags().add(dynClass.getTags());
        for (String name2 : values.keySet()) {
            value = (String)values.get(name2);
            if (value == null || name2.equalsIgnoreCase("name")) continue;
            if (name2.equalsIgnoreCase("description")) {
                field.setDescription(value);
                continue;
            }
            if (name2.equalsIgnoreCase("calculate")) {
                this.postLoadActions.add(new SetCalculateMethodAction(field, value));
                continue;
            }
            if (name2.equalsIgnoreCase("type")) continue;
            if (name2.equalsIgnoreCase("subtype")) {
                field.setSubtype(value);
                continue;
            }
            if (name2.equalsIgnoreCase("group")) {
                field.setGroup(value);
                continue;
            }
            if (name2.equalsIgnoreCase("label")) {
                this.manager.setAttributeValue(field, "label", value);
                continue;
            }
            if (name2.equalsIgnoreCase("order")) {
                field.setOrder(Integer.parseInt(value));
                continue;
            }
            if (name2.equalsIgnoreCase("mandatory")) {
                field.setMandatory(Boolean.parseBoolean(value));
                continue;
            }
            if (name2.equalsIgnoreCase("persistent")) {
                field.setPersistent(Boolean.parseBoolean(value));
                continue;
            }
            if (name2.equalsIgnoreCase("hidden")) {
                field.setHidden(Boolean.parseBoolean(value));
                continue;
            }
            if (name2.equalsIgnoreCase("readonly")) {
                field.setReadOnly(Boolean.parseBoolean(value));
                continue;
            }
            if (name2.equalsIgnoreCase("minValue")) {
                field.setMinValue(value);
                continue;
            }
            if (name2.equalsIgnoreCase("maxValue")) {
                field.setMaxValue(value);
                continue;
            }
            if (name2.equalsIgnoreCase("defaultValue")) {
                field.setDefaultFieldValue(value);
                continue;
            }
            if (name2.equalsIgnoreCase("typeOfItems")) {
                int typeOfItems = ToolsLocator.getDataTypesManager().getType(value);
                if (typeOfItems == 0) {
                    throw new InvalidFieldTypeException(parser, value);
                }
                field.setTypeOfItems(typeOfItems);
                continue;
            }
            if (name2.equalsIgnoreCase("dynclassOfItems")) {
                this.postLoadActions.add(new SetDynClassOfItemsAction(field, value));
                continue;
            }
            if (name2.equalsIgnoreCase("classOfItems")) {
                if (field.getTypeOfItems() == 15) {
                    this.postLoadActions.add(new SetDynClassOfItemsAction(field, value));
                    continue;
                }
                try {
                    Class<?> klass = Class.forName(value, true, loader);
                    field.setClassOfItems(klass);
                    continue;
                }
                catch (DynFieldIsNotAContainerException e) {
                    LOG.warn("No se ha encontrado la clase '" + value + "'.", (Throwable)e);
                    throw new IncompatibleAttributeValueException(parser, "name");
                }
                catch (ClassNotFoundException e) {
                    LOG.warn("No se ha encontrado la clase '" + value + "'.", (Throwable)e);
                    throw new CantLocateClassException(parser, "classOfItems", value);
                }
            }
            if (name2.equalsIgnoreCase("classOfValue")) {
                if (field.getType() == 15) {
                    this.postLoadActions.add(new SetDynClassOfValueAction(field, value));
                    continue;
                }
                try {
                    Class<?> klass = Class.forName(value, true, loader);
                    field.setClassOfValue(klass);
                    continue;
                }
                catch (DynFieldIsNotAContainerException e) {
                    LOG.warn("No se ha encontrado la clase '" + value + "'.", (Throwable)e);
                    throw new IncompatibleAttributeValueException(parser, "name");
                }
                catch (ClassNotFoundException e) {
                    LOG.warn("No se ha encontrado la clase '" + value + "'.", (Throwable)e);
                    throw new CantLocateClassException(parser, "classOfValue", value);
                }
            }
            if (name2.equalsIgnoreCase("availableValues")) continue;
            throw new UnexpectedTagOrAttributeException(parser, name2);
        }
        try {
            PairValueLabel pair;
            int i;
            if (availableValues != null && !availableValues.isEmpty()) {
                for (i = 0; i < availableValues.size(); ++i) {
                    pair = (PairValueLabel)availableValues.get(i);
                    if (pair.label == null) {
                        pair.label = pair.value == null ? "null" : pair.value.toString();
                    }
                    availableValues.set(i, new DynObjectValueItem(field.coerce(pair.value), pair.label));
                }
                field.setAvailableValues(availableValues);
            }
            if (tagsValues != null && !tagsValues.isEmpty()) {
                for (i = 0; i < tagsValues.size(); ++i) {
                    pair = (PairValueLabel)tagsValues.get(i);
                    if (pair.label == null) continue;
                    field.getTags().set(pair.label, pair.value);
                }
            }
            field.setMaxValue(field.coerce(values.get("maxValue")));
            field.setMinValue(field.coerce(values.get("minValue")));
            field.setDefaultFieldValue(field.coerce(values.get("defaultValue")));
        }
        catch (CoercionException e) {
            throw new ParseCoerceException(e, parser);
        }
    }

    private PairValueLabel importValueItem(XmlPullParser parser, String attributeName) throws XmlPullParserException, IOException {
        PairValueLabel pair = new PairValueLabel();
        if (parser.getName().equalsIgnoreCase("valueItem")) {
            parser.require(2, null, "valueItem");
            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                String name = parser.getAttributeName(i);
                if (name.equalsIgnoreCase(attributeName)) {
                    pair.label = this.getAttributeValue(parser, i);
                    continue;
                }
                if (name.equalsIgnoreCase("value")) {
                    pair.value = this.getAttributeValue(parser, i);
                    continue;
                }
                throw new UnexpectedTagOrAttributeException(parser, name);
            }
            parser.nextTag();
            while (parser.getEventType() != 3 || !parser.getName().equals("valueItem")) {
                this.checkEndDocument(parser);
                parser.require(2, null, null);
                String name = parser.getName();
                if (name.equalsIgnoreCase(attributeName)) {
                    pair.label = this.nextText(parser);
                } else {
                    if (!name.equalsIgnoreCase("value")) break;
                    pair.value = this.nextText(parser);
                }
                parser.require(3, null, name);
                parser.nextTag();
            }
            parser.require(3, null, "valueItem");
        } else {
            parser.require(2, null, "value");
            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                String name = parser.getAttributeName(i);
                if (name.equalsIgnoreCase(attributeName)) {
                    pair.label = parser.getAttributeValue(i);
                    continue;
                }
                if (name.equalsIgnoreCase("value")) {
                    pair.value = this.getAttributeValue(parser, i);
                    continue;
                }
                throw new UnexpectedTagOrAttributeException(parser, name);
            }
            pair.value = pair.value == null ? parser.nextText() : pair.value + parser.nextText();
            parser.require(3, null, "value");
        }
        return pair;
    }

    private void checkEndDocument(XmlPullParser parser) throws XmlPullParserException {
        if (parser.getEventType() == 1) {
            throw new UnexpectedTagOrAttributeException(parser, "(end-of-document)");
        }
    }

    public static class WrongVersionException
    extends ImportDynClassesException {
        private static final long serialVersionUID = 6620589308398698367L;

        public WrongVersionException(XmlPullParser parser) {
            super(parser, "Wrong format version.", "_Wrong_format_version", 6620589308398698367L);
        }
    }

    public static class ParseCoerceException
    extends ImportDynClassesException {
        private static final long serialVersionUID = 1447718822981628834L;

        public ParseCoerceException(Throwable cause, XmlPullParser parser) {
            super(parser, "Can't convert value.", "_Cant_convert_value", 1447718822981628834L);
            this.initCause(cause);
        }
    }

    public static class IncompatibleAttributeValueException
    extends ImportDynClassesException {
        private static final long serialVersionUID = 2646530094487375049L;

        public IncompatibleAttributeValueException(XmlPullParser parser, String name) {
            super(parser, "Incompatible attribute value for field '%(name)'.", "_Incompatible_attribute_value_for_field_XnameX", 2646530094487375049L);
            this.setValue("name", name);
        }

        public IncompatibleAttributeValueException(XmlPullParser parser, String name, String value) {
            super(parser, "Incompatible attribute value '%(value)', for field '%(name)'.", "_Incompatible_attribute_value_for_field_XnameX", 2646530094487375049L);
            this.setValue("name", name);
            this.setValue("value", value);
        }
    }

    public static class CantLocateDynClassException
    extends ImportDynClassesException {
        private static final long serialVersionUID = 6286170415562358806L;

        public CantLocateDynClassException(XmlPullParser parser, String tagname) {
            super(parser, "Can't locate DynClass '%(name). Look at the extends tag.", "_Cant_locate_DynClass_XnameX", 6286170415562358806L);
            this.setValue("name", tagname);
        }
    }

    public static class CantLocateClassException
    extends ImportDynClassesException {
        private static final long serialVersionUID = 5733585544096433612L;

        public CantLocateClassException(XmlPullParser parser, String tagname) {
            super(parser, "Can't locate class named in attribute '%(name)'.", "_Cant_locate_class_XnameX", 5733585544096433612L);
            this.setValue("name", tagname);
        }

        public CantLocateClassException(XmlPullParser parser, String tagname, String className) {
            super(parser, "Can't locate class named in attribute '%(name)' whose name is '%(className)'.", "_Cant_locate_class_XnameX", 5733585544096433612L);
            this.setValue("name", tagname);
            this.setValue("className", className);
        }
    }

    public static class NeedTagOrAttributeException
    extends ImportDynClassesException {
        private static final long serialVersionUID = -808282903423455613L;

        public NeedTagOrAttributeException(XmlPullParser parser, String tag) {
            super(parser, "Need tag or attribute '%(tag)'.", "_Need_tag_or_attribute_XtagX", -808282903423455613L);
            this.setValue("tag", tag);
        }
    }

    public static class UnexpectedTagOrAttributeException
    extends ImportDynClassesException {
        private static final long serialVersionUID = -808282903423455613L;

        public UnexpectedTagOrAttributeException(XmlPullParser parser, String tag) {
            super(parser, "Unexpected tag or attribute '%(tag)'.", "_Unexpected_tag_or_attribute_XtagX", -808282903423455613L);
            this.setValue("tag", tag);
        }
    }

    public static class InvalidFieldTypeException
    extends ImportDynClassesException {
        private static final long serialVersionUID = 8501343258053356775L;

        public InvalidFieldTypeException(XmlPullParser parser, String value) {
            super(parser, "Invalid field type '%(value)'.", "_Invalid_field_type_XvalueX", 8501343258053356775L);
            this.setValue("value", value);
        }
    }

    public static class DuplicateDynClassException
    extends ImportDynClassesException {
        private static final long serialVersionUID = 3653024321140806121L;

        public DuplicateDynClassException(XmlPullParser parser, String name) {
            super(parser, "Duplicate DynClass definition for '%(name)'.", "_Duplicate_DynClass_definition_for_XnameX", 3653024321140806121L);
            this.setValue("name", name);
        }
    }

    public static abstract class ImportDynClassesException
    extends BaseRuntimeException {
        private static final long serialVersionUID = 3346283395112730192L;

        public ImportDynClassesException(XmlPullParser parser) {
            super("Error importing classes from file at line %(line) column %(column).", "_Error_importing_classes_from_file_at_line_XlineX_column_XcolumnX", 3346283395112730192L);
        }

        protected ImportDynClassesException(XmlPullParser parser, String msg, String key, long code) {
            super("Error importing classes from file at line %(line) column %(column). " + msg, key, code);
            this.setValue("line", parser.getLineNumber());
            this.setValue("column", parser.getColumnNumber());
        }
    }

    private class PairValueLabel {
        String label = null;
        String value = null;

        private PairValueLabel() {
        }
    }

    private class Definitions
    extends HashMap
    implements Map {
        private static final long serialVersionUID = -3322643637478345069L;

        private Definitions() {
        }

        @Override
        public Object put(Object key, Object value) {
            return super.put(((String)key).toLowerCase(), value);
        }

        @Override
        public Object get(Object theName) {
            DynClass definition2 = (DynClass)super.get(((String)theName).toLowerCase());
            if (definition2 != null) {
                return definition2;
            }
            DynClassName name = DynClassImportHelper.this.manager.createDynClassName((String)theName);
            if (name.getNamespace() == null) {
                for (DynClass definition2 : this.values()) {
                    if (!definition2.getName().equalsIgnoreCase(name.getName())) continue;
                    return definition2;
                }
            } else {
                for (DynClass definition2 : this.values()) {
                    if (definition2.getNamespace() != null || !definition2.getName().equalsIgnoreCase(name.getName())) continue;
                    return definition2;
                }
            }
            return null;
        }

        @Override
        public boolean containsKey(Object key) {
            String lowerKey = ((String)key).toLowerCase();
            if (super.containsKey(lowerKey)) {
                return true;
            }
            Object value = this.get(lowerKey);
            return value != null;
        }
    }

    private class SetDynClassOfValueAction
    implements Runnable {
        private final DynField_v2 field;
        private final String dynClassName;

        public SetDynClassOfValueAction(DynField_v2 field, String dynClassName) {
            this.field = field;
            this.dynClassName = dynClassName;
        }

        @Override
        public void run() {
            DynClass dynStruct = (DynClass)DynClassImportHelper.this.dynClasses.get(this.dynClassName);
            if (dynStruct == null) {
                this.field.setClassOfValue(this.dynClassName);
            } else {
                this.field.setClassOfValue(dynStruct);
            }
        }
    }

    private class SetDynClassOfItemsAction
    implements Runnable {
        private final DynField_v2 field;
        private final String dynClassName;

        public SetDynClassOfItemsAction(DynField_v2 field, String dynClassName) {
            this.field = field;
            this.dynClassName = dynClassName;
        }

        @Override
        public void run() {
            DynClass dynStruct = (DynClass)DynClassImportHelper.this.dynClasses.get(this.dynClassName);
            if (dynStruct == null) {
                this.field.setClassOfItems(this.dynClassName);
            } else {
                this.field.setClassOfItems(dynStruct);
            }
        }
    }

    private class SetCalculateMethodAction
    implements Runnable {
        private final DynField_v2 field;
        private final String methodName;

        public SetCalculateMethodAction(DynField_v2 field, String methodName) {
            this.field = field;
            this.methodName = methodName;
        }

        @Override
        public void run() {
            DynMethod method = null;
            try {
                method = DynClassImportHelper.this.manager.getDynMethod(this.methodName);
                this.field.setCalculateMethod(method);
            }
            catch (DynMethodException ex) {
                LOG.warn("Cant create calculate field", (Throwable)ex);
            }
        }
    }
}

