/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.extensionpoint.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gvsig.tools.extensionpoint.ExtensionBuilder;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.gvsig.tools.extensionpoint.impl.DefaultExtensionPoint;

public class DefaultExtensionPointManager
implements ExtensionPointManager {
    private static DefaultExtensionPointManager manager = null;
    private Map extensionsPoints = new HashMap();

    public static DefaultExtensionPointManager getManager() {
        if (manager == null) {
            manager = new DefaultExtensionPointManager();
        }
        return manager;
    }

    public Object create(Class cls) throws InstantiationException, IllegalAccessException {
        Object obj = null;
        if (cls == null) {
            return null;
        }
        obj = cls.newInstance();
        return obj;
    }

    public Object create(Class cls, Map args) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Object[] argsx = new Object[]{args};
        return this.createObject(cls, argsx);
    }

    public Object create(Class cls, Object[] args) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return this.createObject(cls, args);
    }

    private Constructor findConstructor(Class clazz, Class[] types) throws SecurityException, NoSuchMethodException {
        try {
            return clazz.getConstructor(types);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Constructor<?>[] constrs = clazz.getConstructors();
            for (int i = 0; i < constrs.length; ++i) {
                Class<?>[] paramTypes = constrs[i].getParameterTypes();
                if (paramTypes.length != types.length) continue;
                boolean allMatch = true;
                for (int j = 0; j < paramTypes.length; ++j) {
                    if (this.isParameterCompatible(types[j], paramTypes[j])) continue;
                    allMatch = false;
                    break;
                }
                if (!allMatch) continue;
                return constrs[i];
            }
            StringBuffer strb = new StringBuffer();
            strb.append(clazz.getName());
            strb.append('(');
            if (types.length > 0) {
                for (int i = 0; i < types.length - 1; ++i) {
                    strb.append(types[i].getName());
                    strb.append(',');
                }
                strb.append(types[types.length - 1].getName());
            }
            strb.append(')');
            throw new NoSuchMethodException(strb.toString());
        }
    }

    private boolean isParameterCompatible(Class current, Class defined) {
        if (current == null) {
            return !defined.isPrimitive();
        }
        return defined.isAssignableFrom(current);
    }

    @Override
    public ExtensionPoint create(String name, String description) {
        return new DefaultExtensionPoint(this, name, description);
    }

    @Override
    public boolean add(ExtensionPoint extensionPoint) {
        ExtensionPoint original = (ExtensionPoint)this.extensionsPoints.get(extensionPoint.getName());
        if (original == null) {
            this.extensionsPoints.put(extensionPoint.getName(), extensionPoint);
        } else {
            Iterator iterator = extensionPoint.iterator();
            while (iterator.hasNext()) {
                ExtensionPoint.Extension extension = (ExtensionPoint.Extension)iterator.next();
                if (extension.getBuilder() != null) {
                    original.append(extension.getName(), extension.getDescription(), extension.getBuilder());
                    continue;
                }
                original.append(extension.getName(), extension.getDescription(), extension.getExtension());
            }
        }
        return true;
    }

    @Override
    public synchronized ExtensionPoint add(String name, String description) {
        ExtensionPoint ep = (ExtensionPoint)this.extensionsPoints.get(name);
        if (ep == null) {
            ep = new DefaultExtensionPoint(this, name, description);
            this.extensionsPoints.put(ep.getName(), ep);
        }
        return ep;
    }

    @Override
    public ExtensionPoint add(String name) {
        return this.add(name, null);
    }

    public ExtensionPoint.Extension add(String name, String description, String extName, String extDescription, Class extension) {
        ExtensionPoint ep = this.add(name, description);
        return ep.append(extName, extDescription, extension);
    }

    public ExtensionPoint.Extension add(String name, String description, String extName, String extDescription, ExtensionBuilder builder) {
        ExtensionPoint ep = this.add(name, description);
        return ep.append(extName, extDescription, builder);
    }

    @Override
    public ExtensionPoint get(String name) {
        return (ExtensionPoint)this.extensionsPoints.get(name);
    }

    @Override
    public int getCount() {
        return this.extensionsPoints.size();
    }

    @Override
    public boolean has(String name) {
        return this.extensionsPoints.get(name) != null;
    }

    @Override
    public Iterator interator() {
        return this.extensionsPoints.values().iterator();
    }

    @Override
    public List getNames() {
        Object[] names = (String[])this.extensionsPoints.keySet().toArray();
        Arrays.sort(names);
        return Collections.unmodifiableList(Arrays.asList(names));
    }

    @Override
    public Object createObject(Class klass, Object[] args) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Object obj = null;
        Constructor create = null;
        Class[] types = new Class[args.length];
        if (klass == null) {
            return null;
        }
        for (int n = 0; n < args.length; ++n) {
            Object arg = args[n];
            types[n] = arg != null ? arg.getClass() : null;
        }
        create = this.findConstructor(klass, types);
        obj = create.newInstance(args);
        return obj;
    }
}

