/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.future;

import java.io.File;
import java.io.FileInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.folders.FoldersManager;

public class FutureUtils {
    private static Map<String, Boolean> future_config = null;

    private static void load_future_config() {
        FileInputStream fis = null;
        try {
            FoldersManager folderman = ToolsLocator.getFoldersManager();
            File home = folderman.getHome();
            fis = new FileInputStream(new File(home, ".gvsig-future"));
            Properties props = new Properties();
            props.load(fis);
            future_config = new HashMap<String, Boolean>();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String key = Objects.toString(entry.getKey());
                boolean value = BooleanUtils.toBoolean((String)Objects.toString(entry.getValue()));
                future_config.put(key, value);
            }
        }
        catch (Exception ex) {
            future_config = Collections.EMPTY_MAP;
            IOUtils.closeQuietly(fis);
        }
    }

    public static boolean use(String name) {
        if (future_config == null) {
            FutureUtils.load_future_config();
        }
        return future_config.getOrDefault(name, false);
    }
}

