/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.math;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableInt;

public class BigDecimalUtils {
    public static BigDecimal forceScaleAndEnsurePrecision(BigDecimal d, int s, int p) {
        boolean hasExpectedScale;
        boolean bl = hasExpectedScale = s >= 0;
        if (!(d.precision() != p || hasExpectedScale && d.scale() != s)) {
            return d;
        }
        if (hasExpectedScale) {
            if (d.scale() > s) {
                d = d.setScale(s, RoundingMode.HALF_UP);
            }
            if (d.precision() - d.scale() > p - s) {
                throw new ArithmeticException("Overflow: can't force value '" + BigDecimalUtils.repr(d) + " to (p:" + p + ",s:" + s + ")");
            }
            return d;
        }
        if (d.precision() > p) {
            throw new ArithmeticException("Overflow: can't force value '" + BigDecimalUtils.repr(d) + " to (p:" + p + ",s:" + s + ")");
        }
        return d;
    }

    public static boolean isValid(BigDecimal d, int s, int p) {
        boolean hasExpectedScale;
        if (d == null) {
            return true;
        }
        boolean bl = hasExpectedScale = s >= 0;
        if (!(d.precision() != p || hasExpectedScale && d.scale() != s)) {
            return true;
        }
        if (hasExpectedScale) {
            if (d.scale() > s) {
                try {
                    d = d.setScale(s, RoundingMode.UNNECESSARY);
                }
                catch (Exception e) {
                    return false;
                }
            }
            if (d.precision() - d.scale() > p - s) {
                return false;
            }
        } else if (d.precision() > p) {
            return false;
        }
        return true;
    }

    public static BigDecimal forceScaleAndEnsurePrecisionIfValid(BigDecimal d, MutableInt s, MutableInt p) {
        int i;
        if (d.precision() == p.intValue() && d.scale() == s.intValue()) {
            return d;
        }
        if (d.scale() > s.intValue()) {
            p.setValue(d.precision() + (d.scale() - s.intValue()));
            s.setValue(d.scale());
            return d;
        }
        int di = d.precision() - d.scale();
        if (di > (i = p.intValue() - s.intValue())) {
            s.setValue(Math.max(d.scale(), s.intValue()));
            p.setValue(Math.max(di, i) + s.getValue());
            return d;
        }
        if (d.scale() < s.intValue()) {
            d = d.setScale(s.intValue(), RoundingMode.HALF_UP);
        }
        return d;
    }

    public static String toString(BigDecimal d, int size) {
        return BigDecimalUtils.toString(d, size, -1);
    }

    public static String toString(BigDecimal d, int size, int scale) {
        String s;
        if (scale >= 0 && d.scale() > scale) {
            d = d.setScale(scale, RoundingMode.HALF_UP);
        }
        if ((s = d.toString()).length() <= size) {
            return s;
        }
        if (s.length() - d.scale() > size) {
            throw new ArithmeticException("Overflow: can't represent value '" + BigDecimalUtils.repr(d) + " in size:" + size + ",scale:" + scale + ".");
        }
        return StringUtils.left((String)s, (int)size);
    }

    public static boolean canFitToSize(BigDecimal d, int size) {
        return BigDecimalUtils.canFitToSize(d, size, -1);
    }

    public static boolean canFitToSize(BigDecimal d, int size, int scale) {
        String s;
        if (scale >= 0 && d.scale() > scale) {
            d = d.setScale(scale, RoundingMode.HALF_UP);
        }
        if ((s = d.toString()).length() <= size) {
            return true;
        }
        return s.length() - d.scale() <= size;
    }

    public static BigDecimal parseDecimalEnsurePrecisionRoundScale(String value, int precision, int scale, BigDecimal defaultValue) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        try {
            BigDecimal x = new BigDecimal(value, new MathContext(precision, RoundingMode.HALF_UP));
            if (scale >= 0) {
                x = x.setScale(scale, RoundingMode.HALF_UP);
            }
            return x;
        }
        catch (ArithmeticException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ArithmeticException("Can't parse value '" + value + "'");
        }
    }

    public static String repr(BigDecimal d) {
        return "decimal=" + d.toString() + " (p:" + d.precision() + ",s:" + d.scale() + ")";
    }

    public static boolean equals(BigDecimal d1, BigDecimal d2) {
        if (d1 == d2 || d1.equals(d2)) {
            return true;
        }
        if (d1.scale() == d2.scale()) {
            return false;
        }
        if (d1.scale() > d2.scale()) {
            BigDecimal n = d2.setScale(d1.scale(), RoundingMode.HALF_EVEN);
            return n.equals(d1);
        }
        BigDecimal n = d1.setScale(d2.scale(), RoundingMode.HALF_EVEN);
        return n.equals(d2);
    }

    public static void main(String[] args) {
        BigDecimal d1 = new BigDecimal("-432", new MathContext(6, RoundingMode.HALF_UP));
        BigDecimal d2 = new BigDecimal("-432", new MathContext(6, RoundingMode.HALF_UP)).setScale(3);
        System.out.println(d1.toString());
        System.out.println(d2.toString());
        System.out.println(d1.equals(d2));
        System.out.println(BigDecimalUtils.equals(d1, d2));
    }
}

