/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.namestranslator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.lang.Cloneable;
import org.gvsig.tools.namestranslator.NamesTranslator;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public abstract class AbstractNamesTranslator
implements NamesTranslator,
Persistent {
    protected SimpleList sourceNames;

    protected AbstractNamesTranslator() {
    }

    @Override
    public NamesTranslator clone() throws CloneNotSupportedException {
        AbstractNamesTranslator clone = (AbstractNamesTranslator)super.clone();
        clone.sourceNames = this.sourceNames.clone();
        return clone;
    }

    @Override
    public List<String> getSourceNames() {
        return this.sourceNames.toList();
    }

    @Override
    public void setSourceNames(Iterable<String> names) {
        this.sourceNames = new SimpleList();
        for (String name : names) {
            this.sourceNames.add(name);
        }
        this.build();
    }

    @Override
    public void setSourceNames(String[] names) {
        List<String> asList = Arrays.asList(names);
        this.setSourceNames(asList);
    }

    @Override
    public void setSourceNames(Iterable objs, Function<Object, String> name_getter) {
        this.sourceNames = new SimpleList();
        for (Object obj : objs) {
            String name = name_getter.apply(obj);
            this.sourceNames.add(name);
        }
        this.build();
    }

    @Override
    public String[] getTranslatedNamesAsArray() {
        List<String> l = this.getTranslatedNames();
        return l.toArray(new String[l.size()]);
    }

    @Override
    public String getSource(int index) {
        return this.sourceNames.get(index);
    }

    @Override
    public boolean isValid(String name) {
        return StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)this.getSuggestion(name));
    }

    protected abstract void build();

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition("ClassName") == null) {
            DynStruct definition = manager.addDefinition(AbstractNamesTranslator.class, "AbstractNamesTranslator", "AbstractNamesTranslator persistence definition", null, null);
            definition.addDynFieldList("sourceNames").setClassOfItems(String.class);
        }
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("sourceNames", this.sourceNames.toList());
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        List sourceNamesState = state.getList("sourceNames");
        SimpleList sourceNamesList = new SimpleList();
        for (Object object : sourceNamesState) {
            sourceNamesList.add((String)object);
        }
        this.sourceNames = sourceNamesList;
    }

    protected static class SimpleList
    implements Iterable<String>,
    Cloneable {
        public List<String> list = new ArrayList<String>();

        @Override
        public SimpleList clone() throws CloneNotSupportedException {
            SimpleList clone = (SimpleList)super.clone();
            clone.list = new ArrayList<String>(this.list);
            return clone;
        }

        public void add(String s) {
            this.list.add(s);
        }

        public boolean contains(String s) {
            for (String listElement : this.list) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)s, (CharSequence)listElement)) continue;
                return true;
            }
            return false;
        }

        public int indexOf(String s) {
            for (int i = 0; i < this.list.size(); ++i) {
                String element = this.list.get(i);
                if (!StringUtils.equalsIgnoreCase((CharSequence)s, (CharSequence)element)) continue;
                return i;
            }
            return -1;
        }

        public int size() {
            return this.list.size();
        }

        public String get(int index) {
            return this.list.get(index);
        }

        public void set(int index, String s) {
            this.list.set(index, s);
        }

        @Override
        public Iterator<String> iterator() {
            return this.list.iterator();
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public List<String> toList() {
            return this.list;
        }

        public boolean hasUniqueValues() {
            HashSet<String> sourceNamesSet = new HashSet<String>();
            for (String sourceName : this.list) {
                sourceNamesSet.add(sourceName.toLowerCase());
            }
            return sourceNamesSet.size() == this.list.size();
        }
    }

    protected static class SimpleMap
    implements Cloneable {
        public Map<String, String> map = new HashMap<String, String>();

        public String get(String name) {
            return this.map.get(name.toLowerCase());
        }

        public void put(String name, String element) {
            this.map.put(name.toLowerCase(), element);
        }

        public Map<String, String> toMap() {
            return this.map;
        }

        public int size() {
            return this.map.size();
        }

        @Override
        public SimpleMap clone() throws CloneNotSupportedException {
            SimpleMap clone = (SimpleMap)super.clone();
            clone.map = new HashMap<String, String>(this.map);
            return clone;
        }
    }
}

