/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.namestranslator;

import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.namestranslator.BaseNamesTranslator;
import org.gvsig.tools.namestranslator.NamesTranslator;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class TrimNamesTranslator
extends BaseNamesTranslator {
    protected int maxNameLen;

    public TrimNamesTranslator() {
    }

    protected TrimNamesTranslator(int maxNameLen) {
        if (maxNameLen < 5) {
            throw new IllegalArgumentException("Invalid max name len, can be greater than 4.");
        }
        this.maxNameLen = maxNameLen;
    }

    @Override
    public NamesTranslator clone() throws CloneNotSupportedException {
        TrimNamesTranslator clone = (TrimNamesTranslator)super.clone();
        return clone;
    }

    @Override
    public boolean isValid(String name) {
        int len;
        String sourceName = name;
        if (StringUtils.isBlank((CharSequence)sourceName)) {
            sourceName = "field";
        }
        return (len = sourceName.length()) <= this.maxNameLen && !this.translatedNames.contains(sourceName);
    }

    @Override
    public String getSuggestion(String name) {
        int len;
        String sourceName = name;
        if (StringUtils.isBlank((CharSequence)sourceName)) {
            sourceName = "field";
        }
        if ((len = sourceName.length()) <= this.maxNameLen && !this.translatedNames.contains(sourceName)) {
            return sourceName;
        }
        for (int i = 0; i < 255; ++i) {
            String translatedName = len <= this.maxNameLen ? (i <= 9 ? (len + 2 > this.maxNameLen ? sourceName.substring(0, this.maxNameLen - 2) + "_" + i : sourceName + "_" + i) : (i <= 99 ? (len + 2 > this.maxNameLen ? sourceName.substring(0, this.maxNameLen - 2) + i : sourceName + i) : (len + 3 > this.maxNameLen - 1 ? sourceName.substring(0, this.maxNameLen - 3) + i : sourceName + i))) : (i == 0 ? sourceName.substring(0, this.maxNameLen) : (i <= 9 ? sourceName.substring(0, this.maxNameLen - 2) + "_" + i : (i <= 99 ? sourceName.substring(0, this.maxNameLen - 2) + i : sourceName.substring(0, this.maxNameLen - 3) + i)));
            if (this.translatedNames.contains(translatedName)) continue;
            return translatedName;
        }
        return sourceName.substring(0, this.maxNameLen - 7) + "_" + System.currentTimeMillis() % 1000000L;
    }

    @Override
    public int setTranslation(String sourceName, String translatedName) {
        translatedName = StringUtils.left((String)translatedName, (int)this.maxNameLen);
        return super.setTranslation(sourceName, translatedName);
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition("TrimNamesTranslator") == null) {
            DynStruct definition = manager.addDefinition(TrimNamesTranslator.class, "TrimNamesTranslator", "TrimNamesTranslator persistence definition", null, null);
            definition.addDynFieldInt("maxNameLen");
            definition.extend(manager.getDefinition("BaseNamesTranslator"));
        }
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set("maxNameLen", this.maxNameLen);
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.maxNameLen = state.getInt("maxNameLen");
    }
}

