/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.packageutils.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.packageutils.Dependencies;
import org.gvsig.tools.packageutils.Dependency;
import org.gvsig.tools.packageutils.PackageInfo;
import org.gvsig.tools.packageutils.PackageManager;
import org.gvsig.tools.packageutils.Version;
import org.gvsig.tools.packageutils.impl.DefaultDependencies;
import org.gvsig.tools.packageutils.impl.DefaultDependency;
import org.gvsig.tools.packageutils.impl.DefaultPackageInfo;
import org.gvsig.tools.packageutils.impl.DefaultVersion;
import org.gvsig.tools.packageutils.impl.PackageInfoFileReader;
import org.gvsig.tools.packageutils.impl.PackageInfoFileWriter;

public class DefaultPackageManager
implements PackageManager {
    private String operatingSystemName;
    private String operatingSystemFamily;
    private String operatingSystemVersion;

    @Override
    public Version createVersion() {
        return new DefaultVersion();
    }

    @Override
    public Version createVersion(String version) {
        DefaultVersion v = new DefaultVersion();
        v.parse(version);
        return v;
    }

    @Override
    public PackageInfo createPackageInfo() {
        return new DefaultPackageInfo();
    }

    @Override
    public PackageInfo createPackageInfo(InputStream packegeinfo) throws BaseException {
        PackageInfo pkg = this.createPackageInfo();
        try {
            this.readPacakgeInfo(pkg, packegeinfo);
        }
        catch (IOException e) {
            throw new BaseIOException((Throwable)e);
        }
        return pkg;
    }

    @Override
    public PackageInfo createPackageInfo(File packegeinfo) throws BaseException {
        PackageInfo pkg = this.createPackageInfo();
        try {
            this.readPacakgeInfo(pkg, packegeinfo);
        }
        catch (IOException e) {
            throw new BaseIOException(packegeinfo, e);
        }
        return pkg;
    }

    @Override
    public Dependency createDependency() {
        return new DefaultDependency();
    }

    @Override
    public Dependency createDependency(PackageInfo packageInfo) {
        DefaultDependency dependency = (DefaultDependency)this.createDependency();
        dependency.fromPackageInfo(packageInfo);
        return dependency;
    }

    @Override
    public Dependencies createDependencies() {
        return new DefaultDependencies();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadOperatingSystemInfo() {
        block6: {
            String osversion;
            String osname;
            block7: {
                osname = System.getProperty("os.name");
                osversion = System.getProperty("os.version");
                if (!osname.toLowerCase().startsWith("linux")) break block7;
                this.operatingSystemFamily = "lin";
                FileInputStream fis = null;
                try {
                    Properties p = new Properties();
                    fis = new FileInputStream("/etc/os-release");
                    p.load(fis);
                    this.operatingSystemName = p.getProperty("ID", null);
                    this.operatingSystemVersion = p.getProperty("VERSION_ID", null);
                    this.operatingSystemName = StringUtils.removeEnd((String)this.operatingSystemName, (String)"\"");
                    this.operatingSystemName = StringUtils.removeStart((String)this.operatingSystemName, (String)"\"");
                    this.operatingSystemName = StringUtils.trimToNull((String)this.operatingSystemName);
                    this.operatingSystemVersion = StringUtils.removeEnd((String)this.operatingSystemVersion, (String)"\"");
                    this.operatingSystemVersion = StringUtils.removeStart((String)this.operatingSystemVersion, (String)"\"");
                    this.operatingSystemVersion = StringUtils.trimToNull((String)this.operatingSystemVersion);
                }
                catch (Exception exception) {
                    IOUtils.closeQuietly(fis);
                    break block6;
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fis);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)fis);
                break block6;
            }
            if (osname.toLowerCase().startsWith("window")) {
                this.operatingSystemFamily = "win";
                String s = osname.replace(" ", "");
                s = s.replace("_", "");
                this.operatingSystemName = s = s.replace("-", "");
                this.operatingSystemVersion = osversion;
            } else {
                String s = osname.replace(" ", "");
                s = s.replace("_", "");
                this.operatingSystemFamily = s = s.replace("-", "");
                this.operatingSystemName = null;
                this.operatingSystemVersion = osversion;
            }
        }
    }

    @Override
    public String getOperatingSystem() {
        if (this.operatingSystemFamily == null) {
            this.loadOperatingSystemInfo();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.operatingSystemFamily);
        if (this.operatingSystemName != null) {
            builder.append("_");
            builder.append(this.operatingSystemName);
            if (this.operatingSystemVersion != null) {
                builder.append("_");
                builder.append(this.operatingSystemVersion);
            }
        }
        return builder.toString();
    }

    @Override
    public String getOperatingSystemFamily() {
        if (this.operatingSystemFamily == null) {
            this.loadOperatingSystemInfo();
        }
        return this.operatingSystemFamily;
    }

    @Override
    public String getOperatingSystemName() {
        if (this.operatingSystemFamily == null) {
            this.loadOperatingSystemInfo();
        }
        return this.operatingSystemName;
    }

    @Override
    public String getOperatingSystemVersion() {
        if (this.operatingSystemFamily == null) {
            this.loadOperatingSystemInfo();
        }
        return this.operatingSystemVersion;
    }

    @Override
    public String getArchitecture() {
        String osarch = System.getProperty("os.arch");
        if (osarch.toLowerCase().startsWith("i386")) {
            return "x86";
        }
        if (osarch.toLowerCase().startsWith("i686")) {
            return "x86";
        }
        if (osarch.toLowerCase().startsWith("x86_64")) {
            return "x86_64";
        }
        if (osarch.toLowerCase().startsWith("x86")) {
            return "x86";
        }
        if (osarch.toLowerCase().startsWith("amd64")) {
            return "x86_64";
        }
        return osarch;
    }

    @Override
    public void writePacakgeInfo(PackageInfo packageInfo, File file) throws IOException {
        PackageInfoFileWriter writer = new PackageInfoFileWriter();
        writer.write(packageInfo, file);
    }

    @Override
    public void writePacakgeInfo(PackageInfo pkg, OutputStream os) throws IOException {
        PackageInfoFileWriter writer = new PackageInfoFileWriter();
        writer.write(pkg, os);
    }

    @Override
    public void readPacakgeInfo(PackageInfo packageInfo, File file) throws IOException {
        PackageInfoFileReader reader = new PackageInfoFileReader();
        reader.read(packageInfo, file);
    }

    @Override
    public void readPacakgeInfo(PackageInfo pkg, InputStream is) throws IOException {
        PackageInfoFileReader reader = new PackageInfoFileReader();
        reader.read(pkg, is);
    }

    public class BaseIOException
    extends BaseException {
        private static final long serialVersionUID = 3154855738763990310L;

        public BaseIOException(Throwable cause) {
            super("Can't load package info", "_Cant_load_package_info", 3154855738763990310L);
        }

        public BaseIOException(File file, Throwable cause) {
            super("Can't load package info %(file)", "_Cant_load_package_info_XfileX", 3154855738763990310L);
            this.setValue("file", file);
        }
    }
}

