/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynObjectManager;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceFactory;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public abstract class AbstractMultiPersistenceFactory
implements PersistenceFactory {
    protected List classes;
    protected List definitions = new ArrayList();
    protected Map nameToDefinition;
    protected Map nameToClass;

    protected AbstractMultiPersistenceFactory() {
        this.classes = new ArrayList();
        this.nameToDefinition = new HashMap();
        this.nameToClass = new HashMap();
        this.makeDefinitions();
    }

    protected DynStruct addDefinition(Class managedClass, String name, String description) {
        DynObjectManager dynman = ToolsLocator.getDynObjectManager();
        DynClass definition = dynman.createDynClass("Persistence", name, description);
        dynman.add(definition);
        this.definitions.add(definition);
        this.nameToDefinition.put(managedClass.getName(), definition);
        this.nameToDefinition.put(definition.getFullName(), definition);
        if (definition.getNamespace().equals("Persistence")) {
            this.nameToDefinition.put(definition.getName(), definition);
        }
        this.addManagedClass(managedClass, definition);
        return definition;
    }

    protected void addManagedClass(Class managedClass, DynClass definition) {
        if (!this.classes.contains(managedClass)) {
            this.classes.add(managedClass);
        }
        this.nameToClass.put(managedClass.getName(), managedClass);
        this.nameToClass.put(definition.getFullName(), managedClass);
        if (definition.getNamespace().equals("Persistence")) {
            this.nameToClass.put(definition.getName(), managedClass);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName()).append("[").append(this.hashCode()).append("]").append("( ").append("managedClasses='").append(this.classes.toString()).append("', ").append("structs='").append(this.definitions.toString()).append(" )");
        return buffer.toString();
    }

    @Override
    public void loadFromState(PersistentState state, Object object) throws PersistenceException {
    }

    @Override
    public String getDomainName() {
        return "gvsig";
    }

    @Override
    public String getDomainURL() {
        return "http://www.gvsig.org";
    }

    @Override
    public List getDefinitions() {
        return this.definitions;
    }

    @Override
    public List getManagedClasses() {
        return this.classes;
    }

    @Override
    public DynStruct getDefinition(String className) {
        return (DynStruct)this.nameToDefinition.get(className);
    }

    @Override
    public boolean manages(Object object) {
        return this.manages(object.getClass());
    }

    @Override
    public boolean manages(Class theClass) {
        for (Class theInterface : this.getManagedClasses()) {
            if (!theInterface.isAssignableFrom(theClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean manages(PersistentState state) {
        return this.nameToClass.get(state.getTheClassName()) != null;
    }

    @Override
    public Class getManagedClass(PersistentState state) {
        return (Class)this.nameToClass.get(state.getTheClassName());
    }

    @Override
    public Class getManagedClass(String name) {
        return (Class)this.nameToClass.get(name);
    }

    @Override
    public Class getManagedClass(Object object) {
        for (Class theInterface : this.getManagedClasses()) {
            if (!theInterface.isInstance(object)) continue;
            return theInterface;
        }
        return null;
    }

    @Override
    public String getManagedClassName(Object object) {
        Class clazz = this.getManagedClass(object);
        if (clazz != null) {
            return clazz.getName();
        }
        return null;
    }

    protected abstract void makeDefinitions();
}

