/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.persistence.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.gvsig.tools.persistence.PersistenceFactory;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.impl.DynObjectPersistenceFactory;
import org.gvsig.tools.persistence.impl.exception.PersistenceInvalidDomainNameException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFactories
extends ArrayList
implements PersistenceManager.Factories {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultFactories.class);
    private static final long serialVersionUID = -3790704153805598236L;
    private static final Pattern VALID_DOMAIN_NAME_PATTERN = Pattern.compile("[\\w][\\d\\w_]*");
    private Map classToFactoryCache = new HashMap();

    public DefaultFactories() {
        this.add(new DynObjectPersistenceFactory());
    }

    @Override
    public boolean add(PersistenceFactory factory, String classNameAlias) {
        if (!super.contains(factory)) {
            this.add(factory);
        }
        this.classToFactoryCache.put(classNameAlias, factory);
        return true;
    }

    @Override
    public boolean add(PersistenceFactory factory) {
        if (factory.getDomainName() == null) {
            throw new PersistenceInvalidDomainNameException();
        }
        if (!VALID_DOMAIN_NAME_PATTERN.matcher(factory.getDomainName()).matches()) {
            throw new PersistenceInvalidDomainNameException(factory.getDomainName());
        }
        List factoryManagedClasses = factory.getManagedClasses();
        for (Class theClass : factoryManagedClasses) {
            this.classToFactoryCache.put(theClass.getName(), factory);
        }
        if (this.size() < 1) {
            super.add(factory);
        } else {
            super.add(this.size() - 1, factory);
        }
        return true;
    }

    public PersistenceFactory get(String className) {
        PersistenceFactory factory = (PersistenceFactory)this.classToFactoryCache.get(className);
        if (factory != null) {
            return factory;
        }
        Iterator factoriesIterator = super.iterator();
        while (factoriesIterator.hasNext()) {
            factory = (PersistenceFactory)factoriesIterator.next();
            if (factory.getDefinition(className) == null) continue;
            this.classToFactoryCache.put(className, factory);
            return factory;
        }
        return null;
    }

    @Override
    public PersistenceFactory get(Class theClass) {
        String className = theClass.getName();
        PersistenceFactory factory = (PersistenceFactory)this.classToFactoryCache.get(className);
        if (factory != null) {
            LOG.debug("DefaultFactories.get2(" + theClass.getName() + ") --> " + factory.getClass().getName() + " (cached).");
            return factory;
        }
        ArrayList<PersistenceFactory> factories = new ArrayList<PersistenceFactory>();
        Iterator factoriesIterator = super.iterator();
        while (factoriesIterator.hasNext()) {
            factory = (PersistenceFactory)factoriesIterator.next();
            if (factory.getDefinition(className) == null && !factory.manages(theClass)) continue;
            factories.add(factory);
        }
        if (factories.isEmpty()) {
            return null;
        }
        if (factories.size() == 1) {
            factory = (PersistenceFactory)factories.get(0);
            this.classToFactoryCache.put(className, factory);
            LOG.debug("DefaultFactories.get2(" + theClass.getName() + ") --> " + factory.getClass().getName() + ".");
            return factory;
        }
        for (PersistenceFactory factory1 : factories) {
            if (!factory1.getManagedClasses().contains(theClass)) continue;
            this.classToFactoryCache.put(className, factory1);
            LOG.debug("DefaultFactories.get2(" + theClass.getName() + ") ==> " + factory1.getClass().getName() + ".");
            return factory1;
        }
        return null;
    }

    @Override
    public PersistenceFactory get(Object object) {
        if (object instanceof String) {
            return this.get((String)object);
        }
        return this.get(object.getClass());
    }

    @Override
    public PersistenceFactory get(PersistentState state) {
        return this.get(state.getTheClassName());
    }
}

