/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.persistence.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableInt;
import org.gvsig.tools.persistence.PersistenceFactory;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentContext;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceClassNotRegistered;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.persistence.exception.PersistenceRuntimeException;
import org.gvsig.tools.persistence.exception.PersistenceValidateExceptions;
import org.gvsig.tools.persistence.impl.exception.ObjectNotFoundException;
import org.gvsig.tools.persistence.impl.exception.PersistenceIDNotLoadedException;
import org.gvsig.tools.persistence.spi.PersistentContextServices;
import org.gvsig.tools.persistence.spi.PersistentIdentifier;
import org.gvsig.tools.persistence.spi.PersistentStateServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPersistentContext
implements PersistentContextServices {
    private static Logger LOG = LoggerFactory.getLogger(DefaultPersistentContext.class);
    private Map idToReference;
    private Map objToReference;
    private PersistentIdentifier rootId;
    private PersistenceManager manager;
    private boolean collectErrors;
    private PersistenceException errors;
    private boolean validated;
    private MutableInt referenceCounter;

    public DefaultPersistentContext(PersistenceManager manager, MutableInt referenceCounter) {
        this.manager = manager;
        this.collectErrors = false;
        this.errors = null;
        this.validated = false;
        this.referenceCounter = referenceCounter;
        this.idToReference = new LinkedHashMap();
        this.objToReference = new LinkedHashMap();
    }

    @Override
    public PersistentIdentifier getNewIdentifier() {
        return new DefaultPersistentIdentifier(String.valueOf(this.referenceCounter.getAndIncrement()));
    }

    @Override
    public PersistentIdentifier getIdentifier(String id) throws PersistenceException {
        for (ContextValue value : this.idToReference.values()) {
            if (!((DefaultPersistentIdentifier)value.getId()).hasValue(id)) continue;
            return value.getId();
        }
        return new DefaultPersistentIdentifier(id);
    }

    @Override
    public PersistentContextServices.ObjectReference add(PersistentIdentifier id) throws PersistenceException {
        this.validated = false;
        ContextValue value = (ContextValue)this.idToReference.get(id);
        if (value == null) {
            value = new ContextValue(id, null);
            this.idToReference.put(value.getId(), value);
        }
        return value;
    }

    @Override
    public PersistentContextServices.ObjectReference add(PersistentState state, Object obj) throws PersistenceException {
        this.validated = false;
        PersistentIdentifier id = ((PersistentStateServices)state).getId();
        ContextValue value = (ContextValue)this.idToReference.get(id);
        if (value == null) {
            value = new ContextValue(id, state);
            this.idToReference.put(value.getId(), value);
        }
        if (value.getState() == null) {
            value.state = state;
        }
        if (obj != null) {
            value.update(obj);
            this.objToReference.put(obj, value);
        }
        return value;
    }

    @Override
    public PersistentContextServices.ObjectReference get(PersistentState state) throws PersistenceException {
        PersistentIdentifier id = ((PersistentStateServices)state).getId();
        ContextValue ref = (ContextValue)this.idToReference.get(id);
        if (ref == null) {
            ref = new ContextValue(id, state);
            this.idToReference.put(id, ref);
        }
        return ref;
    }

    @Override
    public PersistentContextServices.ObjectReference get(PersistentIdentifier id) {
        ContextValue value = (ContextValue)this.idToReference.get(id);
        return value;
    }

    @Override
    public PersistentContextServices.ObjectReference get(Object obj) {
        return (ContextValue)this.objToReference.get(obj);
    }

    private void updateObjectInReference(ContextValue ref) throws PersistenceException {
        PersistentStateServices state = (PersistentStateServices)ref.getState();
        PersistenceFactory factory = this.manager.getFactories().get(state);
        if (factory == null) {
            String classname = "";
            if (state == null) {
                classname = "[State is null]";
            } else {
                classname = state.getTheClassName();
                if (classname == null) {
                    classname = "[Null]";
                }
            }
            throw new PersistenceClassNotRegistered(classname);
        }
        state.setFactory(factory);
        ref.update(factory.createFromState(state));
        factory.loadFromState(state, ref.getObject());
        this.objToReference.put(ref.getObject(), ref);
    }

    @Override
    public void update(PersistentContextServices.ObjectReference ref) throws PersistenceException {
        this.validated = false;
        this.updateObjectInReference((ContextValue)ref);
    }

    private void updateAll() throws PersistenceException {
        Iterator it = this.idToReference.entrySet().iterator();
        while (it.hasNext()) {
            ContextValue ref = (ContextValue)it.next().getValue();
            this.update(ref);
        }
    }

    @Override
    public void clear() {
        this.validated = false;
        Iterator it = this.idToReference.entrySet().iterator();
        while (it.hasNext()) {
            ContextValue ref = (ContextValue)it.next().getValue();
            ref.update(null);
        }
    }

    @Override
    public Iterator iterator() {
        final class StatesIterator
        implements Iterator {
            private Iterator referenceIterator;

            StatesIterator(Map idToReference) {
                this.referenceIterator = idToReference.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.referenceIterator.hasNext();
            }

            public Object next() {
                ContextValue ref = (ContextValue)((Map.Entry)this.referenceIterator.next()).getValue();
                return ref.getState();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
        return new StatesIterator(this.idToReference);
    }

    @Override
    public PersistentState getState(Integer id) throws PersistenceException {
        ContextValue ref = (ContextValue)this.get(id);
        if (ref == null) {
            throw new PersistenceIDNotLoadedException(id);
        }
        return ref.getState();
    }

    @Override
    public PersistentState getState(Object obj) throws PersistenceException {
        ContextValue ref = (ContextValue)this.get(obj);
        if (ref == null) {
            return null;
        }
        return ref.getState();
    }

    @Override
    public Object getObject(Integer id) throws PersistenceException {
        ContextValue ref = (ContextValue)this.get(id);
        if (ref == null) {
            throw new PersistenceIDNotLoadedException(id);
        }
        return ref.getObject();
    }

    @Override
    public PersistentIdentifier getId(Object obj) throws PersistenceException {
        ContextValue ref = (ContextValue)this.get(obj);
        if (ref != null) {
            return ref.getId();
        }
        this.updateAll();
        ref = (ContextValue)this.get(obj);
        if (ref == null) {
            throw new ObjectNotFoundException();
        }
        return ref.getId();
    }

    @Override
    public void setRootId(PersistentIdentifier id) {
        this.rootId = id;
    }

    @Override
    public PersistentContextServices.ObjectReference getRoot() throws PersistenceException {
        PersistentContextServices.ObjectReference root = this.get(this.rootId);
        return root;
    }

    @Override
    public void setCollectErrors(boolean collectErrors) {
        this.collectErrors = collectErrors;
    }

    @Override
    public boolean getCollectErrors() {
        return this.collectErrors;
    }

    @Override
    public void addError(Throwable cause) {
        if (this.errors == null) {
            this.errors = new PersistenceException();
        }
        this.errors.add(cause);
    }

    @Override
    public PersistenceException getErrors() {
        return this.errors;
    }

    @Override
    public void validate(int mode) throws PersistenceValidateExceptions {
        if (this.validated) {
            return;
        }
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            PersistentState astate = (PersistentState)it.next();
            try {
                this.manager.validate(astate, mode);
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        this.validated = true;
        if (exceptions.size() > 0) {
            throw new PersistenceValidateExceptions(exceptions);
        }
    }

    private class ContextValue
    implements PersistentContextServices.ObjectReference,
    Comparable {
        private Object obj;
        private PersistentState state;
        private PersistentIdentifier id;
        private boolean isNullStateReported;

        ContextValue(PersistentIdentifier id, PersistentState state) {
            this.id = id;
            this.state = state;
            this.obj = null;
            this.isNullStateReported = false;
        }

        @Override
        public boolean hasObject() {
            return this.obj != null;
        }

        @Override
        public Object getObject() {
            if (this.state == null) {
                if (!this.isNullStateReported) {
                    try {
                        throw new IllegalArgumentException("The persistent storage may be corrupt. Can't have state for id '" + this.id + "'.");
                    }
                    catch (Exception ex) {
                        this.getContext().addError(ex);
                        LOG.warn(ex.getMessage(), (Throwable)ex);
                        this.isNullStateReported = true;
                    }
                }
                return null;
            }
            if (this.obj == null) {
                try {
                    DefaultPersistentContext.this.updateObjectInReference(this);
                }
                catch (Exception e) {
                    if (this.getContext().getCollectErrors()) {
                        this.getContext().addError(e);
                        LOG.warn(e.getMessage(), (Throwable)e);
                    }
                    throw new PersistenceRuntimeException(e);
                }
            }
            return this.obj;
        }

        @Override
        public PersistentState getState() {
            return this.state;
        }

        @Override
        public PersistentIdentifier getId() {
            return this.id;
        }

        protected void update(Object object) {
            this.obj = object;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ContextValue)) {
                return false;
            }
            return this.id.equals(((ContextValue)obj).id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public String toString() {
            String idStr = this.id == null ? "null" : this.id.toString();
            return this.getClass().getName().concat(": id = ").concat(idStr);
        }

        public int compareTo(Object arg0) {
            if (!(this.obj instanceof ContextValue)) {
                return -1;
            }
            return ((DefaultPersistentIdentifier)this.id).compareTo(((ContextValue)this.obj).id);
        }

        @Override
        public PersistentContext getContext() {
            return DefaultPersistentContext.this;
        }
    }

    private class DefaultPersistentIdentifier
    implements PersistentIdentifier,
    Comparable {
        private String value;

        DefaultPersistentIdentifier(String value) {
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DefaultPersistentIdentifier)) {
                return false;
            }
            return this.value == ((DefaultPersistentIdentifier)obj).value;
        }

        public boolean hasValue(Object value) {
            return this.value.equals(value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return this.value;
        }

        public int compareTo(Object obj) {
            if (!(obj instanceof DefaultPersistentIdentifier)) {
                return -1;
            }
            return this.value.compareTo(((DefaultPersistentIdentifier)obj).value);
        }
    }
}

