/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.resourcesstorage;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.gvsig.tools.resourcesstorage.AbstractResourcesStorage;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.gvsig.tools.util.HasAFile;

public class FilesResourcesStorage
extends AbstractResourcesStorage {
    private final List<String> resourcesPaths = new ArrayList<String>();

    public FilesResourcesStorage(String fullPathName) {
        this.resourcesPaths.add(fullPathName);
    }

    public FilesResourcesStorage(List<String> fullPathNames) {
        this.resourcesPaths.addAll(fullPathNames);
    }

    @Override
    public ResourcesStorage.Resource getResource(String resourceName) {
        return new FileResource(resourceName, this.getResourceFile(resourceName));
    }

    public List<String> getPaths() {
        return this.resourcesPaths;
    }

    @Override
    public List<String> getResourceNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (String pathName : this.resourcesPaths) {
            File folder = new File(pathName);
            if (folder.isDirectory()) {
                for (File f : folder.listFiles()) {
                    if (!f.isFile()) continue;
                    names.add(f.getName());
                }
                continue;
            }
            File parent = folder.getParentFile();
            String prefix = pathName + this.getSeparator();
            int prefix_len = prefix.length();
            for (File f : parent.listFiles()) {
                String fname;
                if (!f.isFile() || !StringUtils.startsWithIgnoreCase((CharSequence)(fname = f.getName()), (CharSequence)prefix)) continue;
                names.add(fname.substring(prefix_len));
            }
        }
        return names;
    }

    @Override
    public boolean add(String resourceName, InputStream is) {
        String pathName = this.resourcesPaths.get(0);
        File folder = new File(pathName);
        File file = folder.isDirectory() ? new File(folder, resourceName) : new File(pathName + this.getSeparator() + resourceName);
        FileResource fres = new FileResource(pathName, file);
        try {
            IOUtils.copy((InputStream)is, (OutputStream)fres.asOutputStream());
            fres.close();
            is.close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public boolean remove(String resourceName) {
        File fileToRemove = this.getResourceFile(resourceName);
        return FileUtils.deleteQuietly((File)fileToRemove);
    }

    @Override
    public boolean allowRemove() {
        return true;
    }

    private File getResourceFile(String resourceName) {
        File fres;
        for (String pathName : this.resourcesPaths) {
            File folder = new File(pathName);
            fres = folder.isDirectory() ? new File(folder, resourceName) : new File(pathName + this.getSeparator() + resourceName);
            if (!fres.exists()) continue;
            return fres;
        }
        String pathName = this.resourcesPaths.get(0);
        File folder = new File(pathName);
        fres = folder.isDirectory() ? new File(folder, resourceName) : new File(pathName + this.getSeparator() + resourceName);
        return fres;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        if (this.resourcesPaths != null) {
            builder.append("resourcesPaths", this.resourcesPaths.toArray(), true);
        }
        return builder.toString();
    }

    public static class FileResource
    extends AbstractResourcesStorage.AbstractResource
    implements ResourcesStorage.Resource,
    HasAFile {
        private final File resource;
        private InputStream in;
        private OutputStream out;

        public FileResource(String name, File resource) {
            super(name);
            this.resource = resource;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public URL getURL() {
            try {
                return this.resource.toURI().toURL();
            }
            catch (MalformedURLException ex) {
                return null;
            }
        }

        @Override
        public File getFile() {
            return this.resource;
        }

        @Override
        public boolean exists() {
            return this.resource.exists();
        }

        @Override
        public InputStream asInputStream() throws FileNotFoundException {
            if (this.out != null || this.in != null) {
                throw new IllegalStateException("Already open");
            }
            this.in = new FileInputStream(this.resource);
            return new ResourceInputStream();
        }

        @Override
        public OutputStream asOutputStream() throws FileNotFoundException {
            if (this.out != null || this.in != null) {
                throw new IllegalStateException("Already open");
            }
            FileOutputStream os = new FileOutputStream(this.resource);
            BufferedOutputStream bos = new BufferedOutputStream(os);
            this.out = bos;
            return new ResourceOutputStream();
        }

        @Override
        public void close() {
            IOUtils.closeQuietly((OutputStream)this.out);
            IOUtils.closeQuietly((InputStream)this.in);
            this.in = null;
            this.out = null;
        }

        @Override
        public void setFile(File file) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        private class ResourceOutputStream
        extends OutputStream {
            private ResourceOutputStream() {
            }

            @Override
            public void write(int b) throws IOException {
                FileResource.this.out.write(b);
            }

            @Override
            public void flush() throws IOException {
                FileResource.this.out.flush();
            }

            @Override
            public void close() throws IOException {
                FileResource.this.close();
            }
        }

        private class ResourceInputStream
        extends InputStream {
            private ResourceInputStream() {
            }

            @Override
            public int read() throws IOException {
                return FileResource.this.in.read();
            }

            @Override
            public void close() throws IOException {
                FileResource.this.close();
            }
        }
    }
}

