/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class URLUtils {
    public static InputStream openStream(URL url) {
        if (url == null) {
            return null;
        }
        try {
            return url.openStream();
        }
        catch (IOException iOException) {
            FileInputStream is;
            File f;
            String protocol = url.getProtocol();
            String path = url.getPath();
            if (protocol == null || path == null || path.isEmpty() || !protocol.equalsIgnoreCase("file")) {
                return null;
            }
            String host = url.getHost();
            int l = host == null ? 0 : host.length();
            switch (l) {
                case 0: {
                    if (path.charAt(0) == '/' || path.charAt(2) == ':') {
                        f = new File(path.substring(1));
                        break;
                    }
                    f = new File(path);
                    break;
                }
                case 1: {
                    f = new File(host + ":" + path);
                    break;
                }
                case 2: {
                    if (host.charAt(1) != ':') {
                        return null;
                    }
                    f = new File(host + path);
                    break;
                }
                default: {
                    return null;
                }
            }
            try {
                is = new FileInputStream(f);
            }
            catch (FileNotFoundException ex) {
                return null;
            }
            return is;
        }
    }

    public static String toPath(URL url) {
        if (url == null) {
            return null;
        }
        try {
            String path = URLUtils.isDynamic(url) ? url.getPath() : url.toURI().getPath();
            return path;
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static File toFile(URL url) {
        if (url == null) {
            return null;
        }
        String protocol = url.getProtocol();
        String path = url.getPath();
        if (protocol == null || path == null || path.isEmpty() || !protocol.equalsIgnoreCase("file")) {
            return null;
        }
        if (!URLUtils.isDynamic(url)) {
            return FileUtils.toFile((URL)url);
        }
        return new File(path);
    }

    public static boolean isDynamic(URL url) {
        if (url == null) {
            return false;
        }
        return StringUtils.contains((CharSequence)url.toString(), (CharSequence)"<%=");
    }

    public static boolean isDynamic(File file) {
        if (file == null) {
            return false;
        }
        return StringUtils.contains((CharSequence)file.toString(), (CharSequence)"<%=");
    }

    public static boolean isDynamic(URI uri) {
        if (uri == null) {
            return false;
        }
        return StringUtils.contains((CharSequence)uri.toString(), (CharSequence)"<%=");
    }

    public static URL toURL(File f) {
        URL url;
        if (f == null) {
            return null;
        }
        try {
            url = URLUtils.isDynamic(f) ? new URL("file", null, f.getPath()) : f.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
        return url;
    }

    public static boolean isFileURL(URL url) {
        String protocol = url.getProtocol();
        return StringUtils.equalsIgnoreCase((CharSequence)protocol, (CharSequence)"file");
    }

    public static void main(String[] args) throws MalformedURLException {
        File f = new File("C:\\Users\\jolic\\gvSIG\\plugins\\org.gvsig.scripting.app.mainplugin\\2.5.1\\scripts\\addons\\Arena2Reader\\i18n\\text.properties");
        URLUtils.openStream(f.toURI().toURL());
        URLUtils.openStream(new URL("file:/C:/text.properties"));
        URLUtils.openStream(new URL("file://C:/text.properties"));
        URLUtils.openStream(new URL("file:///C:/text.properties"));
        URLUtils.openStream(new URL("file:////etc/hosts"));
        URLUtils.isFileURL(new URL("file:////etc/hosts"));
        URLUtils.toFile(new URL("file:////etc/hosts"));
        URLUtils.toFile(new URL("file:///etc/hosts"));
    }
}

