/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.gui;

import java.awt.Component;
import java.util.Collection;
import javax.swing.JOptionPane;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.catalog.CatalogLocator;
import org.gvsig.catalog.CatalogManager;
import org.gvsig.catalog.loaders.LayerLoader;
import org.gvsig.catalog.loaders.LayerLoaderException;
import org.gvsig.catalog.schemas.Resource;
import org.gvsig.catalog.ui.chooseresource.ChooseResourceDialogPanel;
import org.gvsig.i18n.Messages;
import org.gvsig.tools.exception.BaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChooseResourceDialog
extends ChooseResourceDialogPanel
implements IWindow {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ChooseResourceDialog.class);
    private static final CatalogManager catalogManager = CatalogLocator.getCatalogManager();

    public ChooseResourceDialog(Collection resources) {
        super(resources);
    }

    public WindowInfo getWindowInfo() {
        WindowInfo m_viewinfo = new WindowInfo(17);
        m_viewinfo.setWidth(600);
        m_viewinfo.setHeight(160);
        m_viewinfo.setTitle(this.getName());
        return m_viewinfo;
    }

    public Object getWindowProfile() {
        return WindowInfo.TOOL_PROFILE;
    }

    public void closeButtonActionPerformed() {
        this.closeJDialog();
    }

    public void closeJDialog() {
        this.setVisible(false);
    }

    public void resourceButtonActionPerformed(Resource resource) {
        LayerLoader loader = null;
        try {
            loader = catalogManager.getLayerLoader(resource);
            if (loader == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), Messages.getText((String)"pluginNotFound"), Messages.getText((String)"pluginNotFoundTitle"), 1);
                return;
            }
            loader.loadLayer();
        }
        catch (LayerLoaderException e) {
            LOGGER.warn("Can't load resource", (Throwable)e);
            JOptionPane.showMessageDialog((Component)((Object)this), BaseException.getMessageStack((Throwable)e, (int)0), e.getWindowMessage(), 0);
        }
        catch (Exception e) {
            LOGGER.warn("Can't loadd resource", (Throwable)e);
            JOptionPane.showMessageDialog((Component)((Object)this), BaseException.getMessageStack((Throwable)e, (int)0), "Can't load resource", 0);
        }
        this.closeJDialog();
    }
}

