/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.loaders;

import java.util.HashMap;
import java.util.Map;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.catalog.loaders.GvSigLayerLoader;
import org.gvsig.catalog.schemas.Resource;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.i18n.Messages;

public class ARCIMSLayerLoader
extends GvSigLayerLoader {
    public ARCIMSLayerLoader(Resource resource) {
        super(resource);
    }

    @Override
    protected boolean hasSpecificLayer() {
        return false;
    }

    @Override
    protected String getLayerName() {
        return this.getResource().getName();
    }

    @Override
    protected DataStoreParameters createDataStoreParameters() throws InitializeException, ProviderNotRegisteredException {
        return null;
    }

    protected Map createArgs() {
        String host = this.getResource().getLinkage();
        String sLayer = this.getResource().getName();
        String protocol = this.getResource().getProtocol();
        ApplicationManager application = ApplicationLocator.getApplicationManager();
        AbstractViewPanel activeView = (AbstractViewPanel)application.getActiveWindow(ViewDocument.class);
        String srs = activeView.getProjection().getAbrev();
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("host", host);
        args.put("service_name", sLayer);
        args.put("layer_name", sLayer);
        args.put("srs", srs);
        return args;
    }

    @Override
    protected String extensionPointName() {
        String protocol = this.getResource().getProtocol();
        if (protocol.toUpperCase().indexOf("ESRI:AIMS--HTTP-GET-IMAGE") >= 0) {
            return "arcims_raster";
        }
        if (protocol.toUpperCase().indexOf("ESRI:AIMS--HTTP-GET-FEATURE") >= 0) {
            return "arcims_vectorial";
        }
        return null;
    }

    protected String getErrorMessage() {
        return Messages.getText((String)"arcims_server_error") + ".\n" + Messages.getText((String)"server") + ": " + this.getResource().getLinkage() + "\n" + Messages.getText((String)"layer") + ": " + this.getResource().getName();
    }

    protected String getWindowMessage() {
        return Messages.getText((String)"arcims_load");
    }
}

