/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.loaders;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.gvsig.app.gui.WizardPanel;
import org.gvsig.app.gui.wizards.WizardListenerSupport;
import org.gvsig.catalog.gui.LoaderWizardPanel;
import org.gvsig.catalog.loaders.GvSigLayerLoader;
import org.gvsig.catalog.schemas.Resource;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.exception.ConnectException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.wcs.app.wcsclient.gui.panel.WCSParamsPanel;
import org.gvsig.raster.wcs.io.WCSLayerNode;
import org.gvsig.raster.wcs.io.WCSProvider;
import org.gvsig.raster.wcs.io.WCSServerExplorer;
import org.gvsig.raster.wcs.io.WCSServerExplorerParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WCSLayerLoader
extends GvSigLayerLoader {
    private Logger logger = LoggerFactory.getLogger(WCSLayerLoader.class);
    private WCSServerExplorer explorer;
    private WCSParamsPanel wcsParamsPanel;
    public static final String FIELD_FORMAT = "format";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_SRSSTR = "srsstr";
    public static final String FIELD_URI = "uri";
    public static final String FIELD_ONLINERESOURC = "onlineresources";
    public static final String FIELD_WIDTH = "width";
    public static final String FIELD_HEIGHT = "height";
    public static final String FIELD_PARAM = "parameter";

    public WCSLayerLoader(Resource resource) {
        super(resource);
    }

    @Override
    protected boolean hasSpecificLayer() {
        return true;
    }

    @Override
    protected String getLayerName() {
        return this.getResource().getName();
    }

    @Override
    protected DataStoreParameters createDataStoreParameters() throws InitializeException, ProviderNotRegisteredException {
        DataStoreParameters dataStoreParameters = DATA_MANAGER.createStoreParameters("Wcs Store");
        if (this.getResource() != null) {
            dataStoreParameters.setDynValue(FIELD_NAME, (Object)this.getLayerName());
            dataStoreParameters.setDynValue(FIELD_ONLINERESOURC, (Object)this.createOnlineResources());
        }
        if (this.parseQuery(dataStoreParameters, this.getResource().getLinkage())) {
            return dataStoreParameters;
        }
        return null;
    }

    protected Map createOnlineResources() {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("GepCoverage", this.getResource().getLinkage());
        return args;
    }

    @Override
    protected String extensionPointName() {
        return "OGC:WCS";
    }

    private boolean parseQuery(DataStoreParameters dataStoreParameters, String link) {
        String host = null;
        String queryString = null;
        int index = link.indexOf("?");
        if (index > 0) {
            host = link.substring(0, index);
            queryString = link.substring(index + 1);
        } else {
            host = link;
            queryString = "";
        }
        if (link.indexOf(63) > -1) {
            queryString = link.substring(link.indexOf(63) + 1);
            dataStoreParameters.setDynValue(FIELD_URI, (Object)link.substring(0, link.indexOf(63)));
            String[] params = queryString.split("&");
            for (int i = 0; i < params.length; ++i) {
                String[] nameValue;
                if (params[i] == null || (nameValue = params[i].split("=")).length != 2) continue;
                String param = nameValue[0].toUpperCase();
                if (param.equals("CRS")) {
                    dataStoreParameters.setDynValue(FIELD_SRSSTR, (Object)nameValue[1]);
                    continue;
                }
                if (param.equals("FORMAT")) {
                    dataStoreParameters.setDynValue(FIELD_FORMAT, (Object)nameValue[1]);
                    continue;
                }
                if (param.equals("WIDTH")) {
                    dataStoreParameters.setDynValue(FIELD_WIDTH, (Object)nameValue[1]);
                    continue;
                }
                if (param.equals("HEIGHT")) {
                    dataStoreParameters.setDynValue(FIELD_HEIGHT, (Object)nameValue[1]);
                    continue;
                }
                if (!param.equals("BANDS")) continue;
                dataStoreParameters.setDynValue(FIELD_PARAM, (Object)nameValue[1]);
            }
        } else {
            dataStoreParameters.setDynValue(FIELD_URI, (Object)link);
            try {
                WCSServerExplorerParameters explorerParams = (WCSServerExplorerParameters)DATA_MANAGER.createServerExplorerParameters(WCSProvider.NAME);
                explorerParams.setHost(host);
                this.explorer = (WCSServerExplorer)DATA_MANAGER.createServerExplorer((DataServerExplorerParameters)explorerParams);
                this.explorer.connect(null);
                this.deleteRepitedValues();
                if (!this.getParams(dataStoreParameters, link)) {
                    return false;
                }
            }
            catch (ValidateDataParametersException e) {
                e.printStackTrace();
                return false;
            }
            catch (InitializeException e) {
                e.printStackTrace();
                return false;
            }
            catch (ProviderNotRegisteredException e) {
                e.printStackTrace();
                return false;
            }
            catch (ConnectException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private void deleteRepitedValues() {
        for (int i = 0; i < this.explorer.getCoverageList().length; ++i) {
            WCSLayerNode layer = this.explorer.getCoverageList()[i];
            this.deleteDuplicatedStringsFromList(layer.getFormats());
            this.deleteDuplicatedStringsFromList(layer.getInterpolationMethods());
            this.deleteDuplicatedStringsFromList(layer.getSRSs());
        }
    }

    private void deleteDuplicatedStringsFromList(List list) {
        HashSet hs = new HashSet();
        hs.addAll(list);
        list.clear();
        list.addAll(hs);
    }

    private boolean getParams(DataStoreParameters dataStoreParameters, String link) {
        try {
            this.wcsParamsPanel = new WCSParamsPanel();
            this.wcsParamsPanel.setListenerSupport(new WizardListenerSupport());
            this.wcsParamsPanel.setWizardData(this.explorer);
            LoaderWizardPanel panel = new LoaderWizardPanel((WizardPanel)this.wcsParamsPanel, dataStoreParameters);
            return panel.showWizardOnDialog();
        }
        catch (NoClassDefFoundError e1) {
            this.logger.info("No est\u00e1 instalada la extensi\u00f3n de raster");
            return false;
        }
    }

    protected String getErrorMessage() {
        return Messages.getText((String)"wcsError") + ".\n" + Messages.getText((String)"link") + ": " + this.getResource().getLinkage();
    }

    protected String getWindowMessage() {
        return Messages.getText((String)"wcsLoad");
    }
}

