/*
 * Decompiled with CFR 0.152.
 */
package javax.units;

import java.io.Serializable;
import javax.units.ConversionException;

public abstract class Converter
implements Serializable {
    public static final Converter IDENTITY = new Identity();

    protected Converter() {
    }

    public abstract Converter inverse();

    public abstract double convert(double var1) throws ConversionException;

    public abstract double derivative(double var1);

    public abstract boolean isLinear();

    public boolean equals(Object obj) {
        if (obj instanceof Converter) {
            Converter that = (Converter)obj;
            return this.isLinear() && that.isLinear() && Float.floatToIntBits((float)this.derivative(0.0)) == Float.floatToIntBits((float)that.derivative(0.0));
        }
        return false;
    }

    public int hashCode() {
        return Float.floatToIntBits((float)this.derivative(0.0));
    }

    public Converter concatenate(Converter converter) {
        if (converter == IDENTITY) {
            return this;
        }
        return new Compound(converter, this);
    }

    private static final class Compound
    extends Converter {
        private final Converter _first;
        private final Converter _second;

        private Compound(Converter first, Converter second) {
            this._first = first;
            this._second = second;
        }

        public Converter inverse() {
            return new Compound(this._second.inverse(), this._first.inverse());
        }

        public double convert(double x) {
            return this._second.convert(this._first.convert(x));
        }

        public double derivative(double x) {
            return this._first.derivative(x) * this._second.derivative(this._first.convert(x));
        }

        public boolean isLinear() {
            return this._first.isLinear() && this._second.isLinear();
        }

        public boolean equals(Object obj) {
            return super.equals(obj) || obj instanceof Compound && ((Compound)obj)._first.equals(this._first) && ((Compound)obj)._second.equals(this._second);
        }
    }

    private static final class Identity
    extends Converter {
        private Identity() {
        }

        public Converter inverse() {
            return this;
        }

        public double convert(double x) {
            return x;
        }

        public double derivative(double x) {
            return 1.0;
        }

        public boolean isLinear() {
            return true;
        }

        public Converter concatenate(Converter converter) {
            return converter;
        }
    }
}

