/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.buffer;

import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.store.DataServerWriter;

public class DefaultDataServerWriter
implements DataServerWriter {
    private Buffer buffer = null;
    private int row = 0;
    private int block = 0;
    private double percent = 0.0;
    private double increment = 0.0;
    private int nBand = 0;

    public DefaultDataServerWriter() {
    }

    public DefaultDataServerWriter(Buffer buffer) {
        this.setBuffer(buffer, -1);
    }

    public void setBuffer(Buffer buffer, int nband) {
        this.buffer = buffer;
        this.nBand = nband;
        this.row = 0;
        this.block = 0;
        this.percent = 0.0;
        this.increment = 0.0;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public void setBand(int nband) {
        this.nBand = nband;
    }

    public int[] readARGBData(int sizeX, int sizeY, int nBand) {
        return null;
    }

    private void initRead(int sizeY) {
        if (this.row == 0) {
            this.block = sizeY;
            this.increment = 100.0 / ((double)this.buffer.getHeight() / (double)sizeY);
        }
    }

    public byte[][] readByteData(int sizeX, int sizeY) {
        this.initRead(sizeY);
        this.percent += this.increment;
        int len = this.buffer.getWidth() * sizeY;
        int nbands = this.nBand < 0 ? this.buffer.getBandCount() : 1;
        byte[][] b = new byte[nbands][len];
        if (this.nBand < 0) {
            for (int iBand = 0; iBand < nbands; ++iBand) {
                for (int j = this.row; j < this.row + sizeY; ++j) {
                    for (int i = 0; i < this.buffer.getWidth(); ++i) {
                        b[iBand][j % this.block * this.buffer.getWidth() + i] = this.buffer.getElemByte(j, i, iBand);
                    }
                }
            }
        } else {
            for (int j = this.row; j < this.row + sizeY; ++j) {
                for (int i = 0; i < this.buffer.getWidth(); ++i) {
                    b[0][j % this.block * this.buffer.getWidth() + i] = this.buffer.getElemByte(j, i, this.nBand);
                }
            }
        }
        this.row += sizeY;
        return b;
    }

    public short[][] readShortData(int sizeX, int sizeY) {
        this.initRead(sizeY);
        this.percent += this.increment;
        int len = this.buffer.getWidth() * sizeY;
        int nbands = this.nBand < 0 ? this.buffer.getBandCount() : 1;
        short[][] b = new short[nbands][len];
        if (this.nBand < 0) {
            for (int iBand = 0; iBand < nbands; ++iBand) {
                for (int j = this.row; j < this.row + sizeY; ++j) {
                    for (int i = 0; i < this.buffer.getWidth(); ++i) {
                        b[iBand][j % this.block * this.buffer.getWidth() + i] = this.buffer.getElemShort(j, i, iBand);
                    }
                }
            }
        } else {
            for (int j = this.row; j < this.row + sizeY; ++j) {
                for (int i = 0; i < this.buffer.getWidth(); ++i) {
                    b[0][j % this.block * this.buffer.getWidth() + i] = this.buffer.getElemShort(j, i, this.nBand);
                }
            }
        }
        this.row += sizeY;
        return b;
    }

    public int[][] readIntData(int sizeX, int sizeY) {
        this.initRead(sizeY);
        this.percent += this.increment;
        int len = this.buffer.getWidth() * sizeY;
        int nbands = this.nBand < 0 ? this.buffer.getBandCount() : 1;
        int[][] b = new int[nbands][len];
        if (this.nBand < 0) {
            for (int iBand = 0; iBand < this.buffer.getBandCount(); ++iBand) {
                for (int j = this.row; j < this.row + sizeY; ++j) {
                    for (int i = 0; i < this.buffer.getWidth(); ++i) {
                        b[iBand][j % this.block * this.buffer.getWidth() + i] = this.buffer.getElemInt(j, i, iBand);
                    }
                }
            }
        } else {
            for (int j = this.row; j < this.row + sizeY; ++j) {
                for (int i = 0; i < this.buffer.getWidth(); ++i) {
                    b[0][j % this.block * this.buffer.getWidth() + i] = this.buffer.getElemInt(j, i, this.nBand);
                }
            }
        }
        this.row += sizeY;
        return b;
    }

    public float[][] readFloatData(int sizeX, int sizeY) {
        this.initRead(sizeY);
        this.percent += this.increment;
        int len = this.buffer.getWidth() * sizeY;
        int nbands = this.nBand < 0 ? this.buffer.getBandCount() : 1;
        float[][] b = new float[nbands][len];
        if (this.nBand < 0) {
            for (int iBand = 0; iBand < this.buffer.getBandCount(); ++iBand) {
                for (int j = this.row; j < this.row + sizeY; ++j) {
                    for (int i = 0; i < this.buffer.getWidth(); ++i) {
                        b[iBand][j % this.block * this.buffer.getWidth() + i] = this.buffer.getElemFloat(j, i, iBand);
                    }
                }
            }
        } else {
            for (int j = this.row; j < this.row + sizeY; ++j) {
                for (int i = 0; i < this.buffer.getWidth(); ++i) {
                    b[0][j % this.block * this.buffer.getWidth() + i] = this.buffer.getElemFloat(j, i, this.nBand);
                }
            }
        }
        this.row += sizeY;
        return b;
    }

    public double[][] readDoubleData(int sizeX, int sizeY) {
        this.initRead(sizeY);
        this.percent += this.increment;
        int len = this.buffer.getWidth() * sizeY;
        int nbands = this.nBand < 0 ? this.buffer.getBandCount() : 1;
        double[][] b = new double[nbands][len];
        if (this.nBand < 0) {
            for (int iBand = 0; iBand < this.buffer.getBandCount(); ++iBand) {
                for (int j = this.row; j < this.row + sizeY; ++j) {
                    for (int i = 0; i < this.buffer.getWidth(); ++i) {
                        b[iBand][j % this.block * this.buffer.getWidth() + i] = this.buffer.getElemDouble(j, i, iBand);
                    }
                }
            }
        } else {
            for (int j = this.row; j < this.row + sizeY; ++j) {
                for (int i = 0; i < this.buffer.getWidth(); ++i) {
                    b[0][j % this.block * this.buffer.getWidth() + i] = this.buffer.getElemDouble(j, i, this.nBand);
                }
            }
        }
        this.row += sizeY;
        return b;
    }

    public int getPercent() {
        return Math.min((int)this.percent, 100);
    }

    public Buffer getSource() {
        return this.buffer;
    }

    public void dispose() {
        if (this.buffer != null) {
            this.buffer.dispose();
        }
    }

    public void setPercent(int value) {
    }
}

