/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.buffer.cache;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.raster.impl.buffer.cache.CacheDataFromDriverServer;
import org.gvsig.raster.impl.buffer.cache.CacheDataServer;
import org.gvsig.raster.impl.buffer.cache.ICacheDataSource;
import org.gvsig.raster.impl.provider.RasterProvider;

public class HddPage {
    private ICacheDataSource[] dataSource = null;

    public HddPage(int nPag, RasterProvider provider, Extent extent) throws FileNotFoundException, NotSupportedExtensionException, RasterDriverException {
        this.dataSource = new CacheDataFromDriverServer[1];
        this.dataSource[0] = new CacheDataFromDriverServer(provider, nPag, extent);
    }

    public void deletePage(int nBands) throws IOException {
        for (int i = 0; i < nBands; ++i) {
            this.deleteBand(i);
        }
    }

    public HddPage(int nPag, int nBands) {
        this.dataSource = new CacheDataServer[nBands];
        for (int iBand = 0; iBand < nBands; ++iBand) {
            this.dataSource[iBand] = new CacheDataServer(Long.toString(System.currentTimeMillis()), iBand, nPag);
        }
    }

    public ICacheDataSource getDataServer(int nBand) {
        if (nBand >= 0 && nBand < this.dataSource.length) {
            return this.dataSource[nBand];
        }
        return null;
    }

    public void deleteBand(int nBand) throws IOException {
        if (nBand >= 0 && nBand < this.dataSource.length) {
            this.dataSource[nBand].delete();
        }
    }

    public void assignBand(int nBand, ICacheDataSource cacheDataSource) {
        if (nBand >= 0 && nBand < this.dataSource.length) {
            this.dataSource[nBand] = cacheDataSource;
        }
    }

    public ICacheDataSource getBandDataSource(int nBand) {
        return this.dataSource[nBand];
    }
}

