/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.buffer.cache;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.Band;
import org.gvsig.fmap.dal.coverage.datastruct.BandList;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.exception.FileNotExistsException;
import org.gvsig.fmap.dal.coverage.exception.InvalidSetViewException;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.QueryException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.RasterQuery;
import org.gvsig.raster.impl.DefaultRasterManager;
import org.gvsig.raster.impl.buffer.RasterBuffer;
import org.gvsig.raster.impl.datastruct.ExtentImpl;
import org.gvsig.raster.impl.provider.AbstractRasterProvider;
import org.gvsig.raster.impl.store.QueryableRaster;

public class RasterReadOnlyBuffer
extends RasterBuffer {
    private Buffer page = null;
    private Buffer secondPage = null;
    private int loadedPage = -1;
    private int loadedSecondPage = -1;
    private int heightLastPage = 0;
    private RasterDataStore datasource = null;
    private int bitsPag = 0;
    private int nPages = 0;
    private BandList bandList = null;
    private int[] drawableBands = null;
    private int minX = 0;
    private int minY = 0;
    private int maxX = 0;
    private int maxY = 0;
    private RasterQuery query = null;
    private int offset = 1;
    private int bufWidth;
    private int bufHeight;
    private int blockHeight = RasterLibrary.blockHeight;

    public RasterReadOnlyBuffer(int dataType, int width, int height, int nBand) {
        this.dataType = dataType;
        this.width = width;
        this.height = height;
        this.nBands = nBand;
    }

    public void setBufferParams(QueryableRaster q, Extent ext, BandList bandList) throws InvalidSetViewException, FileNotExistsException, NotSupportedExtensionException {
        this.bandList = bandList;
        this.datasource = (RasterDataStore)q;
        if (ext.minX() < this.datasource.getExtent().minX() || ext.minY() < this.datasource.getExtent().minY() || ext.maxX() > this.datasource.getExtent().maxX() || ext.maxY() > this.datasource.getExtent().maxY()) {
            throw new InvalidSetViewException("");
        }
        Point2D p1 = this.datasource.worldToRaster((Point2D)new Point2D.Double(this.minX, this.maxY));
        Point2D p2 = this.datasource.worldToRaster((Point2D)new Point2D.Double(this.maxX, this.minY));
        this.adjustPoints(p1, p2);
        this.minX = (int)p1.getX();
        this.minY = (int)p1.getY();
        this.maxX = (int)p2.getX();
        this.maxY = (int)p2.getY();
        this.init();
    }

    private void adjustPoints(Point2D ul, Point2D lr) {
        double a = ul.getX() - (double)((int)ul.getX());
        double b = ul.getY() - (double)((int)ul.getY());
        ul.setLocation(a > 0.99 || a < 0.005 ? (double)Math.round(ul.getX()) : ul.getX(), b > 0.99 || b < 0.005 ? (double)Math.round(ul.getY()) : ul.getY());
        lr.setLocation(a > 0.99 || a < 0.005 ? (double)Math.round(lr.getX()) : lr.getX(), b > 0.99 || b < 0.005 ? (double)Math.round(lr.getY()) : lr.getY());
    }

    public void setBufferParams(QueryableRaster q, int minX, int minY, int maxX, int maxY, BandList bandList) throws InvalidSetViewException, FileNotExistsException, NotSupportedExtensionException {
        this.bandList = bandList;
        this.datasource = (RasterDataStore)q;
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
        if (Math.abs(maxX - minX) != this.width || Math.abs(maxY - minY) != this.height) {
            this.bufWidth = this.width;
            this.bufHeight = this.height;
        }
        this.init();
    }

    private void init() {
        int h = this.blockHeight;
        while (h > 1) {
            h >>= 1;
            ++this.bitsPag;
        }
        this.offset = this.blockHeight - 1;
        this.query = DefaultRasterManager.getInstance().createQuery();
        this.query.setMemoryBuffer(true);
        this.query.setDrawableBands(this.bandList.getDrawableBands());
        this.nPages = (int)Math.ceil((double)this.height / (double)this.blockHeight);
        if (this.height % this.blockHeight == 0) {
            this.heightLastPage = this.blockHeight;
        } else {
            double aux = (double)this.height / (double)this.blockHeight;
            this.heightLastPage = (int)((aux - (double)((int)aux)) * (double)this.blockHeight);
        }
        this.drawableBands = new int[this.datasource.getBandCount()];
        for (int i = 0; i < this.drawableBands.length; ++i) {
            this.drawableBands[i] = i;
        }
    }

    @Override
    public void addDrawableBands(int[] db) {
        if (db == null || db.length > this.bandList.getBandCount()) {
            return;
        }
        this.bandList.setDrawableBands(db);
        this.query = DefaultRasterManager.getInstance().createQuery();
        this.query.setMemoryBuffer(true);
        this.query.setDrawableBands(this.bandList.getDrawableBands());
    }

    @Override
    public int getBandCount() {
        return this.bandList.getDrawableBandsCount();
    }

    public Extent[] calcExtentPages(AbstractRasterProvider dataset, int nPages) {
        Extent datasetExtent = dataset.getExtent();
        double h = (double)this.blockHeight * dataset.getExtent().height() / dataset.getHeight();
        Extent[] ext = new Extent[nPages];
        double minX = datasetExtent.getMin().getX();
        double maxX = datasetExtent.getMax().getX();
        double maxY = datasetExtent.getMax().getY();
        double minY = maxY - h;
        for (int i = 0; i < ext.length; ++i) {
            ext[i] = new ExtentImpl(minX, maxY, maxX, minY);
            maxY = minY;
            if (!((minY -= h) < datasetExtent.minY())) continue;
            minY = datasetExtent.minY();
        }
        return ext;
    }

    @Override
    public void malloc(int dataType, int width, int height, int bandNr) {
    }

    public boolean isBandSwitchable() {
        return false;
    }

    private Buffer queryPage(int pag) throws ProcessInterruptedException, QueryException {
        int w = this.maxX - this.minX + 1;
        int h = this.maxY - this.minY + 1;
        if ((double)(this.minX + w) > this.datasource.getWidth()) {
            w = (int)(this.datasource.getWidth() - (double)this.minX);
        }
        if (this.bufWidth == 0 && this.bufHeight == 0) {
            if (pag == this.nPages - 1) {
                Rectangle r = new Rectangle(this.minX, this.blockHeight * pag + this.minY, w, this.heightLastPage);
                this.query.setAreaOfInterest(r);
            } else {
                Rectangle r = new Rectangle(this.minX, this.blockHeight * pag + this.minY, w, this.blockHeight);
                this.query.setAreaOfInterest(r);
            }
        } else {
            int hPage = (int)Math.round((double)(this.blockHeight * h) / (double)this.bufHeight);
            if (pag == this.nPages - 1) {
                int hLastPage = 0;
                if (this.heightLastPage == this.bufHeight) {
                    hLastPage = h;
                    hPage = 0;
                } else {
                    hLastPage = (int)Math.round((double)(this.heightLastPage * h) / (double)this.bufHeight);
                }
                int newMiY = hPage * pag + this.minY;
                if ((double)(newMiY + hLastPage) > this.datasource.getHeight()) {
                    hLastPage = (int)(this.datasource.getHeight() - (double)newMiY);
                }
                Rectangle r = new Rectangle(this.minX, newMiY, w, hLastPage);
                this.query.setAreaOfInterest(r, this.bufWidth, this.heightLastPage);
            } else {
                Rectangle r = new Rectangle(this.minX, hPage * pag + this.minY, w, hPage);
                this.query.setAreaOfInterest(r, this.bufWidth, this.blockHeight);
            }
        }
        return this.datasource.query(this.query);
    }

    private void loadPage(int pag) {
        try {
            if (this.page == null) {
                this.page = this.queryPage(pag);
                this.loadedPage = pag;
                if (pag + 1 < this.nPages) {
                    this.secondPage = this.queryPage(pag + 1);
                    this.loadedSecondPage = pag + 1;
                }
            } else if (pag == this.loadedSecondPage) {
                this.switchPage();
            } else {
                this.switchPage();
                this.page = this.queryPage(pag);
                this.loadedPage = pag;
            }
        }
        catch (ProcessInterruptedException processInterruptedException) {
        }
        catch (QueryException queryException) {
        }
        finally {
            if (this.page == null) {
                this.page = DefaultRasterManager.getInstance().createBuffer(this.dataType, this.width, this.height, this.nBands, true);
                this.loadedPage = pag;
            }
        }
    }

    private void switchPage() {
        Buffer aux = this.secondPage;
        this.secondPage = this.page;
        this.page = aux;
        int auxint = this.loadedSecondPage;
        this.loadedSecondPage = this.loadedPage;
        this.loadedPage = auxint;
    }

    public byte[][] getLineByte(int line) {
        int pag = line >> this.bitsPag;
        if (pag != this.loadedPage) {
            this.loadPage(pag);
        }
        return this.page.getLineByte(line & this.offset);
    }

    public short[][] getLineShort(int line) {
        int pag = line >> this.bitsPag;
        if (pag != this.loadedPage) {
            this.loadPage(pag);
        }
        return this.page.getLineShort(line & this.offset);
    }

    public int[][] getLineInt(int line) {
        int pag = line >> this.bitsPag;
        if (pag != this.loadedPage) {
            this.loadPage(pag);
        }
        return this.page.getLineInt(line & this.offset);
    }

    public float[][] getLineFloat(int line) {
        int pag = line >> this.bitsPag;
        if (pag != this.loadedPage) {
            this.loadPage(pag);
        }
        return this.page.getLineFloat(line & this.offset);
    }

    public double[][] getLineDouble(int line) {
        int pag = line >> this.bitsPag;
        if (pag != this.loadedPage) {
            this.loadPage(pag);
        }
        return this.page.getLineDouble(line & this.offset);
    }

    public byte[] getLineFromBandByte(int line, int band) {
        int pag = line >> this.bitsPag;
        if (pag != this.loadedPage) {
            this.loadPage(pag);
        }
        return this.page.getLineFromBandByte(line & this.offset, band);
    }

    public short[] getLineFromBandShort(int line, int band) {
        int pag = line >> this.bitsPag;
        if (pag != this.loadedPage) {
            this.loadPage(pag);
        }
        return this.page.getLineFromBandShort(line & this.offset, band);
    }

    public int[] getLineFromBandInt(int line, int band) {
        int pag = line >> this.bitsPag;
        if (pag != this.loadedPage) {
            this.loadPage(pag);
        }
        return this.page.getLineFromBandInt(line & this.offset, band);
    }

    public float[] getLineFromBandFloat(int line, int band) {
        int pag = line >> this.bitsPag;
        if (pag != this.loadedPage) {
            this.loadPage(pag);
        }
        return this.page.getLineFromBandFloat(line & this.offset, band);
    }

    public double[] getLineFromBandDouble(int line, int band) {
        int pag = line >> this.bitsPag;
        if (pag != this.loadedPage) {
            this.loadPage(pag);
        }
        return this.page.getLineFromBandDouble(line & this.offset, band);
    }

    public byte getElemByte(int line, int col, int band) {
        int pag = line >> this.bitsPag;
        if (pag != this.loadedPage) {
            this.loadPage(pag);
        }
        return this.page.getElemByte(line & this.offset, col, band);
    }

    public short getElemShort(int line, int col, int band) {
        int pag = line >> this.bitsPag;
        if (pag != this.loadedPage) {
            this.loadPage(pag);
        }
        return this.page.getElemShort(line & this.offset, col, band);
    }

    public int getElemInt(int line, int col, int band) {
        int pag = line >> this.bitsPag;
        if (pag != this.loadedPage) {
            this.loadPage(pag);
        }
        return this.page.getElemInt(line & this.offset, col, band);
    }

    public float getElemFloat(int line, int col, int band) {
        int pag = line >> this.bitsPag;
        if (pag != this.loadedPage) {
            this.loadPage(pag);
        }
        return this.page.getElemFloat(line & this.offset, col, band);
    }

    public double getElemDouble(int line, int col, int band) {
        int pag = line >> this.bitsPag;
        if (pag != this.loadedPage) {
            this.loadPage(pag);
        }
        return this.page.getElemDouble(line & this.offset, col, band);
    }

    public void getElemByte(int line, int col, byte[] data) {
        int pag = line >> this.bitsPag;
        if (pag != this.loadedPage) {
            this.loadPage(pag);
        }
        this.page.getElemByte(line & this.offset, col, data);
    }

    public void getElemShort(int line, int col, short[] data) {
        int pag = line >> this.bitsPag;
        if (pag != this.loadedPage) {
            this.loadPage(pag);
        }
        this.page.getElemShort(line & this.offset, col, data);
    }

    public void getElemInt(int line, int col, int[] data) {
        int pag = line >> this.bitsPag;
        if (pag != this.loadedPage) {
            this.loadPage(pag);
        }
        this.page.getElemInt(line & this.offset, col, data);
    }

    public void getElemFloat(int line, int col, float[] data) {
        int pag = line >> this.bitsPag;
        if (pag != this.loadedPage) {
            this.loadPage(pag);
        }
        this.page.getElemFloat(line & this.offset, col, data);
    }

    public void getElemDouble(int line, int col, double[] data) {
        int pag = line >> this.bitsPag;
        if (pag != this.loadedPage) {
            this.loadPage(pag);
        }
        this.page.getElemDouble(line & this.offset, col, data);
    }

    public Band getBand(int band) {
        return null;
    }

    public Buffer getBandBuffer(int Band2) {
        return null;
    }

    @Override
    public void replicateBand(int orig, int dest) {
    }

    @Override
    public void switchBands(int[] bandPosition) {
    }

    @Override
    public Buffer cloneBuffer() {
        return null;
    }

    public void mallocOneBand(int dataType, int width, int height, int band) {
    }

    public void copyBand(int nBand, Band band) {
    }

    public void assignBand(int nBand, Band band) {
    }

    public Band createBand(byte defaultValue) {
        return null;
    }

    public void assignBandToNotValid(int Band2) {
    }

    public void assign(int band, byte value) {
    }

    public void assign(int band, short value) {
    }

    public void assign(int band, int value) {
    }

    public void assign(int band, float value) {
    }

    public void assign(int band, double value) {
    }

    public void interchangeBands(int band1, int band2) {
    }

    public void setElem(int line, int col, int band, byte data) {
    }

    public void setElem(int line, int col, int band, short data) {
    }

    public void setElem(int line, int col, int band, int data) {
    }

    public void setElem(int line, int col, int band, float data) {
    }

    public void setElem(int line, int col, int band, double data) {
    }

    public void setElemByte(int line, int col, byte[] data) {
    }

    public void setElemDouble(int line, int col, double[] data) {
    }

    public void setElemFloat(int line, int col, float[] data) {
    }

    public void setElemInt(int line, int col, int[] data) {
    }

    public void setElemShort(int line, int col, short[] data) {
    }

    public void setLineByte(byte[][] data, int line) {
    }

    public void setLineDouble(double[][] data, int line) {
    }

    public void setLineFloat(float[][] data, int line) {
    }

    public void setLineInBandByte(byte[] data, int line, int band) {
    }

    public void setLineInBandDouble(double[] data, int line, int band) {
    }

    public void setLineInBandFloat(float[] data, int line, int band) {
    }

    public void setLineInBandInt(int[] data, int line, int band) {
    }

    public void setLineInBandShort(short[] data, int line, int band) {
    }

    public void setLineInt(int[][] data, int line) {
    }

    public void setLineShort(short[][] data, int line) {
    }

    public boolean isReadOnlyBuffer() {
        return true;
    }

    @Override
    public boolean isCached() {
        return true;
    }

    @Override
    public int getBlockHeight() {
        return RasterLibrary.blockHeight;
    }

    public void dispose() {
        if (this.page != null) {
            this.page.dispose();
        }
        if (this.secondPage != null) {
            this.secondPage.dispose();
        }
        try {
            this.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    protected void finalize() throws Throwable {
        this.page = null;
        this.secondPage = null;
        this.query = null;
        this.drawableBands = null;
        this.bandList = null;
        this.datasource = null;
        super.finalize();
    }
}

