/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.datastruct;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.datastruct.BandList;
import org.gvsig.fmap.dal.coverage.datastruct.DatasetBand;
import org.gvsig.fmap.dal.coverage.exception.BandNotFoundInListException;
import org.gvsig.raster.impl.datastruct.DatasetBandImpl;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class BandListImpl
implements BandList,
Persistent {
    public static final String PERSISTENT_NAME = "BandListImpl_Persistent";
    public static final String PERSISTENT_DESCRIPTION = "BandListImpl Persistent";
    private ArrayList<DatasetBand> bands = new ArrayList();
    private int[] drawableBands = null;

    public BandListImpl() {
    }

    public BandListImpl(String fName, int bandCount, int dataType) {
        int[] drawBands = new int[bandCount];
        for (int i = 0; i < bandCount; ++i) {
            try {
                this.addBand(new DatasetBandImpl(fName, i, dataType, bandCount), i);
            }
            catch (BandNotFoundInListException bandNotFoundInListException) {
                // empty catch block
            }
            drawBands[i] = i;
        }
        this.setDrawableBands(drawBands);
    }

    public Object clone() {
        BandListImpl result = new BandListImpl();
        ArrayList<DatasetBand> b = new ArrayList<DatasetBand>();
        for (int i = 0; i < this.bands.size(); ++i) {
            b.add((DatasetBand)((DatasetBandImpl)this.bands.get(i)).clone());
        }
        result.setBandArray(b);
        if (this.drawableBands != null) {
            int[] drawBands = new int[this.drawableBands.length];
            for (int i = 0; i < this.drawableBands.length; ++i) {
                drawBands[i] = this.drawableBands[i];
            }
            result.setDrawableBands(drawBands);
        }
        return result;
    }

    public void setDrawableBands(int[] drawableBands) {
        this.clearDrawableBands();
        this.drawableBands = drawableBands;
        for (int i = 0; i < drawableBands.length; ++i) {
            if (drawableBands[i] < 0 || drawableBands[i] >= this.getBandCount()) continue;
            this.addDrawableBand(i, drawableBands[i]);
        }
    }

    public void setBandArray(ArrayList<DatasetBand> bands) {
        this.bands = bands;
    }

    public int[] getDrawableBands() {
        return this.drawableBands;
    }

    public boolean findBand(DatasetBand band) {
        for (int i = 0; i < this.bands.size(); ++i) {
            DatasetBand b = this.bands.get(i);
            if (!b.getFileName().equals(band.getFileName()) || b.getPosition() != band.getPosition()) continue;
            return true;
        }
        return false;
    }

    public int[] bandsToDrawList(int nBandsDataImage) {
        int[] bandsToRead = new int[nBandsDataImage];
        for (int dataImageBand = 0; dataImageBand < nBandsDataImage; ++dataImageBand) {
            bandsToRead[dataImageBand] = -1;
            for (int band = 0; band < this.bands.size(); ++band) {
                if (this.bands.get(band) == null || this.bands.get(band).getBufferBandListToDraw() == null) continue;
                for (int dest = 0; dest < this.bands.get(band).getBufferBandListToDraw().length; ++dest) {
                    if (dataImageBand != this.bands.get(band).getBufferBandListToDraw()[dest]) continue;
                    bandsToRead[dataImageBand] = band;
                }
            }
        }
        return bandsToRead;
    }

    public boolean isDrawingAnyBand() {
        for (int band = 0; band < this.bands.size(); ++band) {
            if (!this.bands.get(band).isDrawing()) continue;
            return true;
        }
        return false;
    }

    public void addBand(DatasetBand b, int pos) throws BandNotFoundInListException {
        this.bands.add(b);
    }

    public void addBand(DatasetBand b) throws BandNotFoundInListException {
        this.bands.add(b);
    }

    public void addBandList(BandList bl) {
        for (int i = 0; i < bl.getBandCount(); ++i) {
            if (this.findBand(bl.getBand(i))) continue;
            this.bands.add(bl.getBand(i));
        }
    }

    public void removeBands(String name) {
        for (int i = 0; i < this.getBandCount(); ++i) {
            DatasetBand band = this.getBand(i);
            if (!band.getFileName().equals(name)) continue;
            this.bands.remove(i);
        }
    }

    public void clearDrawableBands() {
        this.drawableBands = null;
        for (int i = 0; i < this.getBandCount(); ++i) {
            this.bands.get(i).clearDrawableBands();
        }
    }

    public void addDrawableBand(int posRasterBuf, int imageBand) {
        try {
            this.bands.get(imageBand).addPositionToDrawInBuffer(posRasterBuf);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public int getDrawableBandsCount() {
        int nbands = 0;
        for (int i = 0; i < this.bands.size(); ++i) {
            DatasetBand b = this.bands.get(i);
            if (b.getBufferBandListToDraw() == null) continue;
            nbands += b.getBufferBandListToDraw().length;
        }
        return nbands;
    }

    public DatasetBand getBand(int i) {
        if (i < 0 || i >= this.bands.size()) {
            return null;
        }
        return this.bands.get(i);
    }

    public int getBandCount() {
        return this.bands.size();
    }

    public int[] getBufferBandToDraw(String fileName, int band) {
        for (int i = 0; i < this.bands.size(); ++i) {
            if (!this.bands.get(i).getFileName().equals(fileName) || this.bands.get(i).getPosition() != band) continue;
            return this.bands.get(i).getBufferBandListToDraw();
        }
        int[] r = new int[]{-1};
        return r;
    }

    public int[] getLocalBufferBandToDraw(String fileName, int band) {
        for (int i = 0; i < this.bands.size(); ++i) {
            if (!this.bands.get(i).getFileName().equals(fileName) || this.bands.get(i).getPosition() != band) continue;
            return this.bands.get(i).getLocalBufferBandListToDraw();
        }
        int[] r = new int[]{-1};
        return r;
    }

    public String[] getBandStringList() {
        String[] list = new String[this.bands.size()];
        for (int i = 0; i < this.bands.size(); ++i) {
            list[i] = this.bands.get(i).getFileName();
        }
        return list;
    }

    public int[] getBandPositionList() {
        int[] list = new int[this.bands.size()];
        for (int i = 0; i < this.bands.size(); ++i) {
            list[i] = this.bands.get(i).getPosition();
        }
        return list;
    }

    public int getBandsDataType() {
        if (this.bands.size() <= 0) {
            return 32;
        }
        return this.bands.get(0).getDataType();
    }

    public int getFileNumber(String fileName) {
        if (fileName == null) {
            return -1;
        }
        String aux = "";
        int count = -1;
        for (int i = 0; i < this.bands.size(); ++i) {
            if (this.bands.get(i).getFileName().indexOf(aux) != 0) {
                ++count;
                aux = this.bands.get(i).getFileName();
            }
            if (this.bands.get(i).getFileName().indexOf(fileName) != 0) continue;
            return count;
        }
        return -1;
    }

    public void clear() {
        this.bands.clear();
        this.drawableBands = null;
    }

    public void show() {
        System.out.println("BandCount: " + this.getBandCount());
        System.out.println("DrawableBandsCount: " + this.getDrawableBandsCount());
        for (int i = 0; i < this.getBandCount(); ++i) {
            System.out.println("");
            System.out.println("***********************");
            System.out.println("Band: " + i);
            System.out.println("DataType: " + this.getBand(i).getDataType());
            System.out.println("FileName: " + this.getBand(i).getFileName());
            System.out.println("Position: " + this.getBand(i).getPosition());
            if (this.getBand(i).getBufferBandListToDraw() != null) {
                System.out.print("Band Dst: ");
                for (int j = 0; j < this.getBand(i).getBufferBandListToDraw().length; ++j) {
                    System.out.print(this.getBand(i).getBufferBandListToDraw()[j] + " ");
                }
            }
            System.out.println();
        }
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        List rois = state.getList("bands");
        this.bands = new ArrayList();
        this.bands.addAll(rois);
        this.drawableBands = state.getIntArray("drawableBands");
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("bands", this.bands);
        state.set("drawableBands", this.drawableBands);
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition(PERSISTENT_NAME);
        if (definition == null) {
            definition = manager.addDefinition(BandListImpl.class, PERSISTENT_NAME, PERSISTENT_DESCRIPTION, null, null);
            definition.addDynFieldList("bands").setClassOfItems(DatasetBand.class).setMandatory(true);
            definition.addDynFieldList("drawableBands").setClassOfItems(Integer.TYPE).setMandatory(false);
        }
    }
}

