/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.datastruct;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.dal.coverage.exception.RmfSerializerException;
import org.gvsig.raster.impl.datastruct.serializer.NoDataRmfSerializer;
import org.gvsig.raster.impl.store.rmf.RmfBlocksManager;

public class DefaultNoData
implements NoData {
    private List<Number> noDataByBand = new ArrayList<Number>();
    private List<Number> nativeNoDataByBand = new ArrayList<Number>();
    private int bandCount = 1;
    private String fileName = null;
    private boolean noDataAsTransparent = true;
    private int dataType = 32;
    private static final Logger log = Logger.getLogger(DefaultNoData.class.toString());

    public DefaultNoData() {
    }

    public DefaultNoData(String fileName) {
        this.fileName = fileName;
    }

    public DefaultNoData(Number noData, Number nativeNoData, String fileName) {
        this.setValue(noData);
        this.setNativeValue(nativeNoData);
        this.fileName = fileName;
        this.setDataType(noData);
    }

    private void setDataType(Number number) {
        if (number instanceof Byte) {
            this.dataType = 0;
        }
        if (number instanceof Short) {
            this.dataType = 2;
        }
        if (number instanceof Integer) {
            this.dataType = 3;
        }
        if (number instanceof Float) {
            this.dataType = 4;
        }
        if (number instanceof Double) {
            this.dataType = 5;
        }
    }

    public DefaultNoData(Number noData, Number nativeNoData, String fileName, int bandCount) {
        this.setValue(noData);
        this.setNativeValue(nativeNoData);
        this.fileName = fileName;
        this.setDataType(noData);
        if (bandCount > 1) {
            this.bandCount = bandCount;
        }
    }

    public Number getValue() {
        try {
            return this.noDataByBand.get(0);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public boolean isDefined() {
        return this.getValue() != null;
    }

    public void setValue(Number noData) {
        this.noDataByBand.clear();
        for (int i = 0; i < this.bandCount; ++i) {
            this.noDataByBand.add(noData);
        }
        this.setDataType(noData);
    }

    public Number getNativeValue() {
        try {
            return this.nativeNoDataByBand.get(0);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public void setNativeValue(Number nativeNoDataValue) {
        this.nativeNoDataByBand.clear();
        for (int i = 0; i < this.bandCount; ++i) {
            this.nativeNoDataByBand.add(nativeNoDataValue);
        }
        this.setDataType(nativeNoDataValue);
    }

    public void delete() {
        this.noDataByBand.clear();
        for (int i = 0; i < this.bandCount; ++i) {
            this.noDataByBand.add(null);
        }
    }

    public void restore() {
        if (this.nativeNoDataByBand != null && this.nativeNoDataByBand.size() == this.bandCount) {
            this.noDataByBand.clear();
            for (int i = 0; i < this.bandCount; ++i) {
                this.noDataByBand.add(this.nativeNoDataByBand.get(i));
            }
        }
    }

    public void save() {
        try {
            String fileRMF = RasterLocator.getManager().getFileUtils().getNameWithoutExtension(this.fileName) + ".rmf";
            RmfBlocksManager blocksManager = new RmfBlocksManager(fileRMF);
            NoDataRmfSerializer serializerObject = new NoDataRmfSerializer(this);
            if (!blocksManager.checkRmf()) {
                throw new RmfSerializerException("Error al comprobar el fichero Rmf");
            }
            blocksManager.addClient(serializerObject);
            try {
                blocksManager.write(true);
            }
            catch (IOException e) {
                throw new RmfSerializerException("Error al escribir el fichero Rmf", (Exception)e);
            }
            blocksManager.removeAllClients();
        }
        catch (RmfSerializerException e) {
            log.log(Level.SEVERE, "error_salvando_rmf", e);
        }
    }

    public void load() {
        String fileRMF = RasterLocator.getManager().getFileUtils().getNameWithoutExtension(this.fileName) + ".rmf";
        RmfBlocksManager blocksManager = new RmfBlocksManager(fileRMF);
        NoDataRmfSerializer serializerObject = new NoDataRmfSerializer(this);
        if (!blocksManager.checkRmf()) {
            log.info("Error al comprobar el fichero Rmf " + fileRMF);
        }
        blocksManager.addClient(serializerObject);
        try {
            if (new File(fileRMF).exists()) {
                blocksManager.read(null);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error al escribir el fichero Rmf", e);
        }
        blocksManager.removeAllClients();
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean isNoDataTransparent() {
        return this.noDataAsTransparent;
    }

    public void setNoDataTransparent(boolean noDataAsTransparent) {
        this.noDataAsTransparent = noDataAsTransparent;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int datatype) {
        this.dataType = datatype;
    }

    public boolean compare(NoData noData) {
        int i;
        String f = ((DefaultNoData)noData).fileName;
        if ((f == null || this.fileName == null) && f != this.fileName) {
            return false;
        }
        if (this.fileName != null && f != null && this.fileName.compareTo(f) != 0) {
            return false;
        }
        if (this.bandCount != ((DefaultNoData)noData).bandCount) {
            return false;
        }
        if (this.dataType != ((DefaultNoData)noData).dataType) {
            return false;
        }
        for (i = 0; i < this.noDataByBand.size(); ++i) {
            if (((Comparable)((Object)this.noDataByBand.get(i))).compareTo(noData.getValue()) == 0) continue;
            return false;
        }
        for (i = 0; i < this.nativeNoDataByBand.size(); ++i) {
            if (((Comparable)((Object)this.nativeNoDataByBand.get(i))).compareTo(noData.getValue()) == 0) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        DefaultNoData copy = new DefaultNoData(this.getValue(), this.getNativeValue(), this.fileName, this.bandCount);
        copy.noDataAsTransparent = this.noDataAsTransparent;
        return copy;
    }

    public Number getValueByBand(int nBand) {
        try {
            return this.noDataByBand.get(nBand);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public void setValueByBand(Number noDataValue, int nBand) {
        this.noDataByBand.add(nBand, noDataValue);
        this.setDataType(noDataValue);
    }

    public int getBandCount() {
        return this.bandCount;
    }

    public void setBandCount(int bandCount) {
        this.bandCount = bandCount;
    }
}

