/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.datastruct;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import org.cresques.cts.ICoordTrans;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.GridExtent;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.raster.impl.grid.GridExtentImpl;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.locator.LocatorException;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtentImpl
implements Extent {
    private static final Logger LOG = LoggerFactory.getLogger(ExtentImpl.class);
    public static final String PERSISTENT_NAME = "Extent_Persistent";
    public static final String PERSISTENT_DESCRIPTION = "Extent Persistent";
    Point2D min = null;
    Point2D max = null;
    Point2D ul = new Point2D.Double(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    Point2D lr = new Point2D.Double(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    Point2D ur = new Point2D.Double(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    Point2D ll = new Point2D.Double(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);

    public ExtentImpl() {
        this.min = new Point2D.Double(9.99999999E8, 9.99999999E8);
        this.max = new Point2D.Double(-9.99999999E8, -9.99999999E8);
    }

    public ExtentImpl(Point2D ul, Point2D lr) {
        this.ul = ul;
        this.lr = lr;
        this.newExtent(ul.getX(), ul.getY(), lr.getX(), lr.getY());
    }

    public ExtentImpl(Point2D ul, Point2D lr, Point2D ur, Point2D ll) {
        this.ul = ul;
        this.lr = lr;
        this.ur = ur;
        this.ll = ll;
        this.min = new Point2D.Double(Math.min(Math.min(ul.getX(), lr.getX()), Math.min(ur.getX(), ll.getX())), Math.min(Math.min(ul.getY(), lr.getY()), Math.min(ur.getY(), ll.getY())));
        this.max = new Point2D.Double(Math.max(Math.max(ul.getX(), lr.getX()), Math.max(ur.getX(), ll.getX())), Math.max(Math.max(ul.getY(), lr.getY()), Math.max(ur.getY(), ll.getY())));
    }

    public ExtentImpl(double x1, double y1, double x2, double y2) {
        this.ul.setLocation(x1, y1);
        this.lr.setLocation(x2, y2);
        this.newExtent(x1, y1, x2, y2);
    }

    public ExtentImpl(Rectangle2D r) {
        this.ul.setLocation(r.getX(), r.getY() + r.getHeight());
        this.lr.setLocation(r.getX() + r.getWidth(), r.getY());
        this.newExtent(r.getX(), r.getY(), r.getX() + r.getWidth(), r.getY() + r.getHeight());
    }

    public ExtentImpl(Extent ext) {
        this.ul.setLocation(ext.getULX(), ext.getULY());
        this.lr.setLocation(ext.getLRX(), ext.getLRY());
        this.ur.setLocation(ext.getURX(), ext.getURY());
        this.ll.setLocation(ext.getLLX(), ext.getLLY());
        this.min = new Point2D.Double(ext.minX(), ext.minY());
        this.max = new Point2D.Double(ext.maxX(), ext.maxY());
    }

    public Extent encloseBoundinBoxes(Extent ext) {
        Point2D.Double pUl = new Point2D.Double(Math.min(this.getULX(), ext.getULX()), Math.max(this.getULY(), ext.getULY()));
        Point2D.Double pLr = new Point2D.Double(Math.max(this.getLRX(), ext.getLRX()), Math.min(this.getLRY(), ext.getLRY()));
        return new ExtentImpl(pUl, pLr);
    }

    public Extent intersection(Extent ext) {
        if (this.intersects(ext)) {
            Point2D.Double pUl = new Point2D.Double(Math.max(this.getULX(), ext.getULX()), Math.min(this.getULY(), ext.getULY()));
            Point2D.Double pLr = new Point2D.Double(Math.min(this.getLRX(), ext.getLRX()), Math.max(this.getLRY(), ext.getLRY()));
            return new ExtentImpl(pUl, pLr);
        }
        return null;
    }

    public boolean intersects(Extent ext) {
        if (this.getMin().getX() > ext.getMax().getX()) {
            return false;
        }
        if (this.getMax().getX() < ext.getMin().getX()) {
            return false;
        }
        if (this.getMin().getY() > ext.getMax().getY()) {
            return false;
        }
        return !(this.getMax().getY() < ext.getMin().getY());
    }

    public GridExtent getGridExtent(double cellSize) {
        return new GridExtentImpl(this, cellSize);
    }

    public Extent clone() {
        ExtentImpl e = new ExtentImpl();
        e.min = this.min != null ? (Point2D)this.min.clone() : null;
        e.max = this.max != null ? (Point2D)this.max.clone() : null;
        e.ul = this.ul != null ? (Point2D)this.ul.clone() : null;
        e.lr = this.lr != null ? (Point2D)this.lr.clone() : null;
        e.ur = this.ur != null ? (Point2D)this.ur.clone() : null;
        e.ll = this.ll != null ? (Point2D)this.ll.clone() : null;
        return e;
    }

    private void newExtent(double x1, double y1, double x2, double y2) {
        this.min = new Point2D.Double(Math.min(x1, x2), Math.min(y1, y2));
        this.max = new Point2D.Double(Math.max(x1, x2), Math.max(y1, y2));
    }

    public double minX() {
        return this.min.getX();
    }

    public double minY() {
        return this.min.getY();
    }

    public double maxX() {
        return this.max.getX();
    }

    public double maxY() {
        return this.max.getY();
    }

    public Point2D getMin() {
        return this.min;
    }

    public Point2D getMax() {
        return this.max;
    }

    public boolean isAt(Point2D pt) {
        if (pt.getX() < this.minX()) {
            return false;
        }
        if (pt.getX() > this.maxX()) {
            return false;
        }
        if (pt.getY() < this.minY()) {
            return false;
        }
        return !(pt.getY() > this.maxY());
    }

    public double width() {
        return Math.abs(this.maxX() - this.minX());
    }

    public double height() {
        return Math.abs(this.maxY() - this.minY());
    }

    public double getCenterX() {
        return this.minX() + this.width() / 2.0;
    }

    public double getCenterY() {
        return this.minY() + this.height() / 2.0;
    }

    public void add(Point2D pt) {
        if (pt == null) {
            return;
        }
        this.min.setLocation(Math.min(pt.getX(), this.minX()), Math.min(pt.getY(), this.minY()));
        this.max.setLocation(Math.max(pt.getX(), this.maxX()), Math.max(pt.getY(), this.maxY()));
    }

    public void add(Extent ext) {
        if (ext == null) {
            return;
        }
        this.min.setLocation(Math.min(ext.minX(), this.minX()), Math.min(ext.minY(), this.minY()));
        this.max.setLocation(Math.max(ext.maxX(), this.maxX()), Math.max(ext.maxY(), this.maxY()));
    }

    public double[] getScale(int width, int height) {
        return this.getScale((double)width, (double)height);
    }

    public double[] getScale(double width, double height) {
        double[] scale = new double[]{(double)((float)width) / this.width(), (double)((float)height) / this.height()};
        return scale;
    }

    public Rectangle2D toRectangle2D() {
        return new Rectangle2D.Double(this.minX(), this.minY(), this.width(), this.height());
    }

    public String toString() {
        DecimalFormat format = new DecimalFormat("####.000");
        return "Extent: (" + format.format(this.minX()) + "," + format.format(this.minY()) + "), (" + format.format(this.maxX()) + "," + format.format(this.maxY()) + ")";
    }

    public Point2D getUL() {
        return (Point2D)this.ul.clone();
    }

    public Point2D getLR() {
        return (Point2D)this.lr.clone();
    }

    public double getULX() {
        if (this.ul.getX() == -9.99999999E8) {
            return this.minX();
        }
        return this.ul.getX();
    }

    public double getULY() {
        if (this.ul.getY() == -9.99999999E8) {
            return this.maxY();
        }
        return this.ul.getY();
    }

    public double getLRX() {
        if (this.lr.getX() == -9.99999999E8) {
            return this.maxX();
        }
        return this.lr.getX();
    }

    public double getLRY() {
        if (this.lr.getY() == -9.99999999E8) {
            return this.minY();
        }
        return this.lr.getY();
    }

    public double getURX() {
        return this.ur.getX();
    }

    public double getURY() {
        return this.ur.getY();
    }

    public double getLLX() {
        return this.ll.getX();
    }

    public double getLLY() {
        return this.ll.getY();
    }

    public void setULXToMin() {
        this.ul.setLocation(this.minX(), this.ul.getY());
        this.lr.setLocation(this.maxX(), this.lr.getY());
    }

    public void setULXToMax() {
        this.ul.setLocation(this.maxX(), this.ul.getY());
        this.lr.setLocation(this.minX(), this.lr.getY());
    }

    public void setULYToMin() {
        this.ul.setLocation(this.ul.getX(), this.minY());
        this.lr.setLocation(this.lr.getX(), this.maxY());
    }

    public void setULYToMax() {
        this.ul.setLocation(this.ul.getX(), this.maxY());
        this.lr.setLocation(this.lr.getX(), this.minY());
    }

    public void setLRXToMin() {
        this.lr.setLocation(this.minX(), this.lr.getY());
        this.ul.setLocation(this.maxX(), this.ul.getY());
    }

    public void setLRXToMax() {
        this.lr.setLocation(this.maxX(), this.lr.getY());
        this.ul.setLocation(this.minX(), this.ul.getY());
    }

    public void setLRYToMin() {
        this.lr.setLocation(this.lr.getX(), this.minY());
        this.ul.setLocation(this.ul.getX(), this.maxX());
    }

    public void setLRYToMax() {
        this.lr.setLocation(this.lr.getX(), this.maxY());
        this.ul.setLocation(this.ul.getX(), this.minY());
    }

    public Extent convert(ICoordTrans trans) {
        try {
            Envelope envelope = GeometryLocator.getGeometryManager().createEnvelope(this.getMin().getX(), this.getMin().getY(), this.getMax().getX(), this.getMax().getY(), 0);
            envelope = envelope.convert(trans);
            Point2D.Double ul = new Point2D.Double(envelope.getMinimum(0), envelope.getMaximum(1));
            Point2D.Double lr = new Point2D.Double(envelope.getMaximum(0), envelope.getMinimum(1));
            return RasterLocator.getManager().getDataStructFactory().createExtent((Point2D)ul, (Point2D)lr);
        }
        catch (CreateEnvelopeException | LocatorException e) {
            LOG.error("Can not convert data extent. []");
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Extent)) {
            return false;
        }
        Extent e1 = (Extent)obj;
        return this.getULX() == e1.getULX() && this.getULY() == e1.getULY() && this.getLRX() == e1.getLRX() && this.getLRY() == e1.getLRY() && this.getURX() == e1.getURX() && this.getURY() == e1.getURY() && this.getLLX() == e1.getLLX() && this.getLLY() == e1.getLLY();
    }

    public Point2D rasterToWorld(Point2D pt, double cellsize) {
        Point2D.Double p = new Point2D.Double();
        AffineTransform at = new AffineTransform(cellsize, 0.0, 0.0, -cellsize, this.getULX(), this.getULY());
        at.transform(pt, p);
        return p;
    }

    public Point2D worldToRaster(Point2D pt, double cellsize) {
        Point2D.Double p = new Point2D.Double();
        AffineTransform at = new AffineTransform(cellsize, 0.0, 0.0, -cellsize, this.getULX(), this.getULY());
        try {
            at.inverseTransform(pt, p);
        }
        catch (NoninvertibleTransformException e) {
            return pt;
        }
        return p;
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        double ulx = state.getDouble("ulx");
        double uly = state.getDouble("uly");
        double lrx = state.getDouble("lrx");
        double lry = state.getDouble("lry");
        double urx = state.getDouble("urx");
        double ury = state.getDouble("ury");
        double llx = state.getDouble("llx");
        double lly = state.getDouble("lly");
        this.ul.setLocation(ulx, uly);
        this.lr.setLocation(lrx, lry);
        this.ur.setLocation(urx, ury);
        this.ll.setLocation(llx, lly);
        if (this.ur.getX() != Double.POSITIVE_INFINITY && this.ur.getY() != Double.POSITIVE_INFINITY && this.ll.getX() != Double.POSITIVE_INFINITY && this.ll.getY() != Double.POSITIVE_INFINITY) {
            this.min = new Point2D.Double(Math.min(Math.min(this.ul.getX(), this.lr.getX()), Math.min(this.ur.getX(), this.ll.getX())), Math.min(Math.min(this.ul.getY(), this.lr.getY()), Math.min(this.ur.getY(), this.ll.getY())));
            this.max = new Point2D.Double(Math.max(Math.max(this.ul.getX(), this.lr.getX()), Math.max(this.ur.getX(), this.ll.getX())), Math.max(Math.max(this.ul.getY(), this.lr.getY()), Math.max(this.ur.getY(), this.ll.getY())));
        } else {
            this.newExtent(ulx, uly, lrx, lry);
        }
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("ulx", this.getULX());
        state.set("uly", this.getULY());
        state.set("lrx", this.getLRX());
        state.set("lry", this.getLRY());
        state.set("urx", this.getURX());
        state.set("ury", this.getURY());
        state.set("llx", this.getLLX());
        state.set("lly", this.getLLY());
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition(PERSISTENT_NAME);
        if (definition == null) {
            definition = manager.addDefinition(Extent.class, PERSISTENT_NAME, PERSISTENT_DESCRIPTION, null, null);
            definition.addDynFieldDouble("ulx").setMandatory(true);
            definition.addDynFieldDouble("uly").setMandatory(true);
            definition.addDynFieldDouble("lrx").setMandatory(true);
            definition.addDynFieldDouble("lry").setMandatory(true);
            definition.addDynFieldDouble("urx").setMandatory(false);
            definition.addDynFieldDouble("ury").setMandatory(false);
            definition.addDynFieldDouble("llx").setMandatory(false);
            definition.addDynFieldDouble("lly").setMandatory(false);
        }
    }

    protected void finalize() throws Throwable {
        this.min = null;
        this.max = null;
        this.ul = null;
        this.lr = null;
        this.ur = null;
        this.ll = null;
        super.finalize();
    }

    public static interface Has {
        public Extent getExtent();
    }
}

