/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.datastruct;

import java.io.IOException;
import java.util.Arrays;
import org.gvsig.fmap.dal.coverage.datastruct.TransparencyRange;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class TransparencyRangeImpl
implements TransparencyRange,
Cloneable {
    private String strEntry = null;
    private int[] red = null;
    private int[] green = null;
    private int[] blue = null;
    private boolean and = true;
    private int alpha = 0;

    public TransparencyRangeImpl() {
    }

    public TransparencyRangeImpl(String value) {
        try {
            this.red = new int[2];
            this.green = new int[2];
            this.blue = new int[2];
            this.and = this.stringToInterval(value, this.red, this.green, this.blue);
            this.strEntry = value;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isAnd() {
        return this.and;
    }

    public void setAnd(boolean and) {
        this.and = and;
    }

    public int[] getBlue() {
        return this.blue;
    }

    public void setRGB(int[] red, int[] green, int[] blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public void setBlue(int[] blue) {
        this.blue = blue;
    }

    public int[] getGreen() {
        return this.green;
    }

    public void setGreen(int[] green) {
        this.green = green;
    }

    public int[] getRed() {
        return this.red;
    }

    public void setRed(int[] red) {
        this.red = red;
    }

    public String getStrEntry() {
        return this.strEntry;
    }

    public void setStrEntry(String strEntry) {
        this.strEntry = strEntry;
    }

    public boolean stringToInterval(String values, int[] r, int[] g, int[] b) throws IOException {
        boolean and;
        block28: {
            int status = 0;
            int countAnd = 0;
            int countOr = 0;
            and = true;
            block13: for (int i = 0; i < values.length(); ++i) {
                char c = values.charAt(i);
                switch (status) {
                    case 0: {
                        if (c == ' ') {
                            status = 0;
                            continue block13;
                        }
                        if (c >= '0' && c <= '9' || c == '*') {
                            status = 1;
                            continue block13;
                        }
                        status = 4;
                        continue block13;
                    }
                    case 1: {
                        if (c >= '0' && c <= '9' || c == ' ') {
                            status = 1;
                            continue block13;
                        }
                        if (c == ':') {
                            status = 2;
                            continue block13;
                        }
                        if (c == '&') {
                            status = 0;
                            ++countAnd;
                            continue block13;
                        }
                        if (c == '|') {
                            status = 0;
                            ++countOr;
                            continue block13;
                        }
                        status = 4;
                        continue block13;
                    }
                    case 2: {
                        if (c >= '0' && c <= '9') {
                            status = 3;
                            continue block13;
                        }
                        status = 4;
                        continue block13;
                    }
                    case 3: {
                        if (c >= '0' && c <= '9' || c == ' ') {
                            status = 3;
                            continue block13;
                        }
                        if (c == '&') {
                            status = 0;
                            ++countAnd;
                            continue block13;
                        }
                        if (c == '|') {
                            status = 0;
                            ++countOr;
                            continue block13;
                        }
                        status = 4;
                        continue block13;
                    }
                    case 4: {
                        throw new IOException("Error en la cadena de entrada " + status);
                    }
                }
            }
            if ((status == 1 || status == 3) && (countAnd == 2 && countOr == 0 || countAnd == 0 && countOr == 2)) {
                String[] s = values.split(" & ");
                if (s.length < 3) {
                    s = values.split(" \\| ");
                    and = false;
                }
                String[] val = s[0].split(":");
                try {
                    r[0] = Integer.parseInt(val[0]);
                    r[1] = val.length == 2 ? Integer.parseInt(val[1]) : Integer.parseInt(val[0]);
                }
                catch (NumberFormatException e) {
                    r[0] = -1;
                    r[1] = -1;
                }
                val = s[1].split(":");
                try {
                    g[0] = Integer.parseInt(val[0]);
                    g[1] = val.length == 2 ? Integer.parseInt(val[1]) : Integer.parseInt(val[0]);
                }
                catch (NumberFormatException e) {
                    g[0] = -1;
                    g[1] = -1;
                }
                val = s[2].split(":");
                try {
                    b[0] = Integer.parseInt(val[0]);
                    if (val.length == 2) {
                        b[1] = Integer.parseInt(val[1]);
                        break block28;
                    }
                    b[1] = Integer.parseInt(val[0]);
                }
                catch (NumberFormatException e) {
                    b[0] = -1;
                    b[1] = -1;
                }
            } else {
                throw new IOException("Error en la cadena de entrada ");
            }
        }
        return and;
    }

    public void loadStrEntryFromValues() {
        String separator = " | ";
        if (this.and) {
            separator = " & ";
        }
        this.strEntry = String.valueOf(this.red[0] + separator + this.green[0] + separator + this.blue[0]);
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public int[] union(int[] interval, int rgb) {
        switch (rgb) {
            case 1: {
                if (this.red[1] >= interval[0] && this.red[0] <= interval[0] || this.red[0] <= interval[1] && this.red[0] >= interval[0]) {
                    return new int[]{Math.min(this.red[0], interval[0]), Math.max(this.red[1], interval[1])};
                }
            }
            case 2: {
                if (this.green[1] >= interval[0] && this.green[0] <= interval[0] || this.green[0] <= interval[1] && this.green[0] >= interval[0]) {
                    return new int[]{Math.min(this.green[0], interval[0]), Math.max(this.green[1], interval[1])};
                }
            }
            case 4: {
                if ((this.blue[1] < interval[0] || this.blue[0] > interval[0]) && (this.blue[0] > interval[1] || this.blue[0] < interval[0])) break;
                return new int[]{Math.min(this.blue[0], interval[0]), Math.max(this.blue[1], interval[1])};
            }
        }
        return null;
    }

    public void show() {
        if (this.getRed() != null) {
            System.out.println(this.getRed()[0] + " " + this.getRed()[1]);
        }
        if (this.getGreen() != null) {
            System.out.println(this.getGreen()[0] + " " + this.getGreen()[1]);
        }
        if (this.getBlue() != null) {
            System.out.println(this.getBlue()[0] + " " + this.getBlue()[1]);
        }
        System.out.println(this.isAnd());
        System.out.println(this.getStrEntry());
        System.out.println("--------------------");
    }

    public Object clone() {
        TransparencyRangeImpl clone = null;
        try {
            clone = (TransparencyRangeImpl)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (this.strEntry != null) {
            clone.strEntry = new String(this.strEntry);
        }
        if (this.red != null) {
            clone.red = (int[])this.red.clone();
        }
        if (this.green != null) {
            clone.green = (int[])this.green.clone();
        }
        if (this.blue != null) {
            clone.blue = (int[])this.blue.clone();
        }
        return clone;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.alpha;
        result = 31 * result + (this.and ? 1231 : 1237);
        result = 31 * result + TransparencyRangeImpl.hashCode(this.blue);
        result = 31 * result + TransparencyRangeImpl.hashCode(this.green);
        result = 31 * result + TransparencyRangeImpl.hashCode(this.red);
        result = 31 * result + (this.strEntry == null ? 0 : this.strEntry.hashCode());
        return result;
    }

    private static int hashCode(int[] array) {
        int PRIME = 31;
        if (array == null) {
            return 0;
        }
        int result = 1;
        for (int index = 0; index < array.length; ++index) {
            result = 31 * result + array[index];
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransparencyRangeImpl other = (TransparencyRangeImpl)obj;
        if (this.alpha != other.alpha) {
            return false;
        }
        if (this.and != other.and) {
            return false;
        }
        if (!Arrays.equals(this.blue, other.blue)) {
            return false;
        }
        if (!Arrays.equals(this.green, other.green)) {
            return false;
        }
        if (!Arrays.equals(this.red, other.red)) {
            return false;
        }
        return !(this.strEntry == null ? other.strEntry != null : !this.strEntry.equals(other.strEntry));
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.strEntry = state.getString("strEntry");
        this.alpha = state.getInt("alpha");
        this.red = state.getIntArray("red");
        this.green = state.getIntArray("green");
        this.blue = state.getIntArray("blue");
        this.and = state.getBoolean("and");
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("strEntry", this.strEntry);
        state.set("alpha", this.alpha);
        state.set("red", this.red);
        state.set("blue", this.blue);
        state.set("green", this.green);
        state.set("and", this.and);
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.addDefinition(TransparencyRangeImpl.class, "TransparencyRange_Persistent", "TransparencyRange Persistent definition", null, null);
        definition.addDynFieldString("strEntry").setMandatory(false);
        definition.addDynFieldInt("alpha").setMandatory(false);
        definition.addDynFieldArray("red").setClassOfItems(Integer.TYPE).setMandatory(false);
        definition.addDynFieldArray("blue").setClassOfItems(Integer.TYPE).setMandatory(false);
        definition.addDynFieldArray("green").setClassOfItems(Integer.TYPE).setMandatory(false);
        definition.addDynFieldBoolean("and").setMandatory(false);
    }
}

