/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.datastruct.serializer;

import java.awt.Color;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.gvsig.fmap.dal.coverage.datastruct.ColorItem;
import org.gvsig.fmap.dal.coverage.exception.ParsingException;
import org.gvsig.fmap.dal.coverage.store.props.ColorTable;
import org.gvsig.raster.impl.datastruct.ColorItemImpl;
import org.gvsig.raster.impl.store.properties.DataStoreColorTable;
import org.gvsig.raster.impl.store.rmf.ClassSerializer;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class ColorTableRmfSerializer
extends ClassSerializer {
    private final String MAIN_TAG = "ColorTable";
    private ColorTable colorTable = null;

    public static void register() {
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.get("Serializer");
        point.append("ColorTable", "", ColorTableRmfSerializer.class);
    }

    public ColorTableRmfSerializer(ColorTable colorTable) {
        this.colorTable = colorTable;
    }

    public ColorTableRmfSerializer() {
    }

    private static ColorItem getColorItem(ArrayList<ColorItem> list, double value) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getValue() != value) continue;
            return list.remove(i);
        }
        return null;
    }

    @Override
    public void read(String xml) throws ParsingException {
        String paletteName = "";
        boolean interpolated = true;
        KXmlParser parser = new KXmlParser();
        StringReader reader = new StringReader(xml);
        try {
            parser.setInput((Reader)reader);
        }
        catch (XmlPullParserException e) {
            throw new ParsingException(xml);
        }
        try {
            ArrayList<ColorItem> rows = new ArrayList<ColorItem>();
            int tag = parser.nextTag();
            if (parser.getEventType() != 1) {
                parser.require(2, null, "ColorTable");
                for (int i = 0; i < parser.getAttributeCount(); ++i) {
                    if (parser.getAttributeName(i).equals("name")) {
                        paletteName = parser.getAttributeValue(i);
                    }
                    if (!parser.getAttributeName(i).equals("interpolated")) continue;
                    interpolated = parser.getAttributeValue(i).equals("1");
                }
                while (tag != 1) {
                    switch (tag) {
                        case 2: {
                            if (parser.getName().equals("Color")) {
                                ColorItemImpl colorItem = new ColorItemImpl();
                                int a = 255;
                                for (int i = 0; i < parser.getAttributeCount(); ++i) {
                                    if (parser.getAttributeName(i).equals("value")) {
                                        colorItem.setValue(Double.parseDouble(parser.getAttributeValue(i)));
                                        ColorItem aux = ColorTableRmfSerializer.getColorItem(rows, Double.parseDouble(parser.getAttributeValue(i)));
                                        if (aux != null) {
                                            a = aux.getColor().getAlpha();
                                        }
                                    }
                                    if (parser.getAttributeName(i).equals("name")) {
                                        colorItem.setNameClass(parser.getAttributeValue(i));
                                    }
                                    if (parser.getAttributeName(i).equals("rgb")) {
                                        String rgb = parser.getAttributeValue(i);
                                        int r = Integer.valueOf(rgb.substring(0, rgb.indexOf(",")));
                                        int g = Integer.valueOf(rgb.substring(rgb.indexOf(",") + 1, rgb.lastIndexOf(",")));
                                        int b = Integer.valueOf(rgb.substring(rgb.lastIndexOf(",") + 1, rgb.length()));
                                        colorItem.setColor(new Color(r, g, b, a));
                                    }
                                    if (!parser.getAttributeName(i).equals("interpolated")) continue;
                                    colorItem.setInterpolated(Double.parseDouble(parser.getAttributeValue(i)));
                                }
                                rows.add(colorItem);
                                break;
                            }
                            if (!parser.getName().equals("Alpha")) break;
                            ColorItemImpl colorItem = new ColorItemImpl();
                            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                                if (parser.getAttributeName(i).equals("value")) {
                                    colorItem.setValue(Double.parseDouble(parser.getAttributeValue(i)));
                                    ColorItem aux = ColorTableRmfSerializer.getColorItem(rows, Double.parseDouble(parser.getAttributeValue(i)));
                                    if (aux != null) {
                                        colorItem.setNameClass(aux.getNameClass());
                                        colorItem.setInterpolated(aux.getInterpolated());
                                        colorItem.setColor(new Color(aux.getColor().getRed(), aux.getColor().getGreen(), aux.getColor().getBlue(), colorItem.getColor().getAlpha()));
                                    }
                                }
                                if (parser.getAttributeName(i).equals("alpha")) {
                                    int a = Integer.parseInt(parser.getAttributeValue(i));
                                    colorItem.setColor(new Color(colorItem.getColor().getRed(), colorItem.getColor().getGreen(), colorItem.getColor().getBlue(), a));
                                }
                                if (!parser.getAttributeName(i).equals("interpolated")) continue;
                                colorItem.setInterpolated(Double.parseDouble(parser.getAttributeValue(i)));
                            }
                            rows.add(colorItem);
                            break;
                        }
                    }
                    tag = parser.next();
                }
                parser.require(1, null, null);
            }
            this.colorTable = new DataStoreColorTable();
            this.colorTable.setName(paletteName);
            this.colorTable.createPaletteFromColorItems(rows, false);
            this.colorTable.setInterpolated(interpolated);
        }
        catch (XmlPullParserException e) {
            throw new ParsingException(xml);
        }
        catch (IOException e) {
            throw new ParsingException(xml);
        }
    }

    @Override
    public String write() {
        Color c;
        ColorItem colorItem;
        int i;
        StringBuffer b = new StringBuffer();
        if (this.colorTable == null) {
            return "";
        }
        b.append("<ColorTable name=\"" + this.colorTable.getName() + "\" interpolated=\"" + (this.colorTable.isInterpolated() ? "1" : "0") + "\" version=\"1.1\">\n");
        for (i = 0; i < this.colorTable.getColorItems().size(); ++i) {
            b.append("\t<Color");
            colorItem = (ColorItem)this.colorTable.getColorItems().get(i);
            b.append(" value=\"" + colorItem.getValue() + "\"");
            b.append(" name=\"" + colorItem.getNameClass() + "\"");
            c = colorItem.getColor();
            b.append(" rgb=\"" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + "\"");
            b.append(" interpolated=\"" + colorItem.getInterpolated() + "\"");
            b.append("/>\n");
        }
        for (i = 0; i < this.colorTable.getColorItems().size(); ++i) {
            b.append("\t<Alpha");
            colorItem = (ColorItem)this.colorTable.getColorItems().get(i);
            b.append(" value=\"" + colorItem.getValue() + "\"");
            c = colorItem.getColor();
            b.append(" alpha=\"" + c.getAlpha() + "\"");
            b.append(" interpolated=\"" + colorItem.getInterpolated() + "\"");
            b.append("/>\n");
        }
        b.append("</ColorTable>\n");
        return b.toString();
    }

    @Override
    public Object getResult() {
        return this.colorTable;
    }

    @Override
    public String getMainTag() {
        return "ColorTable";
    }
}

