/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.band;

import org.gvsig.raster.impl.grid.filter.band.ColorBalanceRGBFilter;

public class ColorBalanceRGBByteFilter
extends ColorBalanceRGBFilter {
    @Override
    public void process(int col, int line) {
        byte[] value = new byte[]{this.raster.getElemByte(line, col, this.redBandNumber), this.raster.getElemByte(line, col, this.greenBandNumber), this.raster.getElemByte(line, col, this.blueBandNumber), -1};
        double lum = this.colorConversion.getLuminosity(value[0] & 0xFF, value[1] & 0xFF, value[2] & 0xFF);
        value[0] = (byte)Math.min((value[0] & 0xFF) + (this.red >> 1), 255);
        value[1] = (byte)Math.min((value[1] & 0xFF) + (this.green >> 1), 255);
        value[2] = (byte)Math.min((value[2] & 0xFF) + (this.blue >> 1), 255);
        if (this.luminosity) {
            double[] hsl = this.colorConversion.RGBtoHSL(value[0] & 0xFF, value[1] & 0xFF, value[2] & 0xFF);
            hsl[0] = (int)(255.0 * hsl[0] / 360.0 + 0.5);
            hsl[1] = (int)(hsl[1] * 255.0 + 0.5);
            hsl[2] = (int)(lum * 255.0 + 0.5);
            int[] v1 = this.colorConversion.HSLtoRGB((int)hsl[0] & 0xFFFFFFFF, (int)hsl[1] & 0xFFFFFFFF, (int)hsl[2] & 0xFFFFFFFF);
            byte[] v = new byte[4];
            for (int band = 0; band < 3; ++band) {
                v[band] = (byte)v1[band];
            }
            v[3] = value[3];
            this.rasterResult.setElemByte(line, col, v);
        } else {
            this.rasterResult.setElemByte(line, col, value);
        }
        this.writeAlphaBand(line, col);
    }
}

