/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.band;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FilterTypeException;
import org.gvsig.fmap.dal.coverage.grid.AbstractRasterFilterManager;
import org.gvsig.fmap.dal.coverage.grid.RasterFilter;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.raster.impl.grid.filter.RasterFilterListManagerImpl;
import org.gvsig.raster.impl.grid.filter.band.ColorBalanceRGBByteFilter;
import org.gvsig.raster.impl.grid.filter.band.ColorBalanceRGBFilter;
import org.gvsig.raster.impl.grid.filter.band.ColorTableFilter;
import org.gvsig.raster.impl.store.ParamImpl;

public class ColorBalanceRGBManager
extends AbstractRasterFilterManager {
    private static String ID = "ColorBalanceRGB";

    public ColorBalanceRGBManager(RasterFilterList filterList) {
        super(filterList);
    }

    public String getManagerID() {
        return ID;
    }

    public static void register() {
        AbstractRasterFilterManager.register((String)ID, ColorBalanceRGBManager.class);
    }

    public boolean isDataTypeSupported(int dataType) {
        return dataType == 0;
    }

    public Class<?> getFilterClassByID(String id) {
        if (id.compareTo("colorbalancergb") == 0) {
            return ColorTableFilter.class;
        }
        return null;
    }

    public ColorBalanceRGBManager(RasterFilterListManagerImpl filterListManager) {
        super(filterListManager.getFilterList());
    }

    public void addColorBalanceFilter(int red, int green, int blue, boolean luminosity, int[] renderBands) throws FilterTypeException {
        ColorBalanceRGBByteFilter filter = new ColorBalanceRGBByteFilter();
        if (filter != null) {
            filter.addParam("red", new Integer(red));
            filter.addParam("green", new Integer(green));
            filter.addParam("blue", new Integer(blue));
            filter.addParam("luminosity", new Boolean(luminosity));
            filter.addParam("renderBands", renderBands);
            this.getFilterList().add((RasterFilter)filter);
        }
    }

    public List<Class<?>> getRasterFilterList() {
        ArrayList filters = new ArrayList();
        filters.add(ColorBalanceRGBFilter.class);
        return filters;
    }

    public void addFilter(Class<?> classFilter, Params params) throws FilterTypeException {
        if (ColorBalanceRGBFilter.class.isAssignableFrom(classFilter)) {
            int red = 0;
            int green = 0;
            int blue = 0;
            boolean luminosity = false;
            int[] renderBands = new int[]{0, 1, 2, 3};
            for (int i = 0; i < params.getNumParams(); ++i) {
                if (((ParamImpl)params.getParam(i)).getId().equals("RenderBands") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof String) {
                    String[] bands = new String((String)((ParamImpl)params.getParam(i)).getDefaultValue()).split(" ");
                    renderBands[0] = new Integer(bands[0]);
                    renderBands[1] = new Integer(bands[1]);
                    renderBands[2] = new Integer(bands[2]);
                    continue;
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("alphaBand") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Integer) {
                    renderBands[3] = (Integer)((ParamImpl)params.getParam(i)).getDefaultValue();
                    continue;
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("red")) {
                    red = (Integer)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("green")) {
                    green = (Integer)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("blue")) {
                    blue = (Integer)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (!((ParamImpl)params.getParam(i)).getId().equals("luminosity")) continue;
                luminosity = (Boolean)((ParamImpl)params.getParam(i)).getDefaultValue();
            }
            this.addColorBalanceFilter(red, green, blue, luminosity, renderBands);
        }
    }

    public RasterFilter createFilter(Params params) {
        int[] renderBands = new int[]{0, 1, 2};
        String b = (String)params.getParamById("RenderBands").getDefaultValue();
        String[] bands = b.split(" ");
        renderBands[0] = new Integer(bands[0]);
        renderBands[1] = new Integer(bands[1]);
        renderBands[2] = new Integer(bands[2]);
        Double red = (Double)params.getParamById("red").getDefaultValue();
        Double green = (Double)params.getParamById("green").getDefaultValue();
        Double blue = (Double)params.getParamById("blue").getDefaultValue();
        Double lum = (Double)params.getParamById("luminosity").getDefaultValue();
        ColorBalanceRGBByteFilter filter = new ColorBalanceRGBByteFilter();
        filter.addParam("red", red);
        filter.addParam("luminosity", lum);
        filter.addParam("green", green);
        filter.addParam("blue", blue);
        filter.addParam("renderBands", renderBands);
        return filter;
    }

    public void addFilter(Params params) throws FilterTypeException {
        this.addFilter(ColorBalanceRGBFilter.class, params);
    }
}

