/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.band;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FilterTypeException;
import org.gvsig.fmap.dal.coverage.grid.AbstractRasterFilterManager;
import org.gvsig.fmap.dal.coverage.grid.RasterFilter;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.raster.impl.grid.filter.RasterFilterListManagerImpl;
import org.gvsig.raster.impl.grid.filter.band.ToLumSaByteFilter;
import org.gvsig.raster.impl.grid.filter.band.ToLumSaFilter;
import org.gvsig.raster.impl.store.ParamImpl;

public class ToLumSaManager
extends AbstractRasterFilterManager {
    private static String ID = "ToLumSa";

    public ToLumSaManager(RasterFilterList filterList) {
        super(filterList);
    }

    public String getManagerID() {
        return ID;
    }

    public static void register() {
        AbstractRasterFilterManager.register((String)ID, ToLumSaManager.class);
    }

    public boolean isDataTypeSupported(int dataType) {
        return dataType == 0;
    }

    public Class<?> getFilterClassByID(String id) {
        if (id.compareTo("tolumsa") == 0) {
            return ToLumSaFilter.class;
        }
        return null;
    }

    public ToLumSaManager(RasterFilterListManagerImpl filterListManager) {
        super(filterListManager.getFilterList());
    }

    public void addToLumSaFilter(double hue, double luminosity, double saturation, int[] renderBands) throws FilterTypeException {
        ToLumSaByteFilter filter = new ToLumSaByteFilter();
        if (filter != null) {
            filter.addParam("hue", new Double(hue));
            filter.addParam("luminosity", new Double(luminosity));
            filter.addParam("saturation", new Double(saturation));
            filter.addParam("renderBands", renderBands);
            this.getFilterList().add((RasterFilter)filter);
        }
    }

    public List<Class<?>> getRasterFilterList() {
        ArrayList filters = new ArrayList();
        filters.add(ToLumSaFilter.class);
        return filters;
    }

    public void addFilter(Class<?> classFilter, Params params) throws FilterTypeException {
        if (ToLumSaFilter.class.isAssignableFrom(classFilter)) {
            double hue = 0.0;
            double saturation = 0.0;
            double luminosity = 0.0;
            int[] renderBands = new int[]{0, 1, 2, 3};
            for (int i = 0; i < params.getNumParams(); ++i) {
                if (((ParamImpl)params.getParam(i)).getId().equals("RenderBands") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof String) {
                    String[] bands = new String((String)((ParamImpl)params.getParam(i)).getDefaultValue()).split(" ");
                    renderBands[0] = new Integer(bands[0]);
                    renderBands[1] = new Integer(bands[1]);
                    renderBands[2] = new Integer(bands[2]);
                    continue;
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("alphaBand") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Integer) {
                    renderBands[3] = (Integer)((ParamImpl)params.getParam(i)).getDefaultValue();
                    continue;
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("hue")) {
                    hue = (Double)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("saturation")) {
                    saturation = (Double)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (!((ParamImpl)params.getParam(i)).getId().equals("luminosity")) continue;
                luminosity = (Double)((ParamImpl)params.getParam(i)).getDefaultValue();
            }
            this.addToLumSaFilter(hue, luminosity, saturation, renderBands);
        }
    }

    public void addFilter(Params params) throws FilterTypeException {
        this.addFilter(ToLumSaFilter.class, params);
    }

    public RasterFilter createFilter(Params params) {
        int[] renderBands = new int[]{0, 1, 2};
        String b = (String)params.getParamById("RenderBands").getDefaultValue();
        String[] bands = b.split(" ");
        renderBands[0] = new Integer(bands[0]);
        renderBands[1] = new Integer(bands[1]);
        renderBands[2] = new Integer(bands[2]);
        Double hue = (Double)params.getParamById("hue").getDefaultValue();
        Double sat = (Double)params.getParamById("saturation").getDefaultValue();
        Double lum = (Double)params.getParamById("luminosity").getDefaultValue();
        ToLumSaByteFilter filter = new ToLumSaByteFilter();
        filter.addParam("hue", hue);
        filter.addParam("luminosity", lum);
        filter.addParam("saturation", sat);
        filter.addParam("renderBands", renderBands);
        return filter;
    }
}

