/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.correction;

import java.util.Arrays;
import org.gvsig.fmap.dal.coverage.exception.FilterAddException;
import org.gvsig.raster.impl.DefaultRasterManager;
import org.gvsig.raster.impl.grid.filter.correction.MedianFilter;

public class MedianIntegerFilter
extends MedianFilter {
    private int[] window = null;

    @Override
    public void pre() throws FilterAddException {
        super.pre();
        this.window = new int[this.sizeWindow];
        this.rasterResult = DefaultRasterManager.getInstance().createBuffer(3, this.raster.getWidth(), this.raster.getHeight(), this.raster.getBandCount(), true);
    }

    @Override
    public void process(int col, int line) {
        for (int band = 0; band < this.numberOfBandsToProcess(); ++band) {
            int k = 0;
            for (int i = -this.halfSide; i <= this.halfSide; ++i) {
                for (int j = -this.halfSide; j <= this.halfSide; ++j) {
                    if (col + i < 0 || line + j < 0 || col + i >= this.width || line + j >= this.height) continue;
                    this.window[k] = this.raster.getElemInt(line + j, col + i, band) & 0xFF;
                    ++k;
                }
            }
            Arrays.sort(this.window, 0, k);
            this.rasterResult.setElem(line, col, band, this.window[k >> 1]);
        }
    }

    @Override
    public int getInRasterDataType() {
        return 3;
    }

    @Override
    public int getOutRasterDataType() {
        return 3;
    }
}

