/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.correction;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FilterTypeException;
import org.gvsig.fmap.dal.coverage.grid.AbstractRasterFilterManager;
import org.gvsig.fmap.dal.coverage.grid.RasterFilter;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.raster.impl.grid.filter.RasterFilterListManagerImpl;
import org.gvsig.raster.impl.grid.filter.correction.MedianByteFilter;
import org.gvsig.raster.impl.grid.filter.correction.MedianFilter;
import org.gvsig.raster.impl.store.ParamImpl;

public class MedianListManager
extends AbstractRasterFilterManager {
    private static String ID = "Median";

    public MedianListManager(RasterFilterList filterList) {
        super(filterList);
    }

    public String getManagerID() {
        return ID;
    }

    public static void register() {
        AbstractRasterFilterManager.register((String)ID, MedianListManager.class);
    }

    public MedianListManager(RasterFilterListManagerImpl filterListManager) {
        super(filterListManager.getFilterList());
    }

    public boolean isDataTypeSupported(int dataType) {
        return true;
    }

    public Class<?> getFilterClassByID(String id) {
        if (id.compareTo("median") == 0) {
            return MedianFilter.class;
        }
        return null;
    }

    public void addMedianFilter(int ladoVentana) throws FilterTypeException {
        MedianByteFilter filter = new MedianByteFilter();
        if (filter != null) {
            filter.addParam("ladoVentana", new Integer(ladoVentana));
            this.getFilterList().add((RasterFilter)filter);
        }
    }

    public List<Class<?>> getRasterFilterList() {
        ArrayList filters = new ArrayList();
        filters.add(MedianFilter.class);
        return filters;
    }

    public void addFilter(Class<?> classFilter, Params params) throws FilterTypeException {
        if (MedianFilter.class.isAssignableFrom(classFilter)) {
            int ladoVentana = 0;
            for (int i = 0; i < params.getNumParams(); ++i) {
                if (!((ParamImpl)params.getParam(i)).getId().equals("ladoVentana") || !(((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Integer)) continue;
                ladoVentana = (Integer)((ParamImpl)params.getParam(i)).getDefaultValue();
            }
            this.addMedianFilter(ladoVentana);
        }
    }

    public void addFilter(Params params) throws FilterTypeException {
        this.addFilter(MedianFilter.class, params);
    }

    public RasterFilter createFilter(Params params) {
        if (params.getParamById("ladoVentana") != null) {
            int ladoVentana = (Integer)params.getParamById("ladoVentana").getDefaultValue();
            MedianByteFilter filter = new MedianByteFilter();
            filter.addParam("ladoVentana", new Integer(ladoVentana));
            return filter;
        }
        return null;
    }
}

