/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.correction;

import org.gvsig.fmap.dal.coverage.exception.FilterAddException;
import org.gvsig.raster.impl.grid.filter.correction.ModeFilter;

public class ModeByteFilter
extends ModeFilter {
    private int[] window = null;
    private int tempValue = 0;

    @Override
    public void pre() throws FilterAddException {
        super.pre();
        this.window = new int[this.sizeWindow];
    }

    @Override
    public void process(int col, int line) {
        for (int band = 0; band < this.numberOfBandsToProcess(); ++band) {
            int k = 0;
            this.count = 0;
            for (int i = -this.halfSide; i <= this.halfSide; ++i) {
                for (int j = -this.halfSide; j <= this.halfSide; ++j) {
                    if (col + i < 0 || line + j < 0 || col + i >= this.width || line + j >= this.height) continue;
                    this.window[k] = this.raster.getElemByte(line + j, col + i, band) & 0xFF;
                    if (i == -this.halfSide && j == -this.halfSide) {
                        this.tempValue = this.window[k];
                    }
                    if (this.tempValue == this.window[k]) {
                        ++this.count;
                    }
                    ++k;
                }
            }
            if (this.count > this.sizeWindow) {
                return;
            }
            for (k = 1; k < this.window.length; ++k) {
                int auxCount = 0;
                for (int i = k; i < this.window.length; ++i) {
                    if (this.window[i] != this.window[k]) continue;
                    ++auxCount;
                }
                if (auxCount <= this.count) continue;
                this.count = auxCount;
                this.tempValue = this.window[k];
                if (this.count <= this.sizeWindow) continue;
                return;
            }
            this.rasterResult.setElem(line, col, band, (byte)this.tempValue);
        }
        this.writeAlphaBand(line, col);
    }

    @Override
    public int getInRasterDataType() {
        return 0;
    }

    @Override
    public int getOutRasterDataType() {
        return 0;
    }
}

