/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.enhancement;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FileNotOpenException;
import org.gvsig.fmap.dal.coverage.exception.FilterTypeException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.grid.AbstractRasterFilterManager;
import org.gvsig.fmap.dal.coverage.grid.RasterFilter;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.fmap.dal.coverage.store.props.Statistics;
import org.gvsig.raster.impl.grid.filter.RasterFilterListManagerImpl;
import org.gvsig.raster.impl.grid.filter.enhancement.DefaultLinearStretchParams;
import org.gvsig.raster.impl.grid.filter.enhancement.LinearStretchEnhancementFilter;
import org.gvsig.raster.impl.grid.filter.enhancement.LinearStretchEnhancementFloatFilter;
import org.gvsig.raster.impl.grid.filter.statistics.StatisticsListManager;
import org.gvsig.raster.impl.store.ParamImpl;

public class EnhancementStretchListManager
extends AbstractRasterFilterManager {
    private static String ID = "EnhancementStretch";
    private RasterFilterListManagerImpl filterListManager = null;

    public EnhancementStretchListManager(RasterFilterList filterList) {
        super(filterList);
    }

    public String getManagerID() {
        return ID;
    }

    public static void register() {
        AbstractRasterFilterManager.register((String)ID, EnhancementStretchListManager.class);
    }

    public EnhancementStretchListManager(RasterFilterListManagerImpl filterListManager) {
        super(filterListManager.getFilterList());
        this.filterListManager = filterListManager;
    }

    public Class<?> getFilterClassByID(String id) {
        if (id.compareTo("enhanced_stretch") == 0) {
            return LinearStretchEnhancementFilter.class;
        }
        return null;
    }

    public boolean isDataTypeSupported(int dataType) {
        return true;
    }

    public void addEnhancedStretchFilter(DefaultLinearStretchParams leParams, Statistics stats, int[] renderBands, boolean removeEnds) throws FilterTypeException {
        try {
            RasterFilter filter;
            if (!leParams.hasTailTrim()) {
                if (!stats.isCalculated()) {
                    try {
                        stats.calculate(RasterLibrary.statisticsScale);
                    }
                    catch (FileNotOpenException e) {
                        return;
                    }
                    catch (RasterDriverException e) {
                        return;
                    }
                }
            } else {
                StatisticsListManager slm = null;
                slm = this.filterListManager != null ? new StatisticsListManager(this.filterListManager) : new StatisticsListManager(this.getFilterList());
                slm.addTailFilter(leParams.getTailTrimList(), 0.0, removeEnds, stats);
            }
            if ((filter = EnhancementStretchListManager.createEnhancedFilter(leParams, stats, renderBands, removeEnds)) != null) {
                this.getFilterList().add(filter);
            }
        }
        catch (ProcessInterruptedException processInterruptedException) {
            // empty catch block
        }
    }

    public void addFilter(Params params) throws FilterTypeException {
        int[] renderBands = (int[])params.getParamById("renderBands").getDefaultValue();
        Statistics stats = (Statistics)params.getParamById("stats").getDefaultValue();
        boolean removeEnds = (Boolean)params.getParamById("remove").getDefaultValue();
        DefaultLinearStretchParams p = null;
        try {
            if (params.getParamById("tailtrim") != null && params.getParamById("tailtrim").getDefaultValue() != null && params.getParamById("rgb").getDefaultValue() != null) {
                double tailtrim = (Double)params.getParamById("tailtrim").getDefaultValue();
                boolean rgb = (Boolean)params.getParamById("rgb").getDefaultValue();
                p = DefaultLinearStretchParams.createStandardParam(renderBands, tailtrim, stats, rgb);
            } else if (params.getParamById("stretchs").getDefaultValue() == null) {
                boolean rgb = false;
                if (params.getParamById("rgb").getDefaultValue() != null) {
                    rgb = (Boolean)params.getParamById("rgb").getDefaultValue();
                }
                p = DefaultLinearStretchParams.createStandardParam(renderBands, 0.0, stats, rgb);
            }
        }
        catch (FileNotOpenException e) {
            throw new FilterTypeException("", (Exception)((Object)e));
        }
        catch (RasterDriverException e) {
            throw new FilterTypeException("", (Exception)((Object)e));
        }
        this.addEnhancedStretchFilter(p, stats, renderBands, removeEnds);
    }

    public static RasterFilter createEnhancedFilter(DefaultLinearStretchParams leParams, Statistics stats, int[] renderBands, boolean removeEnds) {
        LinearStretchEnhancementFloatFilter filter = new LinearStretchEnhancementFloatFilter();
        if (filter != null) {
            filter.addParam("stats", stats);
            filter.addParam("remove", new Boolean(false));
            filter.addParam("renderBands", renderBands);
            filter.addParam("stretchs", leParams);
            filter.addParam("remove", new Boolean(removeEnds));
        }
        return filter;
    }

    public List<Class<?>> getRasterFilterList() {
        ArrayList filters = new ArrayList();
        filters.add(LinearStretchEnhancementFilter.class);
        return filters;
    }

    public void addFilter(Class<?> classFilter, Params params) throws FilterTypeException {
        if (LinearStretchEnhancementFilter.class.isAssignableFrom(classFilter)) {
            int[] renderBands = new int[]{0, 1, 2};
            boolean removeEnds = false;
            DefaultLinearStretchParams leParams = new DefaultLinearStretchParams();
            for (int i = 0; i < params.getNumParams(); ++i) {
                if (((ParamImpl)params.getParam(i)).getId().equals("RenderBands") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof String) {
                    String[] bands = new String((String)((ParamImpl)params.getParam(i)).getDefaultValue()).split(" ");
                    renderBands[0] = new Integer(bands[0]);
                    renderBands[1] = new Integer(bands[1]);
                    renderBands[2] = new Integer(bands[2]);
                    continue;
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("Remove")) {
                    removeEnds = (Boolean)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("RGB")) {
                    leParams.rgb = (Boolean)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("StretchInRed") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof double[]) {
                    leParams.red.stretchIn = (double[])((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("StretchInGreen") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof double[]) {
                    leParams.green.stretchIn = (double[])((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("StretchInBlue") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof double[]) {
                    leParams.blue.stretchIn = (double[])((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("StretchOutRed") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof int[]) {
                    leParams.red.stretchOut = (int[])((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("StretchOutGreen") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof int[]) {
                    leParams.green.stretchOut = (int[])((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("StretchOutBlue") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof int[]) {
                    leParams.blue.stretchOut = (int[])((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("TailTrimRedMin") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Double) {
                    leParams.red.tailTrimMin = (Double)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("TailTrimRedMax") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Double) {
                    leParams.red.tailTrimMax = (Double)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("TailTrimGreenMin") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Double) {
                    leParams.green.tailTrimMin = (Double)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("TailTrimGreenMax") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Double) {
                    leParams.green.tailTrimMax = (Double)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("TailTrimBlueMin") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Double) {
                    leParams.blue.tailTrimMin = (Double)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("TailTrimBlueMax") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Double) {
                    leParams.blue.tailTrimMax = (Double)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("StretchRedFunctionType") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Integer) {
                    leParams.red.functionType = (Integer)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("StretchRedValueFunction") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Double) {
                    leParams.red.valueFunction = (Double)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("StretchGreenFunctionType") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Integer) {
                    leParams.green.functionType = (Integer)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("StretchGreenValueFunction") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Double) {
                    leParams.green.valueFunction = (Double)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("StretchBlueFunctionType") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Integer) {
                    leParams.blue.functionType = (Integer)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("StretchBlueValueFunction") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Double) {
                    leParams.blue.valueFunction = (Double)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("TailTrimRedValueMin") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Double) {
                    leParams.red.tailTrimValueMin = (Double)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("TailTrimRedValueMax") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Double) {
                    leParams.red.tailTrimValueMax = (Double)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("TailTrimGreenValueMin") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Double) {
                    leParams.green.tailTrimValueMin = (Double)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("TailTrimGreenValueMax") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Double) {
                    leParams.green.tailTrimValueMax = (Double)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("TailTrimBlueValueMin") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Double) {
                    leParams.blue.tailTrimValueMin = (Double)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("TailTrimBlueValueMax") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Double) {
                    leParams.blue.tailTrimValueMax = (Double)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("RedMaxValue") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Double) {
                    leParams.red.maxValue = (Double)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("RedMinValue") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Double) {
                    leParams.red.minValue = (Double)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("GreenMaxValue") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Double) {
                    leParams.green.maxValue = (Double)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("GreenMinValue") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Double) {
                    leParams.green.minValue = (Double)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("BlueMaxValue") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Double) {
                    leParams.blue.maxValue = (Double)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("BlueMinValue") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Double) {
                    leParams.blue.minValue = (Double)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("RedOffset") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof double[]) {
                    leParams.red.offset = (double[])((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("GreenOffset") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof double[]) {
                    leParams.green.offset = (double[])((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("BlueOffset") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof double[]) {
                    leParams.blue.offset = (double[])((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("RedScale") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof double[]) {
                    leParams.red.scale = (double[])((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("GreenScale") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof double[]) {
                    leParams.green.scale = (double[])((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (!((ParamImpl)params.getParam(i)).getId().equals("BlueScale") || !(((ParamImpl)params.getParam(i)).getDefaultValue() instanceof double[])) continue;
                leParams.blue.scale = (double[])((ParamImpl)params.getParam(i)).getDefaultValue();
            }
            this.addEnhancedStretchFilter(leParams, (Statistics)this.getFilterList().getEnvParam("SrcStatistics"), renderBands, removeEnds);
        }
    }

    public RasterFilter createFilter(Params params) throws FilterTypeException {
        int[] renderBands = null;
        Statistics stats = null;
        Boolean removeEnds = null;
        if (params.getParamById("renderBands") != null) {
            renderBands = (int[])params.getParamById("renderBands").getDefaultValue();
        }
        if (params.getParamById("stats") != null) {
            stats = (Statistics)params.getParamById("stats").getDefaultValue();
        }
        if (params.getParamById("remove") != null) {
            removeEnds = (Boolean)params.getParamById("remove").getDefaultValue();
        }
        DefaultLinearStretchParams p = null;
        try {
            if (params.getParamById("tailtrim") != null && params.getParamById("rgb") != null && params.getParamById("tailtrim").getDefaultValue() != null && params.getParamById("rgb").getDefaultValue() != null) {
                double tailtrim = (Double)params.getParamById("tailtrim").getDefaultValue();
                boolean rgb = (Boolean)params.getParamById("rgb").getDefaultValue();
                p = DefaultLinearStretchParams.createStandardParam(renderBands, tailtrim, stats, rgb);
            } else if (params.getParamById("stretchs") != null && params.getParamById("stretchs").getDefaultValue() == null) {
                p = DefaultLinearStretchParams.createStandardParam(renderBands, 0.0, stats, removeEnds);
            }
        }
        catch (FileNotOpenException e) {
            throw new FilterTypeException("", (Exception)((Object)e));
        }
        catch (RasterDriverException e) {
            throw new FilterTypeException("", (Exception)((Object)e));
        }
        return EnhancementStretchListManager.createEnhancedFilter(p, stats, renderBands, removeEnds != null ? removeEnds : true);
    }
}

