/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.enhancement;

import org.gvsig.fmap.dal.coverage.exception.FilterAddException;
import org.gvsig.raster.impl.grid.filter.enhancement.EqualizationFilter;

public class EqualizationShortFilter
extends EqualizationFilter {
    private double[] distance = null;
    private double[] dto = null;

    @Override
    public void process(int col, int line) {
        for (int iBand = 0; iBand < this.numberOfBandsToProcess(); ++iBand) {
            short p = this.raster.getElemShort(line, col, iBand);
            if (!this.equalizationActive(iBand)) {
                this.rasterResult.setElem(line, col, iBand, p);
                continue;
            }
            int pos = (int)(((double)p + this.dto[iBand]) * (double)this.nClasses / this.distance[iBand]);
            int ecualizationPositive = (int)this.lahe[iBand][pos];
            int ecualizationNegative = (int)this.lahe[iBand][this.nElements - pos];
            double value = (this.nElements - ecualizationNegative + ecualizationPositive) / 2;
            this.rasterResult.setElem(line, col, iBand, (short)value);
        }
    }

    @Override
    public void pre() throws FilterAddException {
        super.pre();
        this.distance = new double[this.raster.getBandCount()];
        this.dto = new double[this.raster.getBandCount()];
        for (int i = 0; i < this.raster.getBandCount(); ++i) {
            this.distance[i] = this.maxBandValue[i] - this.minBandValue[i];
            this.dto[i] = -this.minBandValue[i];
        }
    }

    @Override
    public int getInRasterDataType() {
        return 2;
    }

    @Override
    public int getOutRasterDataType() {
        return 2;
    }
}

