/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.enhancement;

import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FileNotOpenException;
import org.gvsig.fmap.dal.coverage.exception.FilterAddException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.grid.filter.BaseRasterFilter;
import org.gvsig.fmap.dal.coverage.store.props.Statistics;
import org.gvsig.raster.impl.store.ParamsImpl;

public class LinearEnhancementFilter
extends BaseRasterFilter {
    protected double[] scale = new double[3];
    protected double[] offset = new double[3];
    protected Statistics stats = null;
    protected double[] minBandValue = null;
    protected double[] maxBandValue = null;
    protected boolean removeEnds = false;
    protected double tailTrim = 0.0;
    protected int nbands = 3;
    public static String[] names = new String[]{"enhanced"};

    public LinearEnhancementFilter() {
        this.setName(names[0]);
    }

    public void pre() throws FilterAddException {
        int i;
        super.pre();
        this.stats = (Statistics)this.params.get("stats");
        this.removeEnds = (Boolean)this.params.get("remove");
        this.tailTrim = (Double)this.params.get("tailTrim");
        if (this.tailTrim >= 0.5 && this.tailTrim < 0.51) {
            this.tailTrim = 0.51;
        }
        if (this.tailTrim > 0.49 && this.tailTrim < 0.5) {
            this.tailTrim = 0.49;
        }
        try {
            this.stats.calculate(RasterLibrary.statisticsScale);
        }
        catch (FileNotOpenException e) {
            this.exec = false;
        }
        catch (RasterDriverException e) {
            this.exec = false;
        }
        catch (ProcessInterruptedException e) {
            this.exec = false;
        }
        double[][] tailTrimByBand = (double[][])this.stats.getTailTrimValue(this.tailTrim);
        if (this.tailTrim != 0.0 && tailTrimByBand != null) {
            this.scale = new double[tailTrimByBand.length];
            this.offset = new double[tailTrimByBand.length];
            this.minBandValue = new double[tailTrimByBand.length];
            this.maxBandValue = new double[tailTrimByBand.length];
            for (i = 0; i < tailTrimByBand.length; ++i) {
                this.minBandValue[i] = tailTrimByBand[i][0];
                this.maxBandValue[i] = tailTrimByBand[i][1];
            }
        } else {
            this.scale = new double[this.stats.getMin().length];
            this.offset = new double[this.stats.getMin().length];
            if (this.removeEnds) {
                if (this.raster.getDataType() == 0) {
                    this.minBandValue = this.stats.getSecondMinByteUnsigned();
                    this.maxBandValue = this.stats.getSecondMaxByteUnsigned();
                } else {
                    this.minBandValue = this.stats.getSecondMin();
                    this.maxBandValue = this.stats.getSecondMax();
                }
            } else if (this.raster.getDataType() == 0) {
                this.minBandValue = this.stats.getMinByteUnsigned();
                this.maxBandValue = this.stats.getMaxByteUnsigned();
            } else {
                this.minBandValue = this.stats.getMin();
                this.maxBandValue = this.stats.getMax();
            }
        }
        for (i = 0; i < this.minBandValue.length; ++i) {
            this.scale[i] = 255.0 / (this.maxBandValue[i] - this.minBandValue[i]);
            this.offset[i] = 255.0 * this.minBandValue[i] / (this.minBandValue[i] - this.maxBandValue[i]);
        }
        this.nbands = this.stats.getBandCount();
        this.createBufferResult(0, this.raster.getBandCount());
    }

    public Boolean getRemoveEnds() {
        return new Boolean(this.removeEnds);
    }

    public Double getTailTrim() {
        return new Double(this.tailTrim);
    }

    public int getOutRasterDataType() {
        return 0;
    }

    public String getGroup() {
        return "radiometricos";
    }

    public Params getUIParams(String nameFilter) {
        ParamsImpl params = new ParamsImpl();
        params.setParam("RemoveEnds", new Boolean(this.removeEnds), 1, null);
        params.setParam("TailTrim", new Double(Math.round(this.tailTrim * 100.0)), 3, new String[]{"0", "100", "0", "1", "25"});
        return params;
    }

    public void post() {
        this.raster = null;
    }

    public int getInRasterDataType() {
        return 0;
    }

    public void process(int x, int y) {
    }

    public String[] getNames() {
        return names;
    }

    public boolean isVisible() {
        return true;
    }
}

