/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.enhancement;

import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FileNotOpenException;
import org.gvsig.fmap.dal.coverage.exception.FilterAddException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.grid.filter.BaseRasterFilter;
import org.gvsig.fmap.dal.coverage.store.props.ColorInterpretation;
import org.gvsig.fmap.dal.coverage.store.props.Statistics;
import org.gvsig.raster.impl.datastruct.DefaultStretch;
import org.gvsig.raster.impl.grid.filter.enhancement.DefaultLinearStretchParams;
import org.gvsig.raster.impl.store.ParamsImpl;

public class LinearStretchEnhancementFilter
extends BaseRasterFilter {
    protected double[][] scale = null;
    protected double[][] offset = null;
    protected Statistics stats = null;
    protected double[] minBandValue = null;
    protected double[] maxBandValue = null;
    public static String[] names = new String[]{"enhanced_stretch"};
    private boolean removeEnds = false;
    protected DefaultLinearStretchParams stretchs = null;
    protected DefaultStretch[] scaleOffsetList = null;
    protected int[] renderBands = null;

    public LinearStretchEnhancementFilter() {
        this.setName(names[0]);
    }

    public void pre() throws FilterAddException {
        super.pre();
        this.stats = (Statistics)this.getEnv().get("SrcStatistics");
        this.stretchs = (DefaultLinearStretchParams)this.params.get("stretchs");
        if (this.params.get("remove") != null) {
            this.removeEnds = (Boolean)this.params.get("remove");
        }
        if (this.stretchs == null) {
            return;
        }
        try {
            this.stats.calculate(RasterLibrary.statisticsScale);
        }
        catch (FileNotOpenException e) {
            this.exec = false;
        }
        catch (RasterDriverException e) {
            this.exec = false;
        }
        catch (ProcessInterruptedException e) {
            this.exec = false;
        }
        if (this.raster.getDataType() != 0) {
            this.stretchs.rgb = false;
        }
        ColorInterpretation outputColorInterp = this.getColorInterpretation();
        this.renderBands = outputColorInterp.buildRenderBands();
        this.stretchs.setMaxMin(this.stats, this.renderBands);
        if (this.removeEnds) {
            this.stretchs.applyRemoveEndsToStretchs(this.stats, this.renderBands);
        }
        this.stretchs.loadTailTrimValues(this.stats);
        if (this.stretchs.hasTailTrim()) {
            this.stretchs.applyTrimToStretchs();
        }
        this.stretchs.calcLinearScaleAndOffset();
        this.loadStretchList();
        this.createBufferResult(0, this.raster.getBandCount());
    }

    private void loadStretchList() {
        this.scaleOffsetList = new DefaultStretch[3];
        this.scaleOffsetList[0] = this.stretchs.red;
        this.scaleOffsetList[1] = this.stretchs.green;
        this.scaleOffsetList[2] = this.stretchs.blue;
    }

    public Double getTailTrim() {
        double[] tailTrimList = this.stretchs != null ? this.stretchs.getTailTrimList() : new double[]{};
        double median = 0.0;
        double nValues = tailTrimList.length;
        for (int i = 0; i < tailTrimList.length; ++i) {
            median += tailTrimList[i];
        }
        return new Double(nValues > 0.0 ? median / nValues : median);
    }

    public boolean isToConvertToRGB() {
        return true;
    }

    public int getOutRasterDataType() {
        return 0;
    }

    public Boolean getRemoveEnds() {
        return new Boolean(this.removeEnds);
    }

    public String getGroup() {
        return "radiometricos";
    }

    public Params getUIParams(String nameFilter) {
        if (this.stretchs == null) {
            this.stretchs = (DefaultLinearStretchParams)this.params.get("stretchs");
        }
        ParamsImpl params = new ParamsImpl();
        params.setParam("TailTrim", new Double(Math.round(this.getTailTrim() * 100.0)), 3, new String[]{"0", "100", "0", "1", "25"});
        params.setParam("StretchInRed", this.stretchs.red.stretchIn, 2, null);
        params.setParam("StretchInGreen", this.stretchs.green.stretchIn, 2, null);
        params.setParam("StretchInBlue", this.stretchs.blue.stretchIn, 2, null);
        params.setParam("StretchOutRed", this.stretchs.red.stretchOut, 2, null);
        params.setParam("StretchOutGreen", this.stretchs.green.stretchOut, 2, null);
        params.setParam("StretchOutBlue", this.stretchs.blue.stretchOut, 2, null);
        params.setParam("TailTrimRedMin", new Double(this.stretchs.red.tailTrimMin), 2, null);
        params.setParam("TailTrimRedMax", new Double(this.stretchs.red.tailTrimMax), 2, null);
        params.setParam("TailTrimGreenMin", new Double(this.stretchs.green.tailTrimMin), 2, null);
        params.setParam("TailTrimGreenMax", new Double(this.stretchs.green.tailTrimMax), 2, null);
        params.setParam("TailTrimBlueMin", new Double(this.stretchs.blue.tailTrimMin), 2, null);
        params.setParam("TailTrimBlueMax", new Double(this.stretchs.blue.tailTrimMax), 2, null);
        params.setParam("RedMaxValue", new Double(this.stretchs.red.maxValue), 2, null);
        params.setParam("RedMinValue", new Double(this.stretchs.red.minValue), 2, null);
        params.setParam("GreenMaxValue", new Double(this.stretchs.green.maxValue), 2, null);
        params.setParam("GreenMinValue", new Double(this.stretchs.green.minValue), 2, null);
        params.setParam("BlueMaxValue", new Double(this.stretchs.blue.maxValue), 2, null);
        params.setParam("BlueMinValue", new Double(this.stretchs.blue.minValue), 2, null);
        params.setParam("TailTrimRedValueMax", new Double(this.stretchs.red.tailTrimValueMax), 2, null);
        params.setParam("TailTrimRedValueMin", new Double(this.stretchs.red.tailTrimValueMin), 2, null);
        params.setParam("TailTrimGreenValueMax", new Double(this.stretchs.green.tailTrimValueMax), 2, null);
        params.setParam("TailTrimGreenValueMin", new Double(this.stretchs.green.tailTrimValueMin), 2, null);
        params.setParam("TailTrimBlueValueMax", new Double(this.stretchs.blue.tailTrimValueMax), 2, null);
        params.setParam("TailTrimBlueValueMin", new Double(this.stretchs.blue.tailTrimValueMin), 2, null);
        params.setParam("RedOffset", this.stretchs.red.offset, 2, null);
        params.setParam("GreenOffset", this.stretchs.green.offset, 2, null);
        params.setParam("BlueOffset", this.stretchs.blue.offset, 2, null);
        params.setParam("RedScale", this.stretchs.red.scale, 2, null);
        params.setParam("GreenScale", this.stretchs.green.scale, 2, null);
        params.setParam("BlueScale", this.stretchs.blue.scale, 2, null);
        params.setParam("Remove", new Boolean(this.removeEnds), 2, null);
        params.setParam("RGB", new Boolean(this.stretchs.rgb), -1, null);
        return params;
    }

    public void post() {
        this.raster = null;
    }

    public int getInRasterDataType() {
        return 0;
    }

    public void process(int x, int y) {
    }

    public String[] getNames() {
        return names;
    }

    public boolean isVisible() {
        return false;
    }

    public DefaultLinearStretchParams getStretchs() {
        return this.stretchs;
    }
}

