/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.segmentation;

import org.gvsig.raster.impl.datastruct.Kernel;
import org.gvsig.raster.impl.grid.filter.segmentation.FirstDerivativeFilter;

public class FirstDerivativeIntegerFilter
extends FirstDerivativeFilter {
    @Override
    public void process(int col, int line) {
        int[] convoResult = new int[4];
        int ladoVentana = 3;
        int semiLado = ladoVentana - 1 >> 1;
        double[][] ventana = new double[ladoVentana][ladoVentana];
        Kernel kernel = null;
        for (int band = 0; band < this.nBandsToProcess; ++band) {
            if (col - semiLado >= 0 && line - semiLado >= 0 && col + semiLado < this.width && line + semiLado < this.height) {
                for (int j = -semiLado; j <= semiLado; ++j) {
                    for (int i = -semiLado; i <= semiLado; ++i) {
                        ventana[i + semiLado][j + semiLado] = this.raster.getElemInt(line + j, col + i, band) & 0xFFFFFFFF;
                    }
                }
                kernel = new Kernel(ventana);
                convoResult[0] = (int)this.operatorH.convolution(kernel);
                convoResult[1] = (int)this.operatorV.convolution(kernel);
                int out = this.compare ? (convoResult[0] > convoResult[1] ? convoResult[0] : convoResult[1]) : (int)Math.sqrt(Math.pow(convoResult[0], 2.0) + Math.pow(convoResult[1], 2.0));
                if (this.umbral > 0) {
                    out = out >= 255 - this.umbral ? 255 : 0;
                } else if (out < 0) {
                    out = 0;
                } else if (out > 255) {
                    out = 255;
                }
                this.rasterResult.setElem(line, col, band, (byte)out);
                continue;
            }
            this.rasterResult.setElem(line, col, band, (byte)this.raster.getElemInt(line, col, band));
        }
        if (this.hasTransparency) {
            this.rasterResult.setElem(line, col, this.rasterResult.getBandCount() - 1, this.raster.getElemInt(line, col, this.raster.getBandCount() - 1));
        }
    }

    @Override
    public int getInRasterDataType() {
        return 3;
    }
}

