/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.render;

import java.awt.geom.Point2D;
import org.cresques.cts.ICoordTrans;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.QueryException;
import org.gvsig.fmap.dal.coverage.exception.WarpException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.RasterQuery;
import org.gvsig.raster.impl.DefaultRasterManager;
import org.gvsig.timesupport.Time;
import org.gvsig.tools.task.TaskStatus;

public class RasterRenderReprojection {
    public Buffer warp(RasterDataStore store, ICoordTrans coordTrans, Extent bbox, int w, int h, Time time, int[] renderBands, TaskStatus status) throws WarpException {
        Buffer sourceBuffer;
        Point2D.Double ul = new Point2D.Double(bbox.getULX(), bbox.getULY());
        Point2D.Double lr = new Point2D.Double(bbox.getLRX(), bbox.getLRY());
        Extent newBbox = RasterLocator.getManager().getDataStructFactory().createExtent((Point2D)ul, (Point2D)lr);
        newBbox = bbox.convert(coordTrans.getInverted());
        double[] size = this.getSize(bbox, newBbox, w, h);
        RasterQuery query = DefaultRasterManager.getInstance().createQuery();
        query.setTaskStatus(status);
        query.setTime(time);
        query.setSupersamplingOption(false);
        query.forceARGBRequest();
        query.setAreaOfInterest(newBbox, (int)size[0], (int)size[1]);
        query.setDrawableBands(renderBands);
        try {
            sourceBuffer = store.query(query);
        }
        catch (ProcessInterruptedException | QueryException e) {
            throw new WarpException(String.format("Can not query %1s store. [area of interest: %2s width %3s height %4s]", store.getName(), newBbox, (int)size[0], (int)size[1]), e);
        }
        return sourceBuffer.project(coordTrans.getInverted(), bbox, w, h);
    }

    private double[] getSize(Extent bbox, Extent newBbox, int p1x, int p1y) {
        double sumSideOldBBox = bbox.width() + bbox.height();
        double sumSideNewBBox = newBbox.width() + newBbox.height();
        double d1x = bbox.width() * 100.0 / sumSideOldBBox;
        double d1y = bbox.height() * 100.0 / sumSideOldBBox;
        double d2x = newBbox.width() * 100.0 / sumSideNewBBox;
        double d2y = newBbox.height() * 100.0 / sumSideNewBBox;
        double p2y = (double)p1y * d2y / d1y;
        double p2x = (double)p1x * d2x / d1x;
        double newCellSize = newBbox.width() / p2x;
        return new double[]{Math.round(p2x), Math.round(p2y), newCellSize};
    }
}

