/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.store.properties;

import java.util.ArrayList;
import java.util.Hashtable;
import org.gvsig.fmap.dal.coverage.exception.GridException;
import org.gvsig.fmap.dal.coverage.store.props.Statistics;
import org.gvsig.tools.dynobject.DynStruct;

public abstract class AbstractStatistics
implements Statistics {
    protected boolean complete = false;
    protected double[] max = null;
    protected double[] min = null;
    protected double[] secondMax = null;
    protected double[] secondMin = null;
    protected double[] maxByteUnsigned = null;
    protected double[] minByteUnsigned = null;
    protected double[] secondMaxByteUnsigned = null;
    protected double[] secondMinByteUnsigned = null;
    protected double[] mean = null;
    protected double[] variance = null;
    protected long[] nValues = null;
    protected boolean calculated = false;
    protected Hashtable<String, Object> tailTrim = null;
    protected ArrayList<String> tailTrimValues = null;
    protected int bandCount = 0;

    public AbstractStatistics() {
        if (this.tailTrim == null) {
            this.tailTrim = new Hashtable();
        }
        if (this.tailTrimValues == null) {
            this.tailTrimValues = new ArrayList();
        }
    }

    public static void registerPersistent(DynStruct definition) {
        definition.addDynFieldList("tailTrimValues").setClassOfItems(String.class).setMandatory(false);
        definition.addDynFieldBoolean("calculated").setMandatory(false);
        definition.addDynFieldBoolean("complete").setMandatory(false);
        definition.addDynFieldList("nValues").setClassOfItems(Long.TYPE).setMandatory(false);
        definition.addDynFieldList("variance").setClassOfItems(Double.TYPE).setMandatory(false);
        definition.addDynFieldList("mean").setClassOfItems(Double.TYPE).setMandatory(false);
        definition.addDynFieldList("secondMinByteUnsigned").setClassOfItems(Double.TYPE).setMandatory(false);
        definition.addDynFieldList("secondMaxByteUnsigned").setClassOfItems(Double.TYPE).setMandatory(false);
        definition.addDynFieldList("minByteUnsigned").setClassOfItems(Double.TYPE).setMandatory(false);
        definition.addDynFieldList("maxByteUnsigned").setClassOfItems(Double.TYPE).setMandatory(false);
        definition.addDynFieldList("secondMin").setClassOfItems(Double.TYPE).setMandatory(false);
        definition.addDynFieldList("secondMax").setClassOfItems(Double.TYPE).setMandatory(false);
        definition.addDynFieldList("min").setClassOfItems(Double.TYPE).setMandatory(false);
        definition.addDynFieldList("max").setClassOfItems(Double.TYPE).setMandatory(false);
    }

    public void setNumberOfValues(long[] values) {
        this.nValues = values;
    }

    public long[] getNumberOfValues() {
        return this.nValues;
    }

    public void setMax(double[] max) {
        this.max = max;
    }

    public void setSecondMax(double[] smax) {
        this.secondMax = smax;
    }

    public void setMaxRGB(double[] max) {
        this.maxByteUnsigned = max;
    }

    public void setSecondMaxRGB(double[] smax) {
        this.secondMaxByteUnsigned = smax;
    }

    public void setMean(double[] mean) {
        this.mean = mean;
    }

    public void setMin(double[] min) {
        this.min = min;
    }

    public void setSecondMin(double[] smin) {
        this.secondMin = smin;
    }

    public void setMinRGB(double[] min) {
        this.minByteUnsigned = min;
    }

    public void setSecondMinRGB(double[] smin) {
        this.secondMinByteUnsigned = smin;
    }

    public void setVariance(double[] variance) {
        this.variance = variance;
    }

    public double[] getMin() {
        return this.min;
    }

    public double[] getMax() {
        return this.max;
    }

    public double[] getSecondMax() {
        return this.secondMax;
    }

    public double[] getSecondMin() {
        return this.secondMin;
    }

    public double[] getMinByteUnsigned() {
        return this.minByteUnsigned;
    }

    public double[] getMaxByteUnsigned() {
        return this.maxByteUnsigned;
    }

    public double[] getSecondMaxByteUnsigned() {
        return this.secondMaxByteUnsigned;
    }

    public double[] getSecondMinByteUnsigned() {
        return this.secondMinByteUnsigned;
    }

    public double getMaximun() {
        double m = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.max.length; ++i) {
            m = Math.max(m, this.max[i]);
        }
        return m;
    }

    public double getMinimun() {
        double m = Double.MAX_VALUE;
        for (int i = 0; i < this.min.length; ++i) {
            m = Math.min(m, this.min[i]);
        }
        return m;
    }

    public double getMaximunByteUnsigned() {
        double m = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.maxByteUnsigned.length; ++i) {
            m = Math.max(m, this.maxByteUnsigned[i]);
        }
        return m;
    }

    public double getMinimunByteUnsigned() {
        double m = Double.MAX_VALUE;
        for (int i = 0; i < this.minByteUnsigned.length; ++i) {
            m = Math.min(m, this.minByteUnsigned[i]);
        }
        return m;
    }

    public double[] getMean() {
        return this.mean;
    }

    public double[] getVariance() {
        return this.variance;
    }

    public boolean isCalculated() {
        return this.calculated;
    }

    public void setCalculated(boolean calc) {
        this.calculated = calc;
    }

    public void setTailTrimValue(double percent, Object valueByBand) {
        this.tailTrim.put(percent + "", valueByBand);
        for (int i = 0; i < this.tailTrimValues.size(); ++i) {
            if (!this.tailTrimValues.get(i).equals(percent + "")) continue;
            this.tailTrimValues.set(i, percent + "");
            return;
        }
        this.tailTrimValues.add(percent + "");
    }

    public Object getTailTrimValue(double percent) {
        return this.tailTrim.get(percent + "");
    }

    public Object[] getTailTrimValue(int pos) {
        return new Object[]{Double.parseDouble(this.tailTrimValues.get(pos) + ""), this.tailTrim.get(this.tailTrimValues.get(pos))};
    }

    public int getTailTrimCount() {
        return this.tailTrimValues.size();
    }

    public abstract void resetPercent();

    public abstract int getPercent();

    public abstract int getBandCount();

    public abstract void setBandCount(int var1);

    public boolean isAdvancedStatisticsCalculated() {
        return false;
    }

    public void calculateAdvanced() throws GridException {
    }

    public long[] getNumberOfCells() {
        return null;
    }

    public double[][] getVarianceCovarianceMatrix() {
        return null;
    }

    public Statistics cloneStatistics(AbstractStatistics s) {
        s.setMax(this.getMax());
        s.setMin(this.getMin());
        s.setSecondMax(this.getSecondMax());
        s.setSecondMin(this.getSecondMin());
        s.setVariance(this.getVariance());
        s.setMean(this.getMean());
        s.setCalculated(this.calculated);
        s.tailTrim = this.tailTrim;
        s.tailTrimValues = this.tailTrimValues;
        return s;
    }

    protected void finalize() {
        this.max = null;
        this.min = null;
        this.secondMax = null;
        this.secondMin = null;
        this.maxByteUnsigned = null;
        this.minByteUnsigned = null;
        this.secondMaxByteUnsigned = null;
        this.secondMinByteUnsigned = null;
        this.mean = null;
        this.variance = null;
        this.nValues = null;
    }
}

