/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.store.properties;

import java.util.ArrayList;
import org.gvsig.fmap.dal.coverage.datastruct.TransparencyRange;
import org.gvsig.fmap.dal.coverage.store.props.Metadata;
import org.gvsig.raster.impl.datastruct.TransparencyRangeImpl;
import org.gvsig.raster.impl.store.properties.DataStoreColorInterpretation;

public class DataStoreMetadata
implements Metadata {
    private ArrayList<String> metadata = new ArrayList();
    private ArrayList<String> values = new ArrayList();
    protected double[] noDataByBand = null;
    protected boolean noDataEnabled = false;
    protected String[] metadataString = null;
    protected DataStoreColorInterpretation colorInterpr = null;

    public DataStoreMetadata(String[] metadata, DataStoreColorInterpretation colorInterpr) {
        this.colorInterpr = colorInterpr;
        if (metadata == null) {
            return;
        }
        this.metadataString = metadata;
        for (int i = 0; i < metadata.length; ++i) {
            String[] value = metadata[i].split("=");
            if (value.length < 2) continue;
            this.metadata.add(value[0]);
            this.values.add(value[1]);
        }
    }

    public TransparencyRange parserNodataByBand() {
        int bandR = this.colorInterpr.getBand("Red");
        int bandG = this.colorInterpr.getBand("Green");
        int bandB = this.colorInterpr.getBand("Blue");
        if (bandR < 0 && bandG < 0 && bandB < 0) {
            return null;
        }
        if (this.colorInterpr.length() == 1 && this.colorInterpr.get(0).equals("Palette")) {
            return null;
        }
        if (this.noDataByBand == null) {
            return null;
        }
        int count = 0;
        for (int i = 0; i < this.noDataByBand.length; ++i) {
            if (!(this.noDataByBand[i] < 0.0)) continue;
            ++count;
        }
        if (count == this.noDataByBand.length) {
            return null;
        }
        TransparencyRangeImpl tr = new TransparencyRangeImpl();
        int[] red = new int[2];
        int[] green = new int[2];
        int[] blue = new int[2];
        if (bandR >= 0) {
            red[0] = red[1] = (int)this.noDataByBand[bandR];
            tr.setRed(red);
        }
        if (bandG >= 0) {
            green[0] = green[1] = (int)this.noDataByBand[bandG];
            tr.setGreen(green);
        }
        if (bandB >= 0) {
            blue[0] = blue[1] = (int)this.noDataByBand[bandB];
            tr.setBlue(blue);
        }
        tr.setAnd(true);
        tr.loadStrEntryFromValues();
        return tr;
    }

    public TransparencyRange[] parserNodataInMetadata() {
        if (this.colorInterpr.length() == 1 && this.colorInterpr.get(0).equals("Palette")) {
            return null;
        }
        int count = 0;
        for (int i = 0; i < this.metadata.size(); ++i) {
            if (!this.metadata.get(i).equals("NODATA_VALUES")) continue;
            ++count;
        }
        if (count == 0) {
            return null;
        }
        TransparencyRange[] trList = new TransparencyRange[count];
        count = 0;
        for (int i = 0; i < this.metadata.size(); ++i) {
            TransparencyRangeImpl tr = new TransparencyRangeImpl();
            int[] red = new int[2];
            int[] green = new int[2];
            int[] blue = new int[2];
            if (this.metadata.get(i).equals("NODATA_VALUES")) {
                String data = this.values.get(i);
                String[] dataValues = data.split(" ");
                try {
                    red[0] = red[1] = Integer.parseInt(dataValues[0]);
                    green[0] = green[1] = Integer.parseInt(dataValues[1]);
                    blue[0] = blue[1] = Integer.parseInt(dataValues[2]);
                }
                catch (NumberFormatException exc) {
                    return null;
                }
            }
            tr.setAnd(true);
            tr.setRed(red);
            tr.setGreen(green);
            tr.setBlue(blue);
            tr.loadStrEntryFromValues();
            trList[count] = tr;
            ++count;
        }
        return trList;
    }

    public void initNoDataByBand(int values) {
        this.noDataByBand = new double[values];
        for (int i = 0; i < values; ++i) {
            this.noDataByBand[i] = -1.0;
        }
    }

    public void setNoDataValue(int band, double value) {
        try {
            this.noDataByBand[band] = value;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public double getNoDataValue(int band) {
        return this.noDataByBand[band];
    }

    public double[] getNoDataValue() {
        return this.noDataByBand;
    }

    public String[] getMetadataString() {
        return this.metadataString;
    }

    public boolean isNoDataEnabled() {
        return this.noDataEnabled;
    }

    public void setNoDataEnabled(boolean noDataEnabled) {
        this.noDataEnabled = noDataEnabled;
    }

    protected void finalize() throws Throwable {
        this.metadataString = null;
        this.noDataByBand = null;
        if (this.values != null) {
            this.values.clear();
            this.values = null;
        }
        if (this.metadata != null) {
            this.metadata.clear();
            this.metadata = null;
        }
    }
}

