/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.store.properties;

import java.util.ArrayList;
import org.gvsig.fmap.dal.coverage.store.props.Metadata;

public class MultiDataStoreMetadata
extends ArrayList<Metadata>
implements Metadata {
    private static final long serialVersionUID = 1L;
    private int[] nBand = null;

    public MultiDataStoreMetadata(int[] bands) {
        this.nBand = bands;
    }

    public void initNoDataByBand(int values) {
        if (this.size() != this.nBand.length) {
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            ((Metadata)this.get(i)).initNoDataByBand(this.nBand[i]);
        }
    }

    public void setNoDataValue(int band, double value) {
        if (this.size() != this.nBand.length) {
            return;
        }
        int acc = 0;
        int bandParcial = band;
        for (int i = 0; i < this.size(); ++i) {
            if (band < (acc += this.nBand[i])) {
                ((Metadata)this.get(i)).setNoDataValue(bandParcial, value);
                return;
            }
            bandParcial -= this.nBand[i];
        }
    }

    public double getNoDataValue(int band) {
        if (this.size() != this.nBand.length) {
            return 0.0;
        }
        int acc = 0;
        int bandParcial = band;
        for (int i = 0; i < this.size(); ++i) {
            if (band < (acc += this.nBand[i])) {
                return ((Metadata)this.get(i)).getNoDataValue(bandParcial);
            }
            bandParcial -= this.nBand[i];
        }
        return 0.0;
    }

    public double[] getNoDataValue() {
        if (this.size() != this.nBand.length) {
            return null;
        }
        int bandCount = 0;
        for (int i = 0; i < this.size(); ++i) {
            bandCount += this.nBand[i];
        }
        int cont = 0;
        double[] res = new double[bandCount];
        for (int i = 0; i < this.size(); ++i) {
            double[] p = ((Metadata)this.get(i)).getNoDataValue();
            for (int j = 0; j < p.length; ++j) {
                res[cont] = p[j];
                ++cont;
            }
        }
        return res;
    }

    public String[] getMetadataString() {
        if (this.size() != this.nBand.length) {
            return null;
        }
        int bandCount = 0;
        for (int i = 0; i < this.size(); ++i) {
            bandCount += this.nBand[i];
        }
        int cont = 0;
        String[] res = new String[bandCount];
        for (int i = 0; i < this.size(); ++i) {
            String[] p = ((Metadata)this.get(i)).getMetadataString();
            for (int j = 0; j < p.length; ++j) {
                res[cont] = p[j];
                ++cont;
            }
        }
        return res;
    }

    public boolean isNoDataEnabled() {
        if (this.size() != this.nBand.length) {
            return true;
        }
        return ((Metadata)this.get(0)).isNoDataEnabled();
    }

    public void setNoDataEnabled(boolean noDataEnabled) {
        if (this.size() != this.nBand.length) {
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            ((Metadata)this.get(i)).setNoDataEnabled(noDataEnabled);
        }
    }
}

