/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.store.properties;

import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.BufferHistogram;
import org.gvsig.fmap.dal.coverage.exception.HistogramException;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterDataParameters;
import org.gvsig.fmap.dal.coverage.store.parameter.RemoteStoreParameters;
import org.gvsig.fmap.dal.coverage.store.props.HistogramComputer;
import org.gvsig.fmap.dal.coverage.util.ProviderServices;
import org.gvsig.fmap.dal.exception.CloseException;
import org.gvsig.raster.impl.provider.RemoteRasterProvider;
import org.gvsig.raster.impl.store.properties.MultiProviderHistogramComputer;
import org.gvsig.tools.locator.LocatorException;

public class RemoteStoreHistogram
extends MultiProviderHistogramComputer {
    private RemoteRasterProvider provider = null;
    private HistogramComputer lastBufferHistogram = null;

    public RemoteStoreHistogram(RemoteRasterProvider prov) {
        super(prov);
        this.provider = prov;
    }

    @Override
    public BufferHistogram getBufferHistogram() throws ProcessInterruptedException, HistogramException {
        if (((RemoteStoreParameters)this.provider.getDataParameters()).isSizeFixed()) {
            return super.getBufferHistogram();
        }
        ProviderServices provServ = RasterLocator.getManager().getProviderServices();
        RasterDataParameters storeParameters = provServ.createParameters(this.provider.getLastRequest().getPath());
        storeParameters.setSRS(this.provider.getProjection());
        try {
            RasterDataStore mrs = RasterLocator.getManager().getProviderServices().open((DataStoreParameters)storeParameters);
            this.lastBufferHistogram = mrs.getHistogramComputer();
            BufferHistogram bh = this.lastBufferHistogram.getBufferHistogram();
            mrs.close();
            return bh;
        }
        catch (LocatorException e) {
            throw new HistogramException(e.getMessage(), (Throwable)e);
        }
        catch (NotSupportedExtensionException e) {
            throw new HistogramException(e.getMessage(), (Throwable)e);
        }
        catch (RasterDriverException e) {
            throw new HistogramException(e.getMessage(), (Throwable)e);
        }
        catch (CloseException e) {
            throw new HistogramException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void resetPercent() {
        if (((RemoteStoreParameters)this.provider.getDataParameters()).isSizeFixed()) {
            super.resetPercent();
        } else if (this.lastBufferHistogram != null) {
            this.lastBufferHistogram.resetPercent();
        }
    }

    @Override
    public int getPercent() {
        if (((RemoteStoreParameters)this.provider.getDataParameters()).isSizeFixed()) {
            return super.getPercent();
        }
        if (this.lastBufferHistogram != null) {
            return this.lastBufferHistogram.getPercent();
        }
        return 0;
    }

    @Override
    public double getMaximum() {
        if (((RemoteStoreParameters)this.provider.getDataParameters()).isSizeFixed()) {
            return super.getMaximum();
        }
        ProviderServices provServ = RasterLocator.getManager().getProviderServices();
        RasterDataParameters storeParameters = provServ.createParameters(this.provider.getLastRequest().getPath());
        storeParameters.setSRS(this.provider.getProjection());
        try {
            RasterDataStore mrs = RasterLocator.getManager().getProviderServices().open((DataStoreParameters)storeParameters);
            double res = mrs.getHistogramComputer().getMaximum();
            mrs.close();
            return res;
        }
        catch (LocatorException e) {
            return 0.0;
        }
        catch (NotSupportedExtensionException e) {
            return 0.0;
        }
        catch (RasterDriverException e) {
            return 0.0;
        }
        catch (CloseException e) {
            return 0.0;
        }
    }

    @Override
    public double getMinimum() {
        if (((RemoteStoreParameters)this.provider.getDataParameters()).isSizeFixed()) {
            return super.getMinimum();
        }
        ProviderServices provServ = RasterLocator.getManager().getProviderServices();
        RasterDataParameters storeParameters = provServ.createParameters(this.provider.getLastRequest().getPath());
        storeParameters.setSRS(this.provider.getProjection());
        try {
            RasterDataStore mrs = RasterLocator.getManager().getProviderServices().open((DataStoreParameters)storeParameters);
            double res = mrs.getHistogramComputer().getMinimum();
            mrs.close();
            return res;
        }
        catch (LocatorException e) {
            return 0.0;
        }
        catch (NotSupportedExtensionException e) {
            return 0.0;
        }
        catch (RasterDriverException e) {
            return 0.0;
        }
        catch (CloseException e) {
            return 0.0;
        }
    }
}

