/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.store.properties;

import java.util.List;
import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.exception.FileNotOpenException;
import org.gvsig.fmap.dal.coverage.exception.InvalidSetViewException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.exception.RmfSerializerException;
import org.gvsig.fmap.dal.coverage.store.props.Statistics;
import org.gvsig.raster.impl.process.RasterTask;
import org.gvsig.raster.impl.process.RasterTaskQueue;
import org.gvsig.raster.impl.provider.RasterProvider;
import org.gvsig.raster.impl.store.properties.AbstractStatistics;

public class SimpleProviderStatistics
extends AbstractStatistics {
    protected RasterProvider provider = null;
    protected int percent = 0;
    protected boolean forceToRecalc = false;

    public SimpleProviderStatistics(RasterProvider prov) {
        this.provider = prov;
        if (this.provider != null) {
            this.bandCount = this.provider.getBandCount();
        }
    }

    public SimpleProviderStatistics() {
    }

    public RasterProvider getDataProvider() {
        return this.provider;
    }

    @Override
    public void setMax(double[] max) {
        this.max = max;
    }

    @Override
    public void setSecondMax(double[] smax) {
        this.secondMax = smax;
    }

    @Override
    public void setMaxRGB(double[] max) {
        this.maxByteUnsigned = max;
    }

    @Override
    public void setSecondMaxRGB(double[] smax) {
        this.secondMaxByteUnsigned = smax;
    }

    @Override
    public void setMean(double[] mean) {
        this.mean = mean;
    }

    @Override
    public void setMin(double[] min) {
        this.min = min;
    }

    @Override
    public void setSecondMin(double[] smin) {
        this.secondMin = smin;
    }

    @Override
    public void setMinRGB(double[] min) {
        this.minByteUnsigned = min;
    }

    @Override
    public void setSecondMinRGB(double[] smin) {
        this.secondMinByteUnsigned = smin;
    }

    @Override
    public void setVariance(double[] variance) {
        this.variance = variance;
    }

    @Override
    public double[] getMin() {
        return this.min;
    }

    @Override
    public double[] getMax() {
        return this.max;
    }

    @Override
    public double[] getSecondMax() {
        return this.secondMax;
    }

    @Override
    public double[] getSecondMin() {
        return this.secondMin;
    }

    @Override
    public double[] getMinByteUnsigned() {
        return this.minByteUnsigned;
    }

    @Override
    public double[] getMaxByteUnsigned() {
        return this.maxByteUnsigned;
    }

    @Override
    public double[] getSecondMaxByteUnsigned() {
        return this.secondMaxByteUnsigned;
    }

    @Override
    public double[] getSecondMinByteUnsigned() {
        return this.secondMinByteUnsigned;
    }

    @Override
    public double getMaximun() {
        double m = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.max.length; ++i) {
            m = Math.max(m, this.max[i]);
        }
        return m;
    }

    @Override
    public double getMinimun() {
        double m = Double.MAX_VALUE;
        for (int i = 0; i < this.min.length; ++i) {
            m = Math.min(m, this.min[i]);
        }
        return m;
    }

    @Override
    public double getMaximunByteUnsigned() {
        double m = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.maxByteUnsigned.length; ++i) {
            m = Math.max(m, this.maxByteUnsigned[i]);
        }
        return m;
    }

    @Override
    public double getMinimunByteUnsigned() {
        double m = Double.MAX_VALUE;
        for (int i = 0; i < this.minByteUnsigned.length; ++i) {
            m = Math.min(m, this.minByteUnsigned[i]);
        }
        return m;
    }

    @Override
    public double[] getMean() {
        return this.mean;
    }

    @Override
    public double[] getVariance() {
        return this.variance;
    }

    @Override
    public int getBandCount() {
        return this.bandCount;
    }

    @Override
    public void setBandCount(int bandCount) {
        this.bandCount = bandCount;
    }

    public void calculate(double scale) throws FileNotOpenException, RasterDriverException, ProcessInterruptedException {
        if (this.provider == null) {
            return;
        }
        RasterTask task = RasterTaskQueue.get(Thread.currentThread().getId() + "");
        this.percent = 0;
        this.provider.selectSubdataset();
        if (!this.forceToRecalc) {
            if (!this.isCalculated()) {
                try {
                    this.provider.loadObjectFromRmf(SimpleProviderStatistics.class, this);
                }
                catch (RmfSerializerException rmfSerializerException) {
                    // empty catch block
                }
            }
            if (this.isCalculated()) {
                return;
            }
        }
        this.bandCount = this.provider.getBandCount();
        this.max = new double[this.bandCount];
        this.min = new double[this.bandCount];
        this.secondMax = new double[this.bandCount];
        this.secondMin = new double[this.bandCount];
        this.maxByteUnsigned = new double[this.bandCount];
        this.minByteUnsigned = new double[this.bandCount];
        this.secondMaxByteUnsigned = new double[this.bandCount];
        this.secondMinByteUnsigned = new double[this.bandCount];
        this.mean = new double[this.bandCount];
        this.variance = new double[this.bandCount];
        int blockHeight = RasterLibrary.blockHeight;
        this.nValues = new long[this.bandCount];
        boolean[] initializedBand = new boolean[this.bandCount];
        int[] type = new int[this.bandCount];
        byte[][][] b = null;
        short[][][] s = null;
        int[][][] i = null;
        float[][][] f = null;
        double[][][] d = null;
        double z = 0.0;
        double rgb = 0.0;
        for (int iBand = 0; iBand < this.bandCount; ++iBand) {
            this.max[iBand] = Double.NEGATIVE_INFINITY;
            this.min[iBand] = Double.POSITIVE_INFINITY;
            this.secondMax[iBand] = Double.NEGATIVE_INFINITY;
            this.secondMin[iBand] = Double.POSITIVE_INFINITY;
            this.maxByteUnsigned[iBand] = 0.0;
            this.minByteUnsigned[iBand] = 255.0;
            this.secondMaxByteUnsigned[iBand] = 0.0;
            this.secondMinByteUnsigned[iBand] = 255.0;
            initializedBand[iBand] = false;
            type[iBand] = this.provider.getDataType()[iBand];
        }
        Buffer refToBuffer = null;
        int height = 0;
        while ((double)height < this.provider.getHeight()) {
            Object buf = null;
            try {
                buf = this.provider.readBlock(height, blockHeight, scale);
                if (buf == null) {
                    return;
                }
                if (buf instanceof Buffer) {
                    refToBuffer = (Buffer)buf;
                    buf = this.getDataFromBuffer(type, (Buffer)buf);
                }
                switch (type[0]) {
                    case 0: {
                        b = (byte[][][])buf;
                        break;
                    }
                    case 2: {
                        s = (short[][][])buf;
                        break;
                    }
                    case 4: {
                        f = (float[][][])buf;
                        break;
                    }
                    case 5: {
                        d = (double[][][])buf;
                        break;
                    }
                    case 3: {
                        i = (int[][][])buf;
                    }
                }
            }
            catch (InvalidSetViewException e) {
                return;
            }
            int h = (int)((double)blockHeight * scale);
            int datasetWidth = (int)(this.provider.getWidth() * scale);
            int datasetHeight = (int)(this.provider.getHeight() * scale);
            int scaledHeight = (int)((double)height * scale);
            if (scaledHeight + h > datasetHeight) {
                h = datasetHeight - scaledHeight;
            }
            for (int iBand = 0; iBand < this.bandCount; ++iBand) {
                for (int col = 0; col < datasetWidth; ++col) {
                    for (int row = 0; row < h; ++row) {
                        double d2 = b != null ? (double)b[iBand][row][col] : (s != null ? (double)s[iBand][row][col] : (d != null ? d[iBand][row][col] : (f != null ? (double)f[iBand][row][col] : (z = i != null ? (double)i[iBand][row][col] : 0.0))));
                        if (this.provider.getNoDataValue().isDefined() && z == this.provider.getNoDataValue().getValue().doubleValue() || Double.isNaN(z) || Double.isInfinite(z)) continue;
                        rgb = 0.0;
                        if (b != null) {
                            rgb = (byte)z & 0xFF;
                            int n = iBand;
                            this.mean[n] = this.mean[n] + rgb;
                            int n2 = iBand;
                            this.variance[n2] = this.variance[n2] + rgb * rgb;
                        } else {
                            int n = iBand;
                            this.mean[n] = this.mean[n] + z;
                            int n3 = iBand;
                            this.variance[n3] = this.variance[n3] + z * z;
                        }
                        int n = iBand;
                        this.nValues[n] = this.nValues[n] + 1L;
                        if (!initializedBand[iBand]) {
                            this.secondMin[iBand] = this.min[iBand];
                            this.secondMax[iBand] = this.max[iBand];
                            this.min[iBand] = z;
                            this.max[iBand] = z;
                            this.secondMinByteUnsigned[iBand] = this.minByteUnsigned[iBand];
                            this.secondMaxByteUnsigned[iBand] = this.maxByteUnsigned[iBand];
                            this.minByteUnsigned[iBand] = rgb;
                            this.maxByteUnsigned[iBand] = rgb;
                            initializedBand[iBand] = true;
                            continue;
                        }
                        if (z < this.secondMin[iBand]) {
                            if (z < this.min[iBand]) {
                                this.secondMin[iBand] = this.min[iBand];
                                this.min[iBand] = z;
                            } else if (z > this.min[iBand]) {
                                this.secondMin[iBand] = z;
                            }
                        }
                        if (z > this.secondMax[iBand]) {
                            if (z > this.max[iBand]) {
                                this.secondMax[iBand] = this.max[iBand];
                                this.max[iBand] = z;
                            } else if (z < this.max[iBand]) {
                                this.secondMax[iBand] = z;
                            }
                        }
                        if (rgb < this.secondMinByteUnsigned[iBand]) {
                            if (rgb < this.minByteUnsigned[iBand]) {
                                this.secondMinByteUnsigned[iBand] = this.minByteUnsigned[iBand];
                                this.minByteUnsigned[iBand] = rgb;
                            } else if (rgb > this.minByteUnsigned[iBand]) {
                                this.secondMinByteUnsigned[iBand] = rgb;
                            }
                        }
                        if (!(rgb > this.secondMaxByteUnsigned[iBand])) continue;
                        if (rgb > this.maxByteUnsigned[iBand]) {
                            this.secondMaxByteUnsigned[iBand] = this.maxByteUnsigned[iBand];
                            this.maxByteUnsigned[iBand] = rgb;
                            continue;
                        }
                        if (!(rgb < this.maxByteUnsigned[iBand])) continue;
                        this.secondMaxByteUnsigned[iBand] = rgb;
                    }
                }
                if (task.getEvent() == null) continue;
                task.manageEvent(task.getEvent());
            }
            this.percent = height * 100 / datasetHeight;
            if (refToBuffer != null && refToBuffer instanceof Buffer) {
                refToBuffer.dispose();
            }
            buf = null;
            height += blockHeight;
        }
        this.percent = 100;
        for (int iBand = 0; iBand < this.bandCount; ++iBand) {
            if (this.nValues[iBand] <= 0L) continue;
            this.mean[iBand] = this.mean[iBand] / (double)this.nValues[iBand];
            this.variance[iBand] = this.variance[iBand] / (double)this.nValues[iBand] - this.mean[iBand] * this.mean[iBand];
        }
        this.calculated = true;
        this.forceToRecalc = false;
        try {
            this.provider.saveObjectToRmf(Statistics.class, this);
        }
        catch (RmfSerializerException rmfSerializerException) {
            // empty catch block
        }
    }

    private Object getDataFromBuffer(int[] type, Buffer buf) {
        byte[][][] b = null;
        short[][][] s = null;
        int[][][] i = null;
        float[][][] f = null;
        double[][][] d = null;
        switch (type[0]) {
            case 0: {
                b = new byte[buf.getBandCount()][buf.getHeight()][0];
                for (int j = 0; j < buf.getHeight(); ++j) {
                    byte[][] line = buf.getLineByte(j);
                    for (int k = 0; k < line.length; ++k) {
                        b[k][j] = line[k];
                    }
                }
                return b;
            }
            case 2: {
                s = new short[buf.getBandCount()][buf.getHeight()][0];
                for (int j = 0; j < buf.getHeight(); ++j) {
                    short[][] line = buf.getLineShort(j);
                    for (int k = 0; k < line.length; ++k) {
                        s[k][j] = line[k];
                    }
                }
                return s;
            }
            case 4: {
                f = new float[buf.getBandCount()][buf.getHeight()][0];
                for (int j = 0; j < buf.getHeight(); ++j) {
                    float[][] line = buf.getLineFloat(j);
                    for (int k = 0; k < line.length; ++k) {
                        f[k][j] = line[k];
                    }
                }
                return f;
            }
            case 5: {
                d = new double[buf.getBandCount()][buf.getHeight()][0];
                for (int j = 0; j < buf.getHeight(); ++j) {
                    double[][] line = buf.getLineDouble(j);
                    for (int k = 0; k < line.length; ++k) {
                        d[k][j] = line[k];
                    }
                }
                return d;
            }
            case 3: {
                i = new int[buf.getBandCount()][buf.getHeight()][0];
                for (int j = 0; j < buf.getHeight(); ++j) {
                    int[][] line = buf.getLineInt(j);
                    for (int k = 0; k < line.length; ++k) {
                        i[k][j] = line[k];
                    }
                }
                return i;
            }
        }
        return null;
    }

    @Override
    public boolean isCalculated() {
        return this.calculated;
    }

    @Override
    public void setCalculated(boolean calc) {
        this.calculated = calc;
    }

    @Override
    public void setTailTrimValue(double percent, Object valueByBand) {
        this.tailTrim.put(percent + "", valueByBand);
        for (int i = 0; i < this.tailTrimValues.size(); ++i) {
            if (!((String)this.tailTrimValues.get(i)).equals(percent + "")) continue;
            this.tailTrimValues.set(i, percent + "");
            return;
        }
        this.tailTrimValues.add(percent + "");
    }

    @Override
    public Object getTailTrimValue(double percent) {
        return this.tailTrim.get(percent + "");
    }

    @Override
    public Object[] getTailTrimValue(int pos) {
        return new Object[]{Double.parseDouble((String)this.tailTrimValues.get(pos) + ""), this.tailTrim.get(this.tailTrimValues.get(pos))};
    }

    @Override
    public int getTailTrimCount() {
        return this.tailTrimValues.size();
    }

    @Override
    public void resetPercent() {
        this.percent = 0;
    }

    @Override
    public int getPercent() {
        return this.percent;
    }

    public void forceToRecalc() {
        this.forceToRecalc = true;
    }

    public static Statistics union(RasterProvider prov, List<RasterProvider> list) {
        SimpleProviderStatistics s = new SimpleProviderStatistics(prov);
        boolean isCalculated = true;
        for (int i = 0; i < list.size(); ++i) {
            double[] mean;
            double[] sminbu;
            double[] smaxbu;
            double[] minbu;
            double[] maxbu;
            double[] smin;
            double[] smax;
            double[] min;
            double[] max;
            Statistics newStat = list.get(i).getStatistics();
            if (!newStat.isCalculated()) {
                isCalculated = false;
            }
            if ((max = s.getMax()) != null) {
                for (int j = 0; j < max.length; ++j) {
                    max[j] = Math.max(max[j], newStat.getMax()[j]);
                }
            }
            if ((min = s.getMin()) != null) {
                for (int j = 0; j < min.length; ++j) {
                    min[j] = Math.min(min[j], newStat.getMin()[j]);
                }
            }
            if ((smax = s.getSecondMax()) != null) {
                for (int j = 0; j < smax.length; ++j) {
                    smax[j] = Math.max(smax[j], newStat.getSecondMax()[j]);
                }
            }
            if ((smin = s.getSecondMin()) != null) {
                for (int j = 0; j < smin.length; ++j) {
                    smin[j] = Math.min(smin[j], newStat.getSecondMin()[j]);
                }
            }
            if ((maxbu = s.getMaxByteUnsigned()) != null) {
                for (int j = 0; j < maxbu.length; ++j) {
                    maxbu[j] = Math.max(maxbu[j], newStat.getMaxByteUnsigned()[j]);
                }
            }
            if ((minbu = s.getMinByteUnsigned()) != null) {
                for (int j = 0; j < minbu.length; ++j) {
                    minbu[j] = Math.min(minbu[j], newStat.getMinByteUnsigned()[j]);
                }
            }
            if ((smaxbu = s.getSecondMaxByteUnsigned()) != null) {
                for (int j = 0; j < smaxbu.length; ++j) {
                    smaxbu[j] = Math.max(smaxbu[j], newStat.getSecondMaxByteUnsigned()[j]);
                }
            }
            if ((sminbu = s.getSecondMinByteUnsigned()) != null) {
                for (int j = 0; j < sminbu.length; ++j) {
                    sminbu[j] = Math.min(sminbu[j], newStat.getSecondMinByteUnsigned()[j]);
                }
            }
            if ((mean = s.getMean()) != null) {
                for (int j = 0; j < mean.length; ++j) {
                    mean[j] = (mean[j] + newStat.getMean()[j]) / 2.0;
                }
            }
            double[] var = s.getVariance();
            long[] values = s.getNumberOfValues();
            if (var == null) continue;
            for (int j = 0; j < var.length; ++j) {
                var[j] = (var[j] + newStat.getVariance()[j]) / (double)(values[j] + newStat.getNumberOfValues()[j]) - mean[j] * mean[j];
            }
        }
        s.setCalculated(isCalculated);
        try {
            prov.saveObjectToRmf(Statistics.class, s);
        }
        catch (RmfSerializerException rmfSerializerException) {
            // empty catch block
        }
        return s;
    }

    public Statistics cloneStatistics() {
        SimpleProviderStatistics s = new SimpleProviderStatistics(this.provider);
        return super.cloneStatistics(s);
    }
}

