/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.store.serializer;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import org.gvsig.fmap.dal.coverage.exception.ParsingException;
import org.gvsig.fmap.dal.coverage.store.props.TimeSeries;
import org.gvsig.raster.impl.datastruct.DefaultSerialInfo;
import org.gvsig.raster.impl.provider.DefaultTimeSerials;
import org.gvsig.raster.impl.store.rmf.ClassSerializer;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class TimeSeriesRmfSerializer
extends ClassSerializer {
    public static final String MAIN_TAG = "TimeSeries";
    public static final String SERIAL = "SerialElement";
    public static final String DESC = "Description";
    public static final String TIMETYPE = "SourceType";
    public static final String DATES = "Dates";
    public static final String DATE = "Date";
    public static final String NAME = "Name";
    private TimeSeries serialInfo = null;

    public static void register() {
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.get("Serializer");
        point.append("Series", "", TimeSeriesRmfSerializer.class);
    }

    public TimeSeriesRmfSerializer(TimeSeries serialInfo) {
        this.serialInfo = serialInfo;
    }

    private void readDate(DefaultSerialInfo tInfo, KXmlParser parser) throws ParseException {
        String d = parser.getText();
        try {
            Double value = new Double(d);
            tInfo.addValue(value);
        }
        catch (NumberFormatException e) {
            tInfo.addValue(d);
        }
    }

    public void parserDates(DefaultSerialInfo tInfo, KXmlParser parser, String parseableTag, String[] errorTags) throws XmlPullParserException, IOException, NumberFormatException, ParsingException, ParseException {
        boolean end = false;
        boolean init = false;
        boolean readDate = false;
        int tag = parser.next();
        while (!end) {
            switch (tag) {
                case 1: {
                    return;
                }
                case 2: {
                    if (parser.getName().compareTo(parseableTag) == 0) {
                        init = true;
                    }
                    if (!init || parser.getName().compareTo(DATE) != 0) break;
                    readDate = true;
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo(parseableTag) != 0) break;
                    end = true;
                    break;
                }
                case 4: {
                    if (!readDate) break;
                    this.readDate(tInfo, parser);
                    readDate = false;
                }
            }
            if (end) continue;
            tag = parser.next();
        }
    }

    public void parserSerial(DefaultSerialInfo tInfo, KXmlParser parser, String xml, int tag) throws XmlPullParserException, IOException, NumberFormatException, ParsingException, ParseException {
        String name = this.parserString(parser, NAME, null);
        String desc = this.parserString(parser, DESC, null);
        String timeType = this.parserString(parser, TIMETYPE, null);
        tInfo.setSerialName(name);
        tInfo.setDescription(desc);
        try {
            tInfo.setTimeType(new Integer(timeType));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.parserDates(tInfo, parser, DATES, null);
    }

    @Override
    public void read(String xml) throws ParsingException {
        DefaultSerialInfo tInfo;
        block15: {
            ArrayList list = new ArrayList();
            tInfo = null;
            boolean init = false;
            boolean tagOk = false;
            boolean end = false;
            KXmlParser parser = new KXmlParser();
            StringReader reader = new StringReader(xml);
            try {
                parser.setInput((Reader)reader);
            }
            catch (XmlPullParserException e) {
                throw new ParsingException(xml);
            }
            try {
                int tag = parser.nextTag();
                if (parser.getEventType() == 1) break block15;
                parser.require(2, null, MAIN_TAG);
                while (tag != 1) {
                    switch (tag) {
                        case 2: {
                            if (parser.getName().compareTo(MAIN_TAG) == 0) {
                                init = true;
                            }
                            if (!init || parser.getName().compareTo(SERIAL) != 0) break;
                            tInfo = new DefaultSerialInfo();
                            tagOk = true;
                            break;
                        }
                        case 3: {
                            if (parser.getName().compareTo(MAIN_TAG) != 0) break;
                            end = true;
                            break;
                        }
                        case 4: {
                            if (!tagOk) break;
                            this.parserSerial(tInfo, parser, xml, tag);
                            tagOk = false;
                        }
                    }
                    if (!end) {
                        tag = parser.next();
                        continue;
                    }
                    break;
                }
            }
            catch (XmlPullParserException e) {
                throw new ParsingException(xml);
            }
            catch (IOException e) {
                throw new ParsingException(xml);
            }
            catch (NumberFormatException e) {
                throw new ParsingException(xml);
            }
            catch (ParseException e) {
                throw new ParsingException(xml);
            }
        }
        ((DefaultTimeSerials)this.serialInfo).addSerialInfo(tInfo);
    }

    @Override
    public String write() {
        StringBuffer b = new StringBuffer();
        DefaultTimeSerials si = (DefaultTimeSerials)this.serialInfo;
        b.append("<TimeSeries>\n");
        for (int i = 0; i < si.getNumberOfSerials(); ++i) {
            DefaultSerialInfo ti = si.getSerial(i);
            b.append("\t<SerialElement>\n");
            this.putProperty(b, NAME, ti.getSerialName(), 2);
            this.putProperty(b, DESC, ti.getDescription(), 2);
            this.putProperty(b, TIMETYPE, ti.getTimeType() + "", 2);
            b.append("\t\t<Dates>\n");
            for (int j = 0; j < ti.getTime().size(); ++j) {
                this.putProperty(b, DATE, ti.getTimeInfo(j), 3);
            }
            b.append("\t\t</Dates>\n");
            b.append("\t</SerialElement>\n");
        }
        b.append("</TimeSeries>\n");
        return b.toString();
    }

    @Override
    public Object getResult() {
        return this.serialInfo;
    }

    @Override
    public String getMainTag() {
        return MAIN_TAG;
    }
}

